#   $Author: culler $ $Date: 2007/03/28 20:00:37 $ $Revision: 1.7 $

VERSION = "2.0"

about_string = """
Gridlink %s (%s)

Gridlink was written by Marc Culler with advice from
Dylan Thurston and Lenny Ng.  Code by John A. Baldwin and
W. D. Gillam, for computing Heegaard Floer homology, is
embedded in the program.

Development of this software was partially supported
by the National Science Foundation.

Gridlink is freely distributable under the GNU Public License.
Its URL is: http://www.math.uic.edu/~culler/gridlink/

Please send questions or comments to: culler@math.uic.edu
"""%(VERSION, '%s')

splash_string = """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"""

icon_string = """
R0lGODlhMAAwAPcAMf/////////////////////////////////////////////////39//39//3
9//39//39//39//39//39//39//39//39//v7//v7//v7//v7//v7//v7//v7//v7//v7//v7//v
7//n5//n5//n5//n5//n5//n5//n5//n5//n5//n5//n5//e3v/e3v/e3v/e3v/e3v/e3v/e3v/e
3v/e3v/e3v/e3v/W1v/W1v/W1v/W1v/W1v/W1v/W1v/W1v/W1v/W1v/W1v/Ozv/Ozv/Ozv/Ozv/O
zv/Ozv/Ozv/Ozv/Ozv/Ozv/Ozv/Gxv/Gxv/Gxv/Gxv/Gxv/Gxv/Gxv/Gxv/Gxv/Gxv/Gxv+9vf+9
vf+9vf+9vf+9vf+9vf+9vf+9vf+9vf+9vf+9vf+1tf+1tf+1tf+1tf+1tf+1tf+1tf+1tf+1tf+1
tf+1tf+trf+trf+trf+trf+trf+trf+trf+trf+trf+trf+trf+lpf+lpf+lpf+lpf+lpf+lpf+l
pf+lpf+lpf+lpf+lpf+cnP+cnP+cnP+cnP+cnP+cnP+cnP+cnP+cnP+cnP+cnP+UlP+UlP+UlP+U
lP+UlP+UlP+UlP+UlP+UlP+UlP+UlP+MjP+MjP+MjP+MjP+MjP+MjP+MjP+MjP+MjP+MjP+MjP+E
hP+EhP+EhP+EhP+EhP+EhP+EhP+EhP+EhP+EhP+EhP97e/97e/97e/97e/97e/97e/97e/97e/97
e/97e/97e/9zc/9zc/9zc/9zc/9zc/9zc/9zc/9zc/9zc/9zc/9zc/85Of85Of85Of85Of85Of85
Of85Of85Of85Of85Of85Of8YGP8YGP8YGP8YGP8YGP8YGP8YGP8YGP8YGP8YGP8YGP8QEP8QEP8Q
EP8QEP8QEP8QEP8QEP8QEP8QEP8QEP8QEP8ICP8ICP8ICP8ICP8ICP8ICP8ICP8ICP8ICP8ICP8I
CP8AAP8AAP8AAP8AAP8AAP8AAP8AAP8AAP8AAP8AAP8AAP8AAAAAACH5BAEAAAAALAAAAAAwADAA
AAj/AAEIHEiwoMGDCBMqXMiwoUMALQpJ3CSxosWLGDNWHMJwE7qPIEOKHElyZCyGhUqqXEny5EKP
6GK9mfkmS82ZNm3e1JkT502Ym1B+zPKw4ZCPLhXCJFp04dGYQtExbZrwadKES6kqzIKUYESKEjmm
lAogSyGKFFtoBWCV4NiQF5Y+DTm16dOgA9+CjDu0xcg3a9vmRZolywUAY4m2KBxraOCug8kOzBoZ
sFauUCu7dRy5blHBAhMTpBz6o2WqoBGb3iy5dGu7H/G6Pg0AZiyJRMcCHqLxIseBmK+Kjhzyje4L
LEFeTa179EizfZMjPSyQOWeBi32KXd3CJ8+aY5dD9p4d1fNB5DGpsx2v+jXC5gvRX8Usuz3t99cT
+s1cnf1whfApJB9B1qFz30H/AXDBEAw2qOB0C0LHX3vmGRTgeiIZ1pVJrB1oYX5zgfSGfPuFJFx+
+BlI4EfHxBJLUPud9IaLNP5G3kIXBkeQfOqlWGFBCaY2II6rEaniQEKy52N5K04YY1QeAvlRIRdU
iaFLVcbYI4IochmSNC1YdYE0Il2VYpSs0RVciNMZ+SNBWdDoYiFXIianTFA2ZKV6gh1mZUMJfqbk
QxcKOmFRgT6ko1ZjbdLgo5BGymB4a+klnUpmEnppcpk6NMSdoIYq6ptrlWrqqVoFBAA7"""

knot_dict = {
'3_1' : [1,1,1],
'4_1' : [1,-2,1,-2],
'5_1' : [1,1,1,1,1],
'5_2' : [1,1,1,2,-1,2],
'6_1' : [1,1,2,-1,-3,2,-3],
'6_2' : [1,1,1,-2,1,-2],
'6_3' : [1,1,-2,1,-2,-2],
'7_1' : [1,1,1,1,1,1,1],
'7_2' : [1,1,1,2,-1,2,3,-2,3],
'7_3' : [1,1,1,1,1,2,-1,2],
'7_4' : [1,1,2,-1,2,2,3,-2,3],
'7_5' : [1,1,1,1,2,-1,2,2],
'7_6' : [1,1,-2,1,3,-2,3],
'7_7' : [1,-2,1,-2,3,-2,3],
'8_1' : [1,1,2,-1,2,3,-2,-4,3,-4],
'8_2' : [1,1,1,1,1,-2,1,-2],
'8_3' : [1,1,2,-1,-3,2,-3,-4,3,-4],
'8_4' : [1,1,1,-2,1,-2,-3,2,-3],
'8_5' : [1,1,1,-2,1,1,1,-2],
'8_6' : [1,1,1,1,2,-1,-3,2,-3],
'8_7' : [1,1,1,1,-2,1,-2,-2],
'8_8' : [1,1,1,2,-1,-3,2,-3,-3],
'8_9' : [1,1,1,-2,1,-2,-2,-2],
'8_10' : [1,1,1,-2,1,1,-2,-2],
'8_11' : [1,1,2,-1,2,2,-3,2,-3],
'8_12' : [1,-2,1,3,-2,-4,3,-4],
'8_13' : [1,1,-2,1,-2,-2,-3,2,-3],
'8_14' : [1,1,1,2,-1,2,-3,2,-3],
'8_15' : [1,1,-2,1,3,2,2,2,3],
'8_16' : [1,1,-2,1,1,-2,1,-2],
'8_17' : [1,1,-2,1,-2,1,-2,-2],
'8_18' : [1,-2,1,-2,1,-2,1,-2],
'8_19' : [1,1,1,2,1,1,1,2],
'8_20' : [1,1,1,-2,-1,-1,-1,-2],
'8_21' : [1,1,1,2,-1,-1,2,2],
'9_1' : [1,1,1,1,1,1,1,1,1],
'9_2' : [1,1,1,2,-1,2,3,-2,3,4,-3,4],
'9_3' : [1,1,1,1,1,1,1,2,-1,2],
'9_4' : [1,1,1,1,1,2,-1,2,3,-2,3],
'9_5' : [1,1,2,-1,2,2,3,-2,3,4,-3,4],
'9_6' : [1,1,1,1,1,1,2,-1,2,2],
'9_7' : [1,1,1,1,2,-1,2,3,-2,3,3],
'9_8' : [1,1,-2,1,-2,-3,2,4,-3,4],
'9_9' : [1,1,1,1,1,2,-1,2,2,2],
'9_10' : [1,1,2,-1,2,2,2,2,3,-2,3],
'9_11' : [1,1,1,1,-2,1,3,-2,3],
'9_12' : [1,1,-2,1,3,-2,3,4,-3,4],
'9_13' : [1,1,1,1,2,-1,2,2,3,-2,3],
'9_14' : [1,1,2,-1,-3,2,-3,4,-3,4],
'9_15' : [1,1,1,2,-1,-3,2,4,-3,4],
'9_16' : [1,1,1,1,2,2,-1,2,2,2],
'9_17' : [1,-2,1,-2,-2,-2,3,-2,3],
'9_18' : [1,1,1,2,-1,2,2,2,3,-2,3],
'9_19' : [1,-2,1,-2,-2,-3,2,4,-3,4],
'9_20' : [1,1,1,-2,1,3,-2,3,3],
'9_21' : [1,1,2,-1,2,-3,2,4,-3,4],
'9_22' : [1,-2,1,-2,3,-2,-2,-2,3],
'9_23' : [1,1,1,2,-1,2,2,3,-2,3,3],
'9_24' : [1,1,-2,1,3,-2,-2,-2,3],
'9_25' : [1,1,-2,1,3,2,2,-4,3,-4],
'9_26' : [1,1,1,-2,1,-2,3,-2,3],
'9_27' : [1,1,-2,1,-2,-2,3,-2,3],
'9_28' : [1,1,-2,1,3,-2,-2,3,3],
'9_29' : [1,-2,-2,3,-2,1,-2,3,-2],
'9_30' : [1,1,-2,-2,1,-2,3,-2,3],
'9_31' : [1,1,-2,1,-2,3,-2,3,3],
'9_32' : [1,1,-2,1,-2,1,3,-2,3],
'9_33' : [1,-2,1,-2,-2,1,3,-2,3],
'9_34' : [1,-2,1,-2,3,-2,1,-2,3],
'9_35' : [1,1,2,-1,2,2,3,-2,-2,4,-3,2,4,3],
'9_36' : [1,1,1,-2,1,1,3,-2,3],
'9_37' : [1,1,-2,1,3,-2,-1,-4,3,-2,3,-4],
'9_38' : [1,1,2,2,-3,2,-1,2,3,3,2],
'9_39' : [1,1,2,-1,-3,-2,1,4,3,-2,3,4],
'9_40' : [1,-2,1,3,-2,1,3,-2,3],
'9_41' : [1,1,2,-1,-3,-2,-2,4,3,-2,3,4],
'9_42' : [1,1,1,-2,-1,-1,3,-2,3],
'9_43' : [1,1,1,2,1,1,-3,2,-3],
'9_44' : [1,1,1,2,-1,-1,-3,2,-3],
'9_45' : [1,1,2,-1,2,1,3,-2,3],
'9_46' : [1,-2,1,-2,3,2,-1,2,3],
'9_47' : [1,-2,1,-2,-3,-2,1,-2,-3],
'9_48' : [1,1,2,-1,2,1,-3,2,-1,2,-3],
'9_49' : [1,1,2,1,1,-3,2,-1,2,3,3],
'10_1' : [1,1,2,-1,2,3,-2,3,4,-3,-5,4,-5],
'10_2' : [1,1,1,1,1,1,1,-2,1,-2],
'10_3' : [1,1,2,-1,2,3,-2,-4,3,-4,-5,4,-5],
'10_4' : [1,1,1,-2,1,-2,-3,2,-3,-4,3,-4],
'10_5' : [1,1,1,1,1,1,-2,1,-2,-2],
'10_6' : [1,1,1,1,1,1,2,-1,-3,2,-3],
'10_7' : [1,1,2,-1,2,3,-2,3,3,-4,3,-4],
'10_8' : [1,1,1,1,1,-2,1,-2,-3,2,-3],
'10_9' : [1,1,1,1,1,-2,1,-2,-2,-2],
'10_10' : [1,1,-2,1,-2,-2,-3,2,-3,-4,3,-4],
'10_11' : [1,1,1,1,2,-1,-3,2,-3,-4,3,-4],
'10_12' : [1,1,1,1,1,2,-1,-3,2,-3,-3],
'10_13' : [1,1,2,-1,-3,2,4,-3,-5,4,-5],
'10_14' : [1,1,1,1,1,2,-1,2,-3,2,-3],
'10_15' : [1,1,1,1,-2,1,-2,-3,2,-3,-3],
'10_16' : [1,1,2,-1,2,2,-3,2,-3,-4,3,-4],
'10_17' : [1,1,1,1,-2,1,-2,-2,-2,-2],
'10_18' : [1,1,1,2,-1,2,-3,2,-3,-4,3,-4],
'10_19' : [1,1,1,1,-2,1,-2,-2,-3,2,-3],
'10_20' : [1,1,1,1,2,-1,2,3,-2,-4,3,-4],
'10_21' : [1,1,2,-1,2,2,2,2,-3,2,-3],
'10_22' : [1,1,1,1,2,-1,-3,2,-3,-3,-3],
'10_23' : [1,1,-2,1,-2,-2,-2,-2,-3,2,-3],
'10_24' : [1,1,2,-1,2,2,2,3,-2,-4,3,-4],
'10_25' : [1,1,1,1,2,-1,2,2,-3,2,-3],
'10_26' : [1,1,1,-2,1,-2,-2,-2,-3,2,-3],
'10_27' : [1,1,1,1,2,-1,2,-3,2,-3,-3],
'10_28' : [1,1,2,-1,2,2,3,-2,-4,3,-4,-4],
'10_29' : [1,1,1,-2,1,3,-2,-4,3,-4],
'10_30' : [1,1,2,-1,2,2,3,-2,3,-4,3,-4],
'10_31' : [1,1,1,2,-1,-3,2,-3,-3,-4,3,-4],
'10_32' : [1,1,1,-2,1,-2,-2,-3,2,-3,-3],
'10_33' : [1,1,2,-1,2,-3,2,-3,-3,-4,3,-4],
'10_34' : [1,1,1,2,-1,2,3,-2,-4,3,-4,-4],
'10_35' : [1,-2,1,-2,-3,2,4,-3,-5,4,-5],
'10_36' : [1,1,1,2,-1,2,3,-2,3,-4,3,-4],
'10_37' : [1,1,1,2,-1,-3,2,-3,-4,3,-4,-4],
'10_38' : [1,1,1,2,-1,2,2,3,-2,-4,3,-4],
'10_39' : [1,1,1,2,-1,2,2,2,-3,2,-3],
'10_40' : [1,1,1,2,-1,2,2,-3,2,-3,-3],
'10_41' : [1,-2,1,-2,-2,3,-2,-4,3,-4],
'10_42' : [1,1,-2,1,-2,3,-2,-4,3,-4],
'10_43' : [1,1,-2,1,3,-2,-4,3,-4,-4],
'10_44' : [1,1,-2,1,3,-2,3,-4,3,-4],
'10_45' : [1,-2,1,-2,3,-2,3,-4,3,-4],
'10_46' : [1,1,1,1,1,-2,1,1,1,-2],
'10_47' : [1,1,1,1,1,-2,1,1,-2,-2],
'10_48' : [1,1,1,1,-2,-2,1,-2,-2,-2],
'10_49' : [1,1,1,1,-2,1,3,2,2,2,3],
'10_50' : [1,1,2,-1,2,2,-3,2,2,2,-3],
'10_51' : [1,1,2,-1,2,2,-3,2,2,-3,-3],
'10_52' : [1,1,1,-2,1,1,-2,-2,-3,2,-3],
'10_53' : [1,1,2,-1,2,-3,2,4,3,3,3,4],
'10_54' : [1,1,1,-2,1,1,-2,-3,2,-3,-3],
'10_55' : [1,1,1,2,-1,-3,2,4,3,3,3,4],
'10_56' : [1,1,1,2,-1,2,-3,2,2,2,-3],
'10_57' : [1,1,1,2,-1,2,-3,2,2,-3,-3],
'10_58' : [1,-2,1,3,-2,-4,-3,-3,5,-4,5],
'10_59' : [1,-2,1,-2,3,-2,-2,-4,3,-4],
'10_60' : [1,-2,1,-2,-2,3,-2,3,2,4,-3,4],
'10_61' : [1,1,1,-2,1,1,1,-2,-3,2,-3],
'10_62' : [1,1,1,1,-2,1,1,1,-2,-2],
'10_63' : [1,1,-2,1,3,2,2,2,3,4,-3,4],
'10_64' : [1,1,1,-2,1,1,1,-2,-2,-2],
'10_65' : [1,1,2,-1,2,-3,2,2,2,-3,-3],
'10_66' : [1,1,1,-2,1,3,2,2,2,3,3],
'10_67' : [1,1,1,2,-1,2,3,-2,-2,-4,3,2,-4,3],
'10_68' : [1,1,-2,1,-2,-2,-3,2,2,-4,3,-2,-4,-3],
'10_69' : [1,1,2,-1,-3,2,1,4,-3,2,-3,4],
'10_70' : [1,-2,1,3,-2,-2,-2,-4,3,-4],
'10_71' : [1,1,-2,1,3,-2,-2,-4,3,-4],
'10_72' : [1,1,1,1,2,2,-1,2,-3,2,-3],
'10_73' : [1,1,2,-1,2,1,-3,2,-3,4,-3,4],
'10_74' : [1,1,2,-1,2,2,3,-2,-2,-4,3,2,-4,3],
'10_75' : [1,-2,1,-2,3,-2,-2,4,-3,2,4,3],
'10_76' : [1,1,1,1,2,-1,-3,2,2,2,-3],
'10_77' : [1,1,1,1,2,-1,-3,2,2,-3,-3],
'10_78' : [1,1,2,-1,2,1,-3,2,4,-3,4,4],
'10_79' : [1,1,1,-2,-2,1,1,-2,-2,-2],
'10_80' : [1,1,1,-2,1,1,3,2,2,2,3],
'10_81' : [1,1,-2,1,3,2,2,-4,-3,-3,-3,-4],
'10_82' : [1,1,1,1,-2,1,-2,1,-2,-2],
'10_83' : [1,1,2,-1,2,-3,2,2,-3,2,-3],
'10_84' : [1,1,1,2,-1,-3,2,2,-3,2,-3],
'10_85' : [1,1,1,1,-2,1,1,-2,1,-2],
'10_86' : [1,1,-2,1,-2,1,-2,-2,-3,2,-3],
'10_87' : [1,1,1,2,-1,-3,2,-3,2,-3,-3],
'10_88' : [1,-2,1,3,-2,3,-2,-4,3,-4],
'10_89' : [1,-2,1,-2,-3,2,1,4,3,-2,3,4],
'10_90' : [1,1,-2,1,-2,-3,2,1,-3,-2,-2],
'10_91' : [1,1,1,-2,1,-2,-2,1,-2,-2],
'10_92' : [1,1,1,2,2,-3,2,-1,2,-3,2],
'10_93' : [1,1,-2,1,1,-2,1,-2,-3,2,-3],
'10_94' : [1,1,1,-2,1,1,-2,-2,1,-2],
'10_95' : [1,1,-2,-2,3,-2,1,-2,-3,-3,-2],
'10_96' : [1,-2,-1,3,-2,-1,3,-4,3,-2,3,-4],
'10_97' : [1,1,2,-1,2,1,-3,2,-1,2,3,-4,3,-4],
'10_98' : [1,1,2,2,-3,2,-1,2,2,-3,2],
'10_99' : [1,1,-2,1,1,-2,-2,1,-2,-2],
'10_100' : [1,1,1,-2,1,1,-2,1,1,-2],
'10_101' : [1,1,1,2,-1,3,-2,1,3,2,2,4,-3,4],
'10_102' : [1,1,-2,1,3,-2,1,-2,-2,-3,-3],
'10_103' : [1,1,2,-1,-3,2,2,-3,2,2,-3],
'10_104' : [1,1,1,-2,-2,1,-2,1,-2,-2],
'10_105' : [1,1,-2,1,3,2,2,-4,-3,2,-3,-4],
'10_106' : [1,1,1,-2,1,-2,1,1,-2,-2],
'10_107' : [1,1,-2,1,-3,-2,-2,4,-3,2,-3,4],
'10_108' : [1,1,-2,1,1,3,-2,1,-2,-3,-3],
'10_109' : [1,1,-2,1,-2,-2,1,1,-2,-2],
'10_110' : [1,-2,1,3,2,2,2,-4,-3,2,-3,-4],
'10_111' : [1,1,2,2,-3,2,2,-1,2,-3,2],
'10_112' : [1,1,1,-2,1,-2,1,-2,1,-2],
'10_113' : [1,1,1,2,-3,2,-1,2,-3,2,-3],
'10_114' : [1,1,2,-1,-3,2,-3,2,-3,2,-3],
'10_115' : [1,-2,1,3,2,2,-4,-3,2,-3,-3,-4],
'10_116' : [1,1,-2,1,1,-2,1,-2,1,-2],
'10_117' : [1,1,2,2,-3,2,-1,2,-3,2,-3],
'10_118' : [1,1,-2,1,-2,1,-2,-2,1,-2],
'10_119' : [1,1,-2,1,3,-2,1,-2,-3,-3,-2],
'10_120' : [1,1,2,-1,-3,-2,1,4,3,2,2,3,3,4],
'10_121' : [1,1,2,-3,2,-1,2,-3,2,-3,2],
'10_122' : [1,1,2,-3,2,-1,-3,2,-3,2,-3],
'10_123' : [1,-2,1,-2,1,-2,1,-2,1,-2],
'10_124' : [1,1,1,1,1,2,1,1,1,2],
'10_125' : [1,1,1,1,1,-2,-1,-1,-1,-2],
'10_126' : [1,1,1,1,1,2,-1,-1,-1,2],
'10_127' : [1,1,1,1,1,2,-1,-1,2,2],
'10_128' : [1,1,1,2,1,1,2,2,3,-2,3],
'10_129' : [1,1,1,-2,-1,-1,3,-2,-1,3,-2],
'10_130' : [1,1,1,-2,-1,-1,-2,-2,-3,2,-3],
'10_131' : [1,1,1,2,-1,-1,2,2,3,-2,3],
'10_132' : [1,1,1,-2,-1,-1,-2,-3,2,-3,-3],
'10_133' : [1,1,1,2,-1,-1,2,3,-2,3,3],
'10_134' : [1,1,1,2,1,1,2,3,-2,3,3],
'10_135' : [1,1,1,2,-1,2,-3,-2,-2,-2,-3],
'10_136' : [1,-2,1,-2,-3,2,2,4,-3,4],
'10_137' : [1,-2,1,-2,3,2,2,-4,3,-4],
'10_138' : [1,-2,1,-2,-3,-2,-2,4,-3,4],
'10_139' : [1,1,1,1,2,1,1,1,2,2],
'10_140' : [1,1,1,-2,-1,-1,-1,-2,-3,2,-3],
'10_141' : [1,1,1,1,-2,-1,-1,-1,-2,-2],
'10_142' : [1,1,1,2,1,1,1,2,3,-2,3],
'10_143' : [1,1,1,1,2,-1,-1,-1,2,2],
'10_144' : [1,1,2,-1,2,1,-3,2,1,-3,-2],
'10_145' : [1,1,2,-1,2,1,3,2,-1,2,3],
'10_146' : [1,1,-2,1,-2,-1,3,-2,1,-2,3],
'10_147' : [1,1,1,-2,1,-2,-3,2,-1,2,-3],
'10_148' : [1,1,1,1,2,-1,-1,2,-1,2],
'10_149' : [1,1,1,1,2,-1,2,-1,2,2],
'10_150' : [1,1,1,-2,1,1,3,-2,-1,3,2],
'10_151' : [1,1,1,2,-1,-1,3,-2,1,3,-2],
'10_152' : [1,1,1,2,2,1,1,2,2,2],
'10_153' : [1,1,1,2,1,1,-3,-2,-2,-2,-3],
'10_154' : [1,1,2,-1,2,1,3,2,2,2,3],
'10_155' : [1,1,1,2,-1,-1,2,-1,-1,2],
'10_156' : [1,1,1,-2,-1,-1,3,2,-1,2,3],
'10_157' : [1,1,1,2,2,-1,2,-1,2,2],
'10_158' : [1,1,1,2,-1,-1,-3,-2,1,-2,-3],
'10_159' : [1,1,1,2,-1,2,-1,-1,2,2],
'10_160' : [1,1,1,2,1,1,-3,2,-1,2,-3],
'10_161' : [1,1,1,2,-1,2,1,1,2,2],
'10_162' : [1,1,2,-1,-1,2,2,1,-3,2,-3],
'10_163' : [1,1,-2,-1,-1,3,2,-1,2,2,3],
'10_164' : [1,1,-2,1,-2,-2,-3,2,-1,2,-3],
'10_165' : [1,1,2,-1,-3,2,-1,2,3,3,2],
'11a_1' : [1,1,1,2,-1,2,2,-3,2,-3,-2,-4,3,-4],
'11a_2' : [1,1,-2,1,3,3,2,2,3,-4,3,-4],
'11a_3' : [1,1,1,-2,-2,1,1,-2,3,-2,3],
'11a_4' : [1,1,1,2,-1,-3,-3,2,-3,4,-3,4],
'11a_5' : [1,-2,1,-2,-2,-3,2,4,3,3,-5,4,-5],
'11a_6' : [1,-2,1,-2,-2,-3,-3,2,-3,4,-3,4],
'11a_7' : [1,1,1,1,-2,-2,1,-2,3,-2,3],
'11a_8' : [1,1,2,-1,2,-3,-3,2,-3,4,-3,4],
'11a_9' : [1,-2,1,-2,3,-2,-2,-2,-2,-2,3],
'11a_10' : [1,1,2,-1,2,2,2,-3,2,-3,-2,-4,3,-4],
'11a_11' : [1,1,-2,1,-2,-3,-3,2,-3,4,-3,4],
'11a_12' : [1,-2,1,-2,-2,-3,2,4,-3,-3,-3,4],
'11a_13' : [1,-2,1,-2,-2,-3,2,-3,-4,3,5,-4,5],
'11a_14' : [1,1,-2,-2,1,-2,3,-2,-2,3,3],
'11a_15' : [1,1,-2,-2,1,-2,3,-2,-2,-2,3],
'11a_16' : [1,1,-2,-2,1,-2,-2,-3,2,4,-3,4],
'11a_17' : [1,1,-2,1,3,2,2,-4,-3,-3,5,-4,5],
'11a_18' : [1,1,-2,1,3,-2,-2,-4,-3,-3,-3,-4],
'11a_19' : [1,1,-2,1,-2,1,3,-2,-2,3,3],
'11a_20' : [1,1,-2,1,3,2,2,-4,3,3,3,-4],
'11a_21' : [1,1,-2,1,3,2,2,3,4,-3,-5,4,-5],
'11a_22' : [1,1,1,-2,1,1,3,-2,-2,3,3],
'11a_23' : [1,1,1,2,-1,-3,2,4,-3,-3,4,4],
'11a_24' : [1,1,1,2,-1,-1,3,-2,-2,3,-2,3,-2],
'11a_25' : [1,1,1,2,-1,-1,3,-2,3,-2,3,3,-2],
'11a_26' : [1,1,-2,-2,1,3,-2,-2,3,-2,3],
'11a_27' : [1,1,1,2,-1,-3,2,-3,2,4,-3,4],
'11a_28' : [1,1,-2,1,-2,-2,-2,1,3,-2,3],
'11a_29' : [1,1,-2,1,-2,1,-3,2,1,4,-3,-2,4,-3],
'11a_30' : [1,1,2,-1,2,-3,-2,1,-2,-2,3,-4,3,-4],
'11a_31' : [1,1,-2,1,3,2,2,3,3,-4,3,-4],
'11a_32' : [1,1,-2,1,-2,3,-2,-4,-3,-3,-3,-4],
'11a_33' : [1,1,-2,-2,1,-2,-2,-2,3,-2,3],
'11a_34' : [1,1,1,-2,1,-2,3,-2,-2,3,3],
'11a_35' : [1,1,-2,1,-2,-2,3,-2,-2,3,3],
'11a_36' : [1,1,1,2,-1,2,2,3,-2,-4,-3,-3,-3,-4],
'11a_37' : [1,1,2,-1,-3,2,-3,4,-3,-3,4,4],
'11a_38' : [1,1,2,-1,3,-2,-1,3,3,-2,-4,3,-2,-4],
'11a_39' : [1,1,1,-2,1,3,-2,-4,-3,-3,-3,-4],
'11a_40' : [1,1,1,1,-2,1,3,-2,-2,3,3],
'11a_41' : [1,1,2,-1,2,-3,2,4,-3,-3,4,4],
'11a_42' : [1,1,2,-1,2,1,-3,2,4,-3,-5,4,-5],
'11a_43' : [1,1,2,-1,2,1,-3,2,4,3,3,3,4,4],
'11a_44' : [1,1,1,1,2,2,-1,-3,-2,-2,-2,-3,-3],
'11a_45' : [1,1,-2,1,3,2,2,-4,3,-4,-5,4,-5],
'11a_46' : [1,1,-2,1,-2,-3,2,4,-3,-3,4,4],
'11a_47' : [1,1,-2,-2,1,3,-2,-2,-2,3,3],
'11a_48' : [1,1,1,2,-1,2,-3,2,2,4,-3,4],
'11a_49' : [1,1,1,-2,1,1,3,2,2,-4,3,-4],
'11a_50' : [1,1,1,2,-1,-3,2,4,3,3,-5,4,-5],
'11a_51' : [1,-2,1,3,-2,-4,3,3,5,-4,5],
'11a_52' : [1,1,1,2,-1,2,-3,2,-3,-3,-2,-4,3,-4],
'11a_53' : [1,1,1,1,-2,1,-2,1,3,-2,3],
'11a_54' : [1,1,2,-1,2,-3,2,-3,2,4,-3,4],
'11a_55' : [1,1,-2,1,3,-2,-2,-2,-2,-2,3],
'11a_56' : [1,1,2,-1,2,1,-3,2,-3,-3,-3,-4,3,-4],
'11a_57' : [1,1,1,1,-2,-2,-1,-3,2,2,2,-3,-3],
'11a_58' : [1,1,-2,1,-2,-3,2,4,-3,-3,-3,4],
'11a_59' : [1,1,-2,1,-2,-3,2,-3,-4,3,5,-4,5],
'11a_60' : [1,1,1,1,-2,1,3,2,2,-4,3,-4],
'11a_61' : [1,1,2,-1,2,-3,2,4,3,3,-5,4,-5],
'11a_62' : [1,1,1,1,1,-2,1,1,3,-2,3],
'11a_63' : [1,1,2,-1,2,2,-3,2,2,4,-3,4],
'11a_64' : [1,1,1,1,2,-1,-3,2,2,4,-3,4],
'11a_65' : [1,1,1,2,-1,2,3,-2,-4,3,5,-4,5],
'11a_66' : [1,1,1,-2,1,-2,-2,1,3,-2,3],
'11a_67' : [1,1,2,-1,-3,2,-3,-3,2,4,-3,4],
'11a_68' : [1,-2,1,-2,-2,-2,-2,1,3,-2,3],
'11a_69' : [1,1,2,-1,2,2,-3,2,-3,-3,-2,-4,3,-4],
'11a_70' : [1,1,1,-2,1,3,-2,-1,3,-4,3,-2,3,-4],
'11a_71' : [1,1,-2,1,-2,1,-2,3,-2,3,3],
'11a_72' : [1,1,-2,1,-2,3,-2,-2,3,-2,3],
'11a_73' : [1,-2,1,-2,1,-2,1,-2,3,-2,3],
'11a_74' : [1,-2,1,-2,-2,-2,3,-2,-2,-2,3],
'11a_75' : [1,-2,1,-2,-2,-2,-2,-3,2,4,-3,4],
'11a_76' : [1,1,-2,1,-2,3,-2,1,3,-2,-2],
'11a_77' : [1,1,1,2,-1,2,-3,2,-3,4,-3,4],
'11a_78' : [1,1,1,2,-1,2,-3,2,2,-4,3,-2,-4,-3],
'11a_79' : [1,1,-2,1,1,-2,1,-2,3,-2,3],
'11a_80' : [1,1,-2,1,-2,1,-2,-2,3,-2,3],
'11a_81' : [1,-2,1,-2,-2,1,-2,-2,3,-2,3],
'11a_82' : [1,1,-2,1,-2,-2,3,-2,-2,-2,3],
'11a_83' : [1,1,1,-2,1,1,-2,3,-2,3,3],
'11a_84' : [1,1,-2,1,-2,-2,-2,-3,2,4,-3,4],
'11a_85' : [1,1,1,2,-1,-3,2,-3,4,-3,4,4],
'11a_86' : [1,1,-2,-2,-2,-2,1,-2,3,-2,3],
'11a_87' : [1,1,2,-1,2,2,3,-2,-4,-3,2,-3,-3,-4],
'11a_88' : [1,1,1,-2,-2,-2,1,-2,3,-2,3],
'11a_89' : [1,-2,1,-2,-2,-2,-3,2,-3,4,-3,4],
'11a_90' : [1,1,1,-2,1,-2,-3,2,-3,4,-3,4],
'11a_91' : [1,1,-2,1,-2,-2,-3,2,-3,4,-3,4],
'11a_92' : [1,1,1,-2,1,1,-2,-2,3,-2,3],
'11a_93' : [1,1,1,2,-1,-3,2,-3,-3,4,-3,4],
'11a_94' : [1,1,1,1,2,2,-1,2,2,3,-2,3,3],
'11a_95' : [1,1,1,2,-1,2,2,3,-2,3,4,-3,4,4],
'11a_96' : [1,-2,1,-2,3,-2,-4,3,5,-4,5],
'11a_97' : [1,1,2,-1,-3,-3,-3,2,-3,4,-3,4],
'11a_98' : [1,1,2,-1,-3,2,-3,-4,3,-4,5,-4,5],
'11a_99' : [1,-2,1,-2,3,-2,-2,3,-2,-2,3],
'11a_100' : [1,1,-2,1,3,2,2,2,3,-4,3,-4],
'11a_101' : [1,1,1,2,-1,-3,-2,-2,4,3,-2,3,3,4],
'11a_102' : [1,1,-2,1,3,-2,-1,-4,3,-2,3,3,3,-4],
'11a_103' : [1,1,2,-1,2,-3,2,2,4,-3,-2,-5,4,-3,-5],
'11a_104' : [1,1,1,2,-1,3,-2,-1,3,-2,-4,3,-2,-4],
'11a_105' : [1,1,1,-2,1,3,2,2,2,-4,3,-4],
'11a_106' : [1,1,-2,1,3,-2,-2,-2,-2,3,3],
'11a_107' : [1,1,2,-1,2,2,3,-2,-4,-3,-3,-3,-4,-4],
'11a_108' : [1,1,-2,-2,-2,1,-2,-2,3,-2,3],
'11a_109' : [1,1,-2,1,-2,3,-2,-2,-2,3,3],
'11a_110' : [1,1,-2,1,-2,-3,2,-3,-3,4,-3,4],
'11a_111' : [1,1,-2,1,-2,-2,-3,2,4,-3,4,4],
'11a_112' : [1,1,-2,1,3,-2,1,-2,-2,-2,3],
'11a_113' : [1,1,1,-2,1,1,3,-2,1,-2,3],
'11a_114' : [1,1,1,2,-1,3,2,2,-4,3,-2,3,-4,-4],
'11a_115' : [1,1,1,2,-1,-3,-2,-2,-2,4,3,-2,3,4],
'11a_116' : [1,1,1,2,-1,-3,-2,1,4,3,-2,3,4,4],
'11a_117' : [1,1,1,2,-1,2,-3,2,4,-3,4,4],
'11a_118' : [1,-2,1,-2,-3,2,-3,4,-3,-3,-3,4],
'11a_119' : [1,-2,1,-2,-3,2,-3,-3,-4,3,5,-4,5],
'11a_120' : [1,1,1,2,-1,2,2,-3,2,4,-3,4],
'11a_121' : [1,-2,1,3,-2,3,-4,3,5,-4,5],
'11a_122' : [1,1,2,-1,-3,2,2,4,-3,2,-3,4],
'11a_123' : [1,1,1,2,-1,2,3,-2,3,2,-4,3,-2,3,4,4],
'11a_124' : [1,1,1,2,2,-3,2,-1,2,3,3,3,2],
'11a_125' : [1,1,-2,1,3,-2,1,-2,3,3,-2],
'11a_126' : [1,1,-2,-2,3,-2,1,-2,3,3,-2],
'11a_127' : [1,1,-2,1,1,-2,1,3,-2,3,3],
'11a_128' : [1,-2,-1,3,-2,-1,3,-2,-4,3,5,-4,5],
'11a_129' : [1,1,1,-2,1,1,3,-2,1,3,-2],
'11a_130' : [1,1,2,-1,-3,2,2,4,-3,2,4,-3],
'11a_131' : [1,1,-2,1,1,3,-2,1,-2,-2,3],
'11a_132' : [1,1,1,-2,1,1,3,-2,-1,3,-2,-4,3,-4],
'11a_133' : [1,1,2,-1,-3,2,4,3,3,3,-5,4,-5],
'11a_134' : [1,1,-2,1,3,2,2,2,-4,3,-4,-4],
'11a_135' : [1,-2,1,-2,3,-2,1,-2,-3,4,-3,4],
'11a_136' : [1,1,2,-3,2,-1,2,4,-3,2,-3,4],
'11a_137' : [1,1,-2,1,-2,-1,-3,2,1,4,-3,2,4,-3],
'11a_138' : [1,1,-2,1,-2,1,3,-2,-1,3,-2,-4,3,-4],
'11a_139' : [1,1,1,-2,1,3,-2,-2,-2,3,3],
'11a_140' : [1,1,1,-2,1,-2,-3,2,4,-3,4,4],
'11a_141' : [1,1,-2,1,-2,1,-2,-3,2,4,-3,4],
'11a_142' : [1,1,1,1,-2,1,1,1,3,-2,3],
'11a_143' : [1,1,2,-1,2,-3,2,2,2,4,-3,4],
'11a_144' : [1,1,1,1,1,2,-1,-3,2,4,-3,4],
'11a_145' : [1,1,2,-1,2,2,3,-2,-4,3,5,-4,5],
'11a_146' : [1,1,1,-2,1,3,-2,1,-2,-2,3],
'11a_147' : [1,1,-2,1,3,-2,1,3,3,-2,-2],
'11a_148' : [1,1,2,-1,3,-2,1,3,2,2,4,-3,-5,4,-5],
'11a_149' : [1,-2,1,-2,-3,-3,4,-3,2,-3,4,-3],
'11a_150' : [1,1,2,2,-3,2,-1,2,4,-3,2,4],
'11a_151' : [1,1,1,-2,1,3,-2,1,3,-2,-2],
'11a_152' : [1,1,2,-1,-3,2,4,-3,2,4,-3,-3],
'11a_153' : [1,1,1,2,-1,-3,2,4,-3,-3,-3,4],
'11a_154' : [1,1,1,2,-1,-3,2,-3,-4,3,5,-4,5],
'11a_155' : [1,1,2,-1,-3,-2,1,4,3,-2,-2,3,3,4],
'11a_156' : [1,1,1,-2,1,1,3,-2,-2,-2,3],
'11a_157' : [1,1,-2,1,1,-2,-2,1,3,-2,3],
'11a_158' : [1,1,-2,-2,3,-2,-2,1,-2,3,-2],
'11a_159' : [1,1,-2,1,3,-2,-4,3,5,-4,5],
'11a_160' : [1,1,-2,1,3,-2,-2,3,-2,-2,3],
'11a_161' : [1,1,1,-2,1,1,-2,-3,2,4,-3,4],
'11a_162' : [1,1,-2,1,-2,1,3,-2,1,3,-2],
'11a_163' : [1,-2,1,3,-2,-2,1,-2,-2,-2,3],
'11a_164' : [1,-2,1,-2,1,-2,-2,1,3,-2,3],
'11a_165' : [1,1,-2,1,3,-2,-2,-2,3,4,-3,4],
'11a_166' : [1,1,-2,1,-2,-3,2,4,-3,4,5,-4,5],
'11a_167' : [1,-2,1,-2,-2,1,-2,-3,2,4,-3,4],
'11a_168' : [1,1,2,-1,2,-3,2,2,-3,-3,-2,-4,3,-4],
'11a_169' : [1,1,2,-1,-3,2,4,-3,2,-3,-3,4],
'11a_170' : [1,1,-2,3,-2,1,-2,3,-2,3,-2],
'11a_171' : [1,1,-2,1,3,-2,3,-2,3,-2,3],
'11a_172' : [1,1,-2,1,1,3,-2,-1,-4,3,-2,3,3,-4],
'11a_173' : [1,1,1,-2,1,3,-2,-1,-4,3,-2,3,-4,3],
'11a_174' : [1,1,-2,1,-2,-2,-2,-2,3,-2,3],
'11a_175' : [1,1,-2,1,-2,-2,-2,3,-2,3,3],
'11a_176' : [1,1,1,-2,1,-2,-2,3,-2,3,3],
'11a_177' : [1,1,1,1,-2,1,-2,3,-2,3,3],
'11a_178' : [1,1,-2,1,-2,3,-2,3,3,4,-3,4],
'11a_179' : [1,-2,1,-2,-2,-2,-2,-2,3,-2,3],
'11a_180' : [1,1,1,-2,1,-2,-2,-2,3,-2,3],
'11a_181' : [1,1,2,-1,2,2,-3,2,2,-4,3,-2,-4,-3],
'11a_182' : [1,1,1,1,1,-2,1,-2,3,-2,3],
'11a_183' : [1,1,2,-1,2,2,-3,2,-3,4,-3,4],
'11a_184' : [1,1,1,1,-2,1,-2,-2,3,-2,3],
'11a_185' : [1,1,2,-1,2,-3,2,-3,-3,4,-3,4],
'11a_186' : [1,1,1,2,-1,2,2,2,2,3,-2,3,3],
'11a_187' : [1,1,-2,1,-2,-2,3,-2,-2,-4,3,2,-4,3],
'11a_188' : [1,1,2,-1,-3,2,-3,-3,-3,4,-3,4],
'11a_189' : [1,1,-2,-2,1,-2,1,-2,3,-2,3],
'11a_190' : [1,1,-2,1,-2,-2,3,-2,3,4,-3,4],
'11a_191' : [1,1,1,1,1,2,-1,2,2,3,-2,3,3],
'11a_192' : [1,1,1,2,-1,2,2,3,-2,3,3,4,-3,4],
'11a_193' : [1,1,1,1,2,-1,-3,2,-3,4,-3,4],
'11a_194' : [1,1,1,-2,1,1,1,-2,3,-2,3],
'11a_195' : [1,1,2,-1,2,3,-2,-4,3,-4,5,-4,5],
'11a_196' : [1,1,-2,1,-2,1,1,-2,3,-2,3],
'11a_197' : [1,1,1,2,-1,-3,-2,-2,4,3,-2,3,4,4],
'11a_198' : [1,1,-2,1,-2,-3,2,2,4,-3,-2,4,4,-3],
'11a_199' : [1,1,1,-2,1,-2,3,-2,-2,-4,3,2,-4,3],
'11a_200' : [1,1,1,2,-1,2,2,3,-2,-2,4,-3,2,4,4,3],
'11a_201' : [1,1,-2,1,3,-2,-1,-4,3,-2,3,-4,-5,4,-5],
'11a_202' : [1,1,1,1,-2,1,3,-2,-1,-4,3,-2,3,-4],
'11a_203' : [1,1,1,1,1,-2,1,3,-2,3,3],
'11a_204' : [1,1,2,-1,2,2,-3,2,4,-3,4,4],
'11a_205' : [1,1,1,-2,1,-2,-2,-3,2,4,-3,4],
'11a_206' : [1,1,1,1,1,1,-2,1,3,-2,3],
'11a_207' : [1,1,2,-1,2,2,2,-3,2,4,-3,4],
'11a_208' : [1,1,1,1,2,-1,2,-3,2,4,-3,4],
'11a_209' : [1,1,-2,-1,3,-2,-1,-4,3,2,-4,3,5,-4,5],
'11a_210' : [1,1,2,-1,-3,2,-3,-3,-4,3,5,-4,5],
'11a_211' : [1,1,2,-1,2,3,-2,3,-4,3,5,-4,5],
'11a_212' : [1,1,1,2,-1,3,2,2,-4,3,3,-2,3,-4],
'11a_213' : [1,1,1,2,-1,3,2,2,2,-4,3,-2,3,-4],
'11a_214' : [1,1,2,-1,2,-3,2,4,-3,-2,-5,4,-3,4,-5],
'11a_215' : [1,1,-2,1,1,3,-2,1,-2,3,3],
'11a_216' : [1,1,-2,1,3,-2,1,-2,-2,3,3],
'11a_217' : [1,1,-2,1,3,-2,1,1,-2,-2,3],
'11a_218' : [1,-2,1,3,2,2,-4,-3,2,-3,5,-4,5],
'11a_219' : [1,1,2,-1,2,3,-2,-2,-4,3,2,5,-4,3,5],
'11a_220' : [1,1,1,-2,1,3,-2,3,4,-3,4,4],
'11a_221' : [1,1,1,1,-2,1,3,-2,-2,-2,3],
'11a_222' : [1,1,2,-1,2,-3,2,4,-3,-3,-3,4],
'11a_223' : [1,1,1,-2,1,1,1,3,-2,3,3],
'11a_224' : [1,1,1,1,2,-1,-3,2,4,-3,4,4],
'11a_225' : [1,1,1,1,-2,1,-2,-3,2,4,-3,4],
'11a_226' : [1,1,2,-1,2,-3,2,-3,-4,3,5,-4,5],
'11a_227' : [1,1,1,2,2,-3,2,-1,2,3,3,2,2],
'11a_228' : [1,-2,1,3,2,-4,-3,2,-3,-3,5,-4,5],
'11a_229' : [1,1,1,2,-1,-3,2,4,-3,4,5,-4,5],
'11a_230' : [1,1,2,-1,2,3,-2,-4,3,5,-4,5,5],
'11a_231' : [1,1,-2,-2,-2,1,3,-2,-2,-2,3],
'11a_232' : [1,1,-2,-2,3,-2,1,-2,-2,3,-2],
'11a_233' : [1,1,-2,-2,3,-2,1,-2,3,-2,3],
'11a_234' : [1,1,1,1,1,1,1,1,2,-1,2,2],
'11a_235' : [1,1,1,2,-1,2,2,2,2,2,3,-2,3],
'11a_236' : [1,1,1,1,2,-1,2,2,2,3,-2,3,3],
'11a_237' : [1,1,1,2,-1,2,2,2,3,-2,-2,4,-3,2,4,3],
'11a_238' : [1,1,1,2,-1,2,2,2,3,-2,3,4,-3,4],
'11a_239' : [1,1,-2,3,-2,1,3,-2,3,-2,3],
'11a_240' : [1,1,1,1,1,1,2,2,-1,2,2,2],
'11a_241' : [1,1,1,1,2,2,-1,2,2,2,3,-2,3],
'11a_242' : [1,1,1,1,1,1,2,-1,2,3,-2,3,3],
'11a_243' : [1,1,1,2,-1,2,3,-2,3,3,3,4,-3,4],
'11a_244' : [1,1,1,2,2,-3,2,-1,2,2,3,3,2],
'11a_245' : [1,1,1,1,2,-1,2,3,3,-2,3,3,3],
'11a_246' : [1,1,1,1,2,-1,2,3,-2,3,4,-3,4,4],
'11a_247' : [1,1,1,2,-1,2,3,-2,3,4,-3,4,5,-4,5],
'11a_248' : [1,1,1,-2,3,-2,1,-2,3,-2,3],
'11a_249' : [1,1,2,-1,-3,4,-3,2,-3,4,-3,4],
'11a_250' : [1,-2,-2,-2,1,-2,3,-2,-2,-2,3],
'11a_251' : [1,1,1,1,-2,-2,-1,-3,2,-3,2,-3,-3],
'11a_252' : [1,-2,1,-2,-2,1,3,-2,-2,-2,3],
'11a_253' : [1,1,-2,1,-2,1,3,-2,-2,-2,3],
'11a_254' : [1,1,1,1,-2,-2,-1,-3,2,2,-3,2,-3],
'11a_255' : [1,1,1,-2,1,3,-2,1,-2,3,-2],
'11a_256' : [1,1,2,-1,-3,2,4,-3,2,-3,4,-3],
'11a_257' : [1,1,1,-2,1,-2,3,-2,-2,-2,3],
'11a_258' : [1,1,2,-1,-3,2,-3,4,-3,-3,-3,4],
'11a_259' : [1,1,1,-2,1,1,3,-2,3,3,3],
'11a_260' : [1,1,1,-2,1,1,3,-2,3,4,-3,4],
'11a_261' : [1,1,1,-2,1,3,-2,3,-2,3,3],
'11a_262' : [1,1,-2,1,-2,1,3,-2,3,4,-3,4],
'11a_263' : [1,1,1,1,2,2,-1,3,2,2,2,3,3],
'11a_264' : [1,1,1,-2,1,3,-2,-2,3,-2,3],
'11a_265' : [1,1,2,-1,-3,2,4,-3,-3,4,-3,4],
'11a_266' : [1,-2,1,-2,3,-2,1,3,-2,3,-2],
'11a_267' : [1,1,-2,1,-2,3,-2,1,3,-2,3],
'11a_268' : [1,-2,1,-2,3,-2,1,-2,-2,-2,3],
'11a_269' : [1,-2,1,-2,-2,3,-2,1,-2,3,-2],
'11a_270' : [1,1,2,-1,2,-3,-3,-2,-4,3,-2,3,-4,3],
'11a_271' : [1,1,-2,1,-2,1,3,-2,-1,4,-3,2,4,3],
'11a_272' : [1,1,-2,-1,3,-2,1,-4,3,-2,3,-2,-4,3],
'11a_273' : [1,1,-2,1,-2,3,-2,-1,3,2,2,4,-3,4],
'11a_274' : [1,1,-2,-2,1,3,-2,1,-2,3,-2],
'11a_275' : [1,1,1,-2,1,3,-2,-1,4,-3,2,2,4,3],
'11a_276' : [1,1,-2,1,3,-2,-1,4,-3,2,2,4,3,3],
'11a_277' : [1,1,1,-2,1,-2,3,-2,1,-2,3],
'11a_278' : [1,1,2,-1,-3,2,-3,4,-3,2,-3,4],
'11a_279' : [1,1,2,-1,-3,-2,-2,-2,-2,4,3,-2,3,4],
'11a_280' : [1,1,2,-1,-1,2,3,-2,1,-4,-3,2,-5,4,-3,-5,-4],
'11a_281' : [1,-2,-2,1,-2,3,-2,1,-2,-2,3],
'11a_282' : [1,-2,1,-2,-2,-2,3,-2,1,-2,3],
'11a_283' : [1,1,1,-2,1,-2,3,-2,-1,4,-3,2,4,3],
'11a_284' : [1,1,-2,1,3,-2,1,3,-2,-2,3],
'11a_285' : [1,1,-2,1,1,3,-2,-1,-4,3,-2,-4,3,-4],
'11a_286' : [1,-2,1,-2,-2,3,-2,1,-2,-2,3],
'11a_287' : [1,-2,1,-2,1,3,-2,1,-2,-2,3],
'11a_288' : [1,-2,1,-2,3,-2,1,3,-2,-2,3],
'11a_289' : [1,1,-2,1,-2,-2,3,-2,1,-2,3],
'11a_290' : [1,1,-2,1,-2,-2,3,-2,-1,4,-3,2,4,3],
'11a_291' : [1,1,2,2,2,2,-3,2,-1,2,3,3,2],
'11a_292' : [1,1,2,-1,2,1,-3,2,-1,2,3,3,3,4,-3,4],
'11a_293' : [1,-2,-2,-2,-2,3,-2,1,-2,3,-2],
'11a_294' : [1,1,2,-1,2,-3,-2,-4,3,-2,3,-4,3,3],
'11a_295' : [1,1,1,1,2,-1,-3,-2,1,4,3,-2,3,4],
'11a_296' : [1,1,2,-1,2,3,-2,-4,-3,2,5,4,-3,4,5],
'11a_297' : [1,1,-2,1,1,3,-2,-1,3,-4,3,-2,3,-4],
'11a_298' : [1,1,1,1,2,2,-3,2,-1,2,3,3,2],
'11a_299' : [1,1,2,-1,2,3,3,-4,3,-2,3,4,4,3],
'11a_300' : [1,1,-2,1,3,-2,1,-2,3,-2,-2],
'11a_301' : [1,1,-2,1,3,-2,1,3,-2,3,-2],
'11a_302' : [1,1,-2,1,3,-2,1,3,3,-2,3],
'11a_303' : [1,1,-2,1,-2,-1,-3,2,1,-3,-2,-4,3,-4],
'11a_304' : [1,1,1,-2,1,1,3,-2,-1,4,-3,2,4,3],
'11a_305' : [1,-2,1,-2,-2,3,-2,-2,1,-2,3],
'11a_306' : [1,1,1,-2,1,-2,3,-2,3,3,3],
'11a_307' : [1,1,1,-2,1,-2,3,-2,3,4,-3,4],
'11a_308' : [1,1,1,1,-2,1,3,-2,3,3,3],
'11a_309' : [1,1,1,-2,1,3,-2,3,3,4,-3,4],
'11a_310' : [1,1,1,1,-2,1,3,-2,3,4,-3,4],
'11a_311' : [1,1,2,-1,2,-3,2,4,-3,4,5,-4,5],
'11a_312' : [1,1,1,1,2,-1,-3,-2,-2,4,3,-2,3,4],
'11a_313' : [1,1,2,-1,2,3,-2,-4,-3,-3,5,4,-3,4,5],
'11a_314' : [1,1,-2,1,-2,1,3,-2,1,-2,3],
'11a_315' : [1,1,-2,1,-2,3,-2,1,-2,-2,3],
'11a_316' : [1,1,1,-2,-2,3,-2,1,-2,3,-2],
'11a_317' : [1,1,1,-2,1,-3,2,-1,-3,-2,-2,-4,3,-4],
'11a_318' : [1,1,2,2,-3,2,-1,2,2,3,3,2,2],
'11a_319' : [1,1,2,2,2,-3,2,-1,2,3,3,2,2],
'11a_320' : [1,1,1,2,-1,2,-3,-2,1,4,-3,2,2,4,3,3],
'11a_321' : [1,1,1,-2,1,3,-2,1,3,-2,4,-3,2,4],
'11a_322' : [1,1,-2,1,1,3,-2,-1,-4,3,-2,3,-4,3],
'11a_323' : [1,1,2,-1,-3,-3,4,-3,2,-3,4,-3],
'11a_324' : [1,1,2,-1,-3,2,4,-3,2,4,-3,5,-4,3,5],
'11a_325' : [1,1,2,-1,3,2,2,-4,3,-2,3,-4,-5,4,-5],
'11a_326' : [1,1,-2,1,-2,3,-2,1,-2,3,-2],
'11a_327' : [1,1,2,-1,-3,-2,1,-2,4,3,-2,3,3,4],
'11a_328' : [1,1,-2,1,1,3,-2,-1,4,-3,2,4,3,3],
'11a_329' : [1,1,2,-1,2,-3,-2,1,-4,3,2,2,3,4,4,3],
'11a_330' : [1,-2,-2,-2,3,-2,1,-2,3,-2,-2],
'11a_331' : [1,1,-2,1,3,-2,-1,-4,3,-2,3,3,-4,3],
'11a_332' : [1,-2,1,3,-2,-2,1,3,-2,-2,3],
'11a_333' : [1,1,2,-1,-3,2,-3,4,-3,4,5,-4,5],
'11a_334' : [1,1,1,1,1,1,2,-1,2,2,2,2],
'11a_335' : [1,1,1,1,1,2,-1,2,2,2,3,-2,3],
'11a_336' : [1,1,1,1,1,1,2,-1,2,2,3,-2,3],
'11a_337' : [1,1,2,-1,2,2,2,3,-2,3,3,4,-3,4],
'11a_338' : [1,1,1,1,1,2,2,2,-1,2,2,2],
'11a_339' : [1,1,1,1,1,2,-1,2,3,-2,3,3,3],
'11a_340' : [1,1,1,1,2,2,2,-1,2,2,3,-2,3],
'11a_341' : [1,1,1,1,2,-1,2,3,-2,3,3,4,-3,4],
'11a_342' : [1,1,1,1,1,2,-1,2,3,-2,3,4,-3,4],
'11a_343' : [1,1,2,-1,2,2,3,-2,3,4,-3,4,5,-4,5],
'11a_344' : [1,1,1,1,2,-1,3,2,2,-4,3,-2,3,-4],
'11a_345' : [1,1,2,-1,2,3,-2,4,3,3,-5,4,-3,4,-5],
'11a_346' : [1,-2,-2,-2,3,-2,1,-2,-2,3,-2],
'11a_347' : [1,1,-2,-1,3,-2,1,-4,3,-2,3,3,-4,3],
'11a_348' : [1,1,1,-2,1,3,-2,1,3,-2,3],
'11a_349' : [1,1,2,-1,-3,2,4,-3,2,4,-3,4],
'11a_350' : [1,-2,1,-2,-2,3,-2,1,3,-2,3],
'11a_351' : [1,-2,1,3,-2,1,3,-2,-2,-2,3],
'11a_352' : [1,1,-2,-1,3,-2,1,-2,-4,3,-2,-4,3,-4],
'11a_353' : [1,1,2,2,2,-3,2,-1,2,2,3,3,2],
'11a_354' : [1,1,1,2,-1,2,1,-3,2,-1,2,3,3,4,-3,4],
'11a_355' : [1,1,1,1,1,1,1,2,-1,2,2,2],
'11a_356' : [1,1,1,1,2,-1,2,2,2,2,3,-2,3],
'11a_357' : [1,1,1,1,2,-1,2,2,3,-2,3,3,3],
'11a_358' : [1,1,1,1,1,1,1,2,-1,2,3,-2,3],
'11a_359' : [1,1,2,-1,2,2,2,2,3,-2,3,4,-3,4],
'11a_360' : [1,1,1,1,2,-1,2,2,3,-2,3,4,-3,4],
'11a_361' : [1,1,1,1,2,-1,2,2,3,-2,-2,4,-3,2,4,3],
'11a_362' : [1,1,2,-1,2,2,3,-2,-2,4,-3,2,4,5,-4,3,5],
'11a_363' : [1,1,2,-1,2,3,-2,3,3,4,-3,4,5,-4,5],
'11a_364' : [1,1,1,1,1,1,1,1,1,2,-1,2],
'11a_365' : [1,1,2,-1,2,2,2,2,2,2,3,-2,3],
'11a_366' : [1,1,2,-1,2,2,2,2,3,-2,-2,4,-3,2,4,3],
'11a_367' : [1,1,1,1,1,1,1,1,1,1,1],
'11n_1' : [1,1,1,2,-1,3,-2,3,2,4,-3,4],
'11n_2' : [1,1,1,2,-1,2,3,2,2,-4,3,-4],
'11n_3' : [1,1,1,2,-1,2,-3,-2,-2,4,-3,4],
'11n_4' : [1,1,1,2,-1,-1,-3,2,-1,-3,2],
'11n_5' : [1,1,1,2,-1,-3,2,-1,-3,2,2],
'11n_6' : [1,1,2,-1,2,1,-3,-2,-2,4,-3,4],
'11n_7' : [1,1,1,2,-1,3,-2,3,-2,-4,3,-4],
'11n_8' : [1,1,2,-1,2,1,-3,2,2,4,-3,4],
'11n_9' : [1,1,1,2,2,1,1,2,-3,2,-3],
'11n_10' : [1,1,1,2,-1,2,2,1,3,-2,3],
'11n_11' : [1,1,1,1,2,-1,2,-1,-3,2,-3],
'11n_12' : [1,1,-2,1,-2,-2,3,2,-1,2,3],
'11n_13' : [1,1,1,1,1,2,1,1,-3,2,-3],
'11n_14' : [1,1,1,1,2,-1,2,1,3,-2,3],
'11n_15' : [1,1,1,1,1,2,-1,-1,-3,2,-3],
'11n_16' : [1,1,2,-1,2,2,3,2,2,-4,3,-4],
'11n_17' : [1,1,2,-1,2,3,-2,3,2,4,-3,4],
'11n_18' : [1,1,2,-1,2,2,3,-2,-2,-4,3,-4],
'11n_19' : [1,1,1,1,1,-2,-1,-1,3,-2,3],
'11n_20' : [1,1,2,-1,2,2,-3,-2,-2,4,-3,4],
'11n_21' : [1,1,1,2,-1,-1,-3,2,2,-3,-3],
'11n_22' : [1,1,2,-1,2,1,3,-2,-2,3,3],
'11n_23' : [1,1,1,2,1,1,-3,2,2,-3,-3],
'11n_24' : [1,1,1,-2,-1,-1,3,-2,-2,3,3],
'11n_25' : [1,1,1,-2,1,1,-3,2,-1,-3,2],
'11n_26' : [1,1,2,-1,2,1,3,-2,-2,-2,3],
'11n_27' : [1,1,1,2,1,1,-3,2,2,2,-3],
'11n_28' : [1,1,1,2,-1,-1,2,3,-2,-4,3,-4],
'11n_29' : [1,1,2,-1,-1,2,1,-3,2,4,-3,4],
'11n_30' : [1,1,1,2,1,1,2,3,-2,-4,3,-4],
'11n_31' : [1,1,2,-1,2,1,3,2,2,-4,3,-4],
'11n_32' : [1,1,1,2,-1,-1,-3,-2,-2,4,-3,4],
'11n_33' : [1,1,1,-2,-1,-1,3,2,2,-4,3,-4],
'11n_34' : [1,1,-2,1,-2,1,-3,2,2,-3,-3],
'11n_35' : [1,1,-2,1,-2,1,3,2,2,3,3],
'11n_36' : [1,1,-2,1,-2,1,-3,-2,-2,-3,-3],
'11n_37' : [1,1,1,2,-1,-1,-3,2,1,-3,-2],
'11n_38' : [1,1,1,-2,-1,-3,2,-1,2,-3,-2],
'11n_39' : [1,1,1,2,-1,-1,-3,2,2,-3,2,-3,-2],
'11n_40' : [1,-2,1,-2,-2,1,3,2,2,2,3],
'11n_41' : [1,-2,1,-2,-2,1,-3,-2,-2,-2,-3],
'11n_42' : [1,1,1,1,-2,-2,-1,3,-2,-2,3,-2,3],
'11n_43' : [1,1,-2,1,-2,1,3,2,2,2,3],
'11n_44' : [1,1,-2,1,-2,1,-3,-2,-2,-2,-3],
'11n_45' : [1,1,-2,-2,1,-3,2,2,-3,2,-3],
'11n_46' : [1,1,2,2,1,3,-2,-2,3,-2,3],
'11n_47' : [1,1,2,2,1,-3,2,2,-3,2,-3],
'11n_48' : [1,1,1,1,2,-1,-1,-1,-3,2,-3],
'11n_49' : [1,1,2,-1,2,3,-2,-2,-2,-4,3,-4],
'11n_50' : [1,1,2,-1,2,3,-2,1,-2,-2,3],
'11n_51' : [1,1,1,-2,-1,-1,-3,2,-1,-3,-2],
'11n_52' : [1,1,1,2,-1,-1,2,2,-3,2,-3],
'11n_53' : [1,1,1,-2,-1,-1,-2,-2,3,-2,3],
'11n_54' : [1,1,2,-1,-1,2,1,3,-2,3,3],
'11n_55' : [1,1,1,2,-1,-1,2,-3,2,-3,-3],
'11n_56' : [1,1,1,-2,-1,-1,-2,3,-2,3,3],
'11n_57' : [1,1,1,2,1,1,2,2,-3,2,-3],
'11n_58' : [1,1,1,2,-1,-1,-3,2,-3,-3,-3],
'11n_59' : [1,1,1,-2,1,-2,3,2,2,2,3],
'11n_60' : [1,1,1,2,1,1,-3,2,-3,-3,-3],
'11n_61' : [1,1,1,2,1,1,2,-3,2,-3,-3],
'11n_62' : [1,1,1,2,-1,-1,-3,2,-3,-4,3,-4],
'11n_63' : [1,1,2,-1,2,1,3,-2,3,4,-3,4],
'11n_64' : [1,1,1,2,1,1,-3,2,-3,-4,3,-4],
'11n_65' : [1,2,-1,2,2,3,-2,1,-2,-2,3],
'11n_66' : [1,1,1,2,-1,2,1,-3,2,-1,2,-3,-3],
'11n_67' : [1,1,1,2,-1,-1,3,-2,-2,-4,3,2,-4,3],
'11n_68' : [1,1,2,-1,-3,-2,-2,-4,3,-2,-4,-3],
'11n_69' : [1,1,2,-1,3,2,2,-4,3,2,-4,3],
'11n_70' : [1,1,1,-2,1,1,-3,2,1,-3,-2],
'11n_71' : [1,1,2,2,1,3,-2,-2,-2,3,3],
'11n_72' : [1,1,-2,-2,1,3,2,2,2,3,3],
'11n_73' : [1,1,-2,-2,1,-3,2,2,2,-3,-3],
'11n_74' : [1,1,1,1,-2,-2,-1,3,-2,-2,-2,3,3],
'11n_75' : [1,1,-2,-2,-2,1,3,2,2,2,3],
'11n_76' : [1,1,-2,-2,1,-3,-2,-2,-2,-3,-3],
'11n_77' : [1,1,2,2,1,3,2,2,2,3,3],
'11n_78' : [1,1,-2,-2,-2,1,-3,-2,-2,-2,-3],
'11n_79' : [1,1,1,-2,-1,-1,3,-2,3,4,-3,4],
'11n_80' : [1,1,1,2,1,1,-3,-2,-2,4,-3,4],
'11n_81' : [1,1,2,2,2,1,-3,2,2,2,-3],
'11n_82' : [1,1,1,1,-2,-1,-1,-1,3,-2,3],
'11n_83' : [1,1,2,-1,2,-3,-2,-2,-2,4,-3,4],
'11n_84' : [1,1,-2,1,-2,3,2,-1,2,2,3],
'11n_85' : [1,1,1,-2,-1,-1,-1,-2,3,-2,3],
'11n_86' : [1,1,2,-1,-1,-3,2,-1,2,2,-3],
'11n_87' : [1,1,2,-1,2,1,3,-2,1,3,-2],
'11n_88' : [1,1,1,1,2,1,1,1,-3,2,-3],
'11n_89' : [1,1,1,-2,1,3,2,-1,2,2,3],
'11n_90' : [1,1,2,-1,2,3,2,2,2,-4,3,-4],
'11n_91' : [1,1,2,-1,-3,2,4,3,-2,3,3,4],
'11n_92' : [1,1,1,-2,-1,-1,3,-2,1,-2,3],
'11n_93' : [1,1,1,2,1,1,-3,2,-1,2,3,3,3],
'11n_94' : [1,1,2,-1,-3,2,-1,-3,2,2,-3],
'11n_95' : [1,1,1,2,-1,2,3,2,-1,2,3],
'11n_96' : [1,1,2,1,1,-3,-2,1,-2,-2,-3],
'11n_97' : [1,1,1,-2,-1,-1,3,-2,-2,-4,3,2,-4,3],
'11n_98' : [1,1,1,-2,1,-2,-1,3,-2,1,-2,-3,-3],
'11n_99' : [1,2,-1,2,2,2,3,-2,1,-2,3],
'11n_100' : [1,1,-2,-1,3,-2,-1,-4,3,-2,3,-4],
'11n_101' : [1,1,2,-1,-3,-2,1,-2,4,-3,2,4],
'11n_102' : [1,2,-1,2,1,3,2,-1,2,-4,3,-4],
'11n_103' : [1,1,1,2,-1,2,1,-3,2,-1,2,2,-3],
'11n_104' : [1,1,1,2,1,1,1,2,-3,2,-3],
'11n_105' : [1,1,-2,1,-2,3,2,2,2,3,3],
'11n_106' : [1,1,1,-2,-1,-1,-1,3,-2,3,3],
'11n_107' : [1,1,1,2,1,1,1,-3,2,-3,-3],
'11n_108' : [1,1,-2,1,1,3,2,-1,2,2,3],
'11n_109' : [1,1,1,-2,1,1,3,2,-1,2,3],
'11n_110' : [1,1,1,2,-1,-1,-3,2,-1,2,-3],
'11n_111' : [1,1,1,2,1,1,-3,-2,1,-2,-3],
'11n_112' : [1,1,2,-1,2,-3,2,-1,2,2,-3],
'11n_113' : [1,1,2,-1,-3,2,2,4,3,-2,3,4],
'11n_114' : [1,1,-2,1,3,2,-1,-4,-3,2,-3,-4],
'11n_115' : [1,1,2,-1,3,-2,-2,-4,3,-2,3,-4],
'11n_116' : [1,1,2,-1,3,-2,-2,-4,-3,2,-3,-4],
'11n_117' : [1,1,2,-1,3,2,2,-4,-3,2,-3,-4],
'11n_118' : [1,1,1,2,1,3,-2,1,-2,3,2],
'11n_119' : [1,1,2,-1,-3,2,-1,2,-3,-3,2],
'11n_120' : [1,1,-2,1,-2,-2,-3,-2,1,-2,-3],
'11n_121' : [1,1,2,1,1,-3,2,-1,2,4,-3,4],
'11n_122' : [1,1,1,-2,1,-2,3,2,-1,2,3],
'11n_123' : [1,1,-2,1,3,-2,-1,-4,-3,2,-3,-4],
'11n_124' : [1,1,2,-1,3,-2,1,-4,3,-2,3,-4],
'11n_125' : [1,1,1,2,-1,-3,2,-1,2,2,-3],
'11n_126' : [1,1,1,2,1,1,2,-3,2,-1,2,3,3],
'11n_127' : [1,1,2,-1,-1,2,2,1,3,-2,3],
'11n_128' : [1,1,-2,1,-2,1,-3,2,1,-3,-2],
'11n_129' : [1,1,2,-1,2,2,-3,2,-1,2,-3],
'11n_130' : [1,1,2,-1,2,-3,2,-1,-3,2,-3],
'11n_131' : [1,-2,1,-2,-3,2,2,4,3,-2,3,4],
'11n_132' : [1,1,-2,-1,-3,2,-1,2,-3,-2,-2],
'11n_133' : [1,1,2,1,-3,2,1,-3,2,-3,2],
'11n_134' : [1,1,2,-1,2,2,3,-2,1,-2,3],
'11n_135' : [1,1,2,-1,2,1,1,2,-3,2,-3],
'11n_136' : [1,1,1,2,-1,3,-2,1,1,3,2,2,2],
'11n_137' : [1,1,1,1,2,-1,2,1,-3,2,-1,2,-3],
'11n_138' : [1,2,-1,2,3,-2,1,-2,-2,-2,3],
'11n_139' : [1,1,2,-1,3,-2,3,4,-3,2,-3,4],
'11n_140' : [1,1,2,-1,2,3,-2,3,2,-4,3,-2,3,-4],
'11n_141' : [1,1,2,-1,2,-3,2,-3,-2,-4,-3,2,-3,-4],
'11n_142' : [1,1,2,-1,-3,-2,-4,3,-2,3,-4,-3],
'11n_143' : [1,1,-2,1,-2,1,-3,2,-1,2,-3],
'11n_144' : [1,1,-2,1,1,3,2,-1,2,3,3],
'11n_145' : [1,1,2,1,-3,2,1,-3,-2,-2,-3],
'11n_146' : [1,1,2,2,3,-2,1,-2,3,-2,3],
'11n_147' : [1,1,2,1,-3,2,1,-3,2,2,-3],
'11n_148' : [1,1,2,-3,2,1,-3,2,-3,2,-3],
'11n_149' : [1,1,1,2,1,-3,2,1,-3,2,-3],
'11n_150' : [1,1,2,-1,3,2,-4,3,2,-4,3,-4],
'11n_151' : [1,1,1,1,-2,-2,-1,3,-2,3,-2,3,3],
'11n_152' : [1,1,-2,1,-2,1,-3,2,2,2,-3],
'11n_153' : [1,1,1,-2,1,-2,-3,-2,1,-2,-3],
'11n_154' : [1,1,1,2,-1,-3,2,-1,2,-3,2],
'11n_155' : [1,1,2,-1,-3,2,-3,-4,-3,2,-3,-4],
'11n_156' : [1,1,2,-1,-3,2,-1,-3,2,-3,2],
'11n_157' : [1,1,1,2,-1,-3,2,-1,-3,2,-3],
'11n_158' : [1,-2,1,-2,-3,-2,1,-2,-2,-2,-3],
'11n_159' : [1,1,2,2,1,3,-2,1,-2,3,-2],
'11n_160' : [1,1,2,-1,2,-3,2,-1,2,-3,2],
'11n_161' : [1,1,1,2,1,-3,-2,1,4,-3,2,-3,4,-3],
'11n_162' : [1,1,2,-1,2,1,3,-2,-1,3,2,4,-3,4],
'11n_163' : [1,1,2,-1,2,1,-3,2,-1,2,-3,2,-3],
'11n_164' : [1,1,1,-2,-1,3,-2,-1,3,2,2,3,3],
'11n_165' : [1,1,2,-1,3,-2,-4,3,-2,-4,3,-4],
'11n_166' : [1,1,-2,1,-2,-3,-2,1,-2,-2,-3],
'11n_167' : [1,1,1,2,-1,2,-3,2,-1,2,-3],
'11n_168' : [1,1,2,-1,3,-2,3,-4,3,-2,3,-4],
'11n_169' : [1,1,1,1,2,1,1,-3,2,-1,2,3,3],
'11n_170' : [1,1,2,-1,2,-3,-2,1,4,-3,2,2,4,-3],
'11n_171' : [1,1,2,-1,2,3,2,2,-4,3,-2,3,4,4],
'11n_172' : [1,2,-1,2,1,3,-2,1,-2,-2,3],
'11n_173' : [1,-2,1,-3,-2,-2,1,-3,-2,-2,-3],
'11n_174' : [1,1,-2,1,3,-2,1,3,2,2,3],
'11n_175' : [1,1,1,2,1,-3,-2,1,4,-3,2,4,-3,4],
'11n_176' : [1,1,-2,1,-2,1,3,2,-1,2,3],
'11n_177' : [1,-2,1,-2,1,-3,-2,1,-2,-2,-3],
'11n_178' : [1,-2,1,-2,3,-2,1,3,2,2,3],
'11n_179' : [1,1,-2,1,1,-2,-1,3,-2,1,-2,-3,-3],
'11n_180' : [1,1,1,1,2,-1,3,-2,1,1,3,2,2],
'11n_181' : [1,1,2,1,1,-3,2,-1,2,3,3,4,-3,4],
'11n_182' : [1,1,-2,1,-2,1,-3,-2,1,-2,-3],
'11n_183' : [1,-2,1,3,2,2,1,3,2,2,3],
'11n_184' : [1,-2,1,3,-2,-2,1,3,2,2,3],
'11n_185' : [1,-2,1,3,-2,1,3,2,2,2,3],
'12a_1' : [-1,2,-1,2,3,3,-4,-4,3,3,-4,-2,-2,-3],
'12a_2' : [-1,2,-1,2,3,-4,3,3,3,-4,3,-2,-2,-3],
'12a_3' : [-1,2,-1,2,3,-4,-5,3,4,-5,4,3,-2,-2,-3],
'12a_4' : [-1,2,-1,2,-3,-3,2,2,-3,4,-3,4],
'12a_5' : [-1,2,-1,2,3,3,4,-5,2,2,-3,4,-5],
'12a_6' : [-1,2,-1,2,-3,-3,4,2,2,-3,4,4],
'12a_7' : [-1,2,-1,2,3,-4,3,-4,3,-2,-2,-3,-4,-4],
'12a_8' : [-1,2,-1,2,-3,4,2,2,-3,-3,-3,4],
'12a_9' : [-1,2,-1,2,-3,-4,5,3,-4,2,5,2,-3],
'12a_10' : [-1,2,-1,2,3,4,4,5,3,-4,-2,5,-2,-3,5],
'12a_11' : [-1,2,-1,2,3,-4,-4,3,-4,-2,-4,-2,-4,-3],
'12a_12' : [-1,2,-1,-2,-3,-3,-2,-2,3,4,-5,-3,4,-5,4],
'12a_13' : [-1,2,-1,2,3,-4,3,3,-4,3,-4,-2,-2,-3],
'12a_14' : [-1,2,-1,2,3,-4,3,-4,3,-4,-2,-4,-2,-3],
'12a_15' : [-1,2,-1,2,3,-4,3,3,-4,3,-2,-2,-3,-4],
'12a_16' : [-1,2,-1,2,-3,4,-3,4,-3,2,2,-3],
'12a_17' : [-1,2,-1,2,-3,4,4,-3,4,2,2,-3],
'12a_18' : [-1,2,-1,2,3,3,3,-4,3,-4,3,-2,-2,-3],
'12a_19' : [-1,2,-1,2,3,-4,3,-4,-4,-4,3,-2,-2,-3],
'12a_20' : [-1,2,-1,2,3,3,3,-4,-4,3,-4,-2,-2,-3],
'12a_21' : [-1,2,-1,2,3,3,4,4,3,3,-4,2,2,-3],
'12a_22' : [-1,2,-1,2,3,-4,-5,3,4,-5,-4,3,-2,-2,-3],
'12a_23' : [1,-2,-3,4,5,2,4,-1,-3,4,-3,-5,4,2,-1,-3,2],
'12a_24' : [-1,2,-1,2,-3,4,2,2,-3,4,4,4],
'12a_25' : [-1,2,-1,2,3,4,-5,-3,4,-5,4,3,-2,-2,-3],
'12a_26' : [-1,2,-1,2,3,-4,-4,-4,-4,3,-4,-2,-2,-3],
'12a_27' : [-1,2,-1,2,3,-4,-5,4,-5,-4,3,-4,-2,-2,-3],
'12a_28' : [-1,2,-1,2,3,-4,5,3,-4,2,5,2,-3],
'12a_29' : [-1,2,-1,2,-3,-4,-4,-3,2,2,-3,4,-3,-4],
'12a_30' : [-1,2,-1,2,3,-4,-4,3,3,3,-4,-2,-2,-3],
'12a_31' : [-1,2,-1,2,-3,4,5,2,2,-3,-4,5,4],
'12a_32' : [-1,2,-1,2,3,4,-5,-5,4,3,-4,-5,-2,-2,-3],
'12a_33' : [-1,2,-1,2,3,3,3,-4,-4,3,-2,-2,-3,-4],
'12a_34' : [-1,2,-1,2,3,3,3,3,3,3,2,2,-3],
'12a_35' : [-1,2,-1,2,3,3,3,4,-3,4,3,2,2,-3],
'12a_36' : [-1,2,-1,2,3,4,4,3,3,3,4,2,2,-3],
'12a_37' : [-1,2,-1,2,3,4,-3,4,4,4,3,2,2,-3],
'12a_38' : [-1,2,-1,2,3,4,5,-3,-4,5,4,3,2,2,-3],
'12a_39' : [-1,2,2,-3,4,-1,-1,2,2,-3,2,4],
'12a_40' : [-1,2,2,3,-4,-1,-4,-1,3,-2,-2,-3,-4,2],
'12a_41' : [1,1,1,2,2,-1,2,-3,2,2,1,-3,-3],
'12a_42' : [-1,2,-1,-2,-3,-3,4,4,-3,-3,4,-2,-2,3],
'12a_43' : [-1,2,2,3,1,3,4,1,2,2,-3,2,4,4],
'12a_44' : [-1,-2,-2,3,-1,3,-4,2,-4,-5,-1,-3,-5,4,-5],
'12a_45' : [-1,-2,-2,-3,4,-1,4,-1,2,3,3,4,4,4],
'12a_46' : [-1,2,-1,-2,-3,-3,-4,5,-2,5,-2,3,4,4,5],
'12a_47' : [-1,2,-3,-1,-3,-4,2,-4,-5,-3,-5,4,-5],
'12a_48' : [-1,2,2,-3,4,-1,-1,2,-3,2,-3,4],
'12a_49' : [-1,2,2,3,4,-1,4,-1,3,2,2,-3,4,-3,2,-4],
'12a_50' : [-1,-2,-2,-3,4,-1,4,-1,2,4,4,3,3,4],
'12a_51' : [1,2,3,3,-4,2,-4,-5,-3,-5,2,1,4,-5,-2],
'12a_52' : [-1,-2,-2,-3,-1,-3,-1,-1,-1,-1,2,-3,-1],
'12a_53' : [-1,-2,-2,-3,-1,-3,-1,-3,-4,3,2,-4,-3,-3],
'12a_54' : [1,-2,3,4,1,-2,3,1,-4,3,-5,-4,-4,-5,-5],
'12a_55' : [-1,-2,-2,-3,-4,-1,-4,-1,-4,3,2,-4,-3,-3],
'12a_56' : [-1,2,-1,-2,-3,-4,-4,-5,-3,4,-2,-5,-2,3,-5],
'12a_57' : [-1,2,3,-1,3,4,2,4,-5,-3,-5,4,-5],
'12a_58' : [-1,2,2,-3,4,-1,4,-1,2,-3,-3,4],
'12a_59' : [-1,2,-1,2,-3,-3,-2,-2,3,-4,3,3,-4,-4],
'12a_60' : [-1,2,-1,2,3,3,4,-2,4,-2,-3,-3,4,-3],
'12a_61' : [-1,2,2,-3,-1,-3,-1,-3,4,2,-3,4],
'12a_62' : [1,-2,-3,4,1,4,-5,-3,-5,-2,4,-5,3],
'12a_63' : [-1,2,-1,2,-3,-3,-4,-2,-4,-2,3,3,-4,3],
'12a_64' : [-1,-1,2,3,-1,3,-4,-2,-4,-5,-2,-3,-5,4,-5],
'12a_65' : [-1,-2,-2,-3,4,-1,4,-1,2,4,3,3,4,4],
'12a_66' : [-1,2,2,-3,-4,-1,-1,-2,3,-2,3,-4,3,3],
'12a_67' : [-1,2,-1,2,3,3,4,-2,-2,-3,-3,-3,4,-3],
'12a_68' : [-1,2,-3,-1,2,-3,2,4,5,-3,-4,5,-4],
'12a_69' : [-1,2,-1,2,3,-4,3,-4,3,-2,-2,-3,-3,-3],
'12a_70' : [-1,2,-1,2,3,-4,-4,3,-4,-2,-2,-3,-3,-3],
'12a_71' : [-1,2,-3,-1,2,2,2,-3,2,4,-3,4],
'12a_72' : [-1,2,3,-4,-1,3,-4,2,5,2,3,-4,-2,-3,5],
'12a_73' : [-1,2,-1,2,3,-4,5,3,2,2,-3,4,-3,-4,5],
'12a_74' : [-1,2,3,-1,3,-4,-4,3,-2,-2,3,-4,-2,-3],
'12a_75' : [-1,2,-1,2,3,3,3,4,4,3,2,2,-3,4,-3,-4],
'12a_76' : [-1,-2,-3,4,5,-3,4,2,-3,4,-5,-4,-4,-3,-2,-1,2],
'12a_77' : [-1,2,2,-1,-1,2,-3,4,2,-3,4,-3],
'12a_78' : [1,2,2,-1,2,-3,2,2,-3,-3,2,2,1],
'12a_79' : [-1,2,2,-1,-1,2,-3,2,-3,4,-3,2,-3,-4],
'12a_80' : [-1,-2,-2,-1,-1,2,3,-4,-2,3,3,3,-4,3],
'12a_81' : [-1,-2,3,-4,-4,-5,-5,4,3,-4,2,-5,-1,2,3],
'12a_82' : [-1,2,2,1,1,2,3,3,4,2,-3,2,4,4],
'12a_83' : [-1,2,-3,-4,-1,-4,-5,-3,-5,2,4,-5,-3],
'12a_84' : [-1,2,2,-1,-1,2,-3,4,2,4,-3,4],
'12a_85' : [1,2,2,2,2,-1,2,-3,2,2,1,-3,-3],
'12a_86' : [-1,2,2,-1,-1,2,-3,2,3,3,4,-3,4,3],
'12a_87' : [-1,2,2,-1,-1,2,-3,4,2,-3,2,4],
'12a_88' : [-1,-2,-2,-1,-1,2,3,-4,3,-2,3,-4,3,-4],
'12a_89' : [-1,2,2,3,-4,3,-1,-4,-1,2,3,3,2,4,-3,2],
'12a_90' : [-1,2,2,3,-1,3,-4,-1,-2,3,-2,-4,-4,-3],
'12a_91' : [-1,-2,-2,-1,-1,2,3,-4,3,-4,-2,3,-4,-4],
'12a_92' : [-1,-2,-2,-3,4,-1,4,-1,2,3,3,3,3,4],
'12a_93' : [-1,-1,-1,-2,-2,-3,-1,-3,-1,-1,2,-3,-1],
'12a_94' : [-1,-2,-2,-3,-1,-3,-1,-3,2,-3,-4,3,-4,-3],
'12a_95' : [-1,2,-3,-4,2,-4,-1,-5,2,-5,-3,4,-5],
'12a_96' : [-1,-2,-2,-3,-4,3,-1,-4,-1,2,-3,-3,-3,-3],
'12a_97' : [-1,-2,-3,-4,-4,-5,-3,-5,-2,4,-5,3,-2,-1,2],
'12a_98' : [-1,2,2,-3,-1,-1,2,-3,4,-3,4,-3],
'12a_99' : [-1,2,2,-3,4,-1,-1,2,-3,4,4,-3],
'12a_100' : [-1,2,2,-3,-4,-5,-3,4,2,1,-5,2,-3,4,-3,2,-4],
'12a_101' : [-1,-2,-2,-1,-1,2,3,-4,3,-2,3,3,-4,3],
'12a_102' : [-1,-2,-2,-3,-1,-3,4,-1,-3,2,-3,-4,-4,-3],
'12a_103' : [1,-2,3,-4,1,-4,-5,-3,-5,-2,3,4,-5,-2,3],
'12a_104' : [-1,2,2,3,-4,1,-4,1,3,2,2,-3,-4,2],
'12a_105' : [-1,-2,-2,-1,-1,2,3,-4,-2,-4,3,-4,-4,-4],
'12a_106' : [-1,2,-1,-2,-3,-3,-2,-2,3,4,-5,-3,-5,4,-5],
'12a_107' : [-1,-2,-2,-3,4,-3,-1,-3,-1,2,-3,-4,-4,-3],
'12a_108' : [-1,-2,-2,-1,-1,2,3,-4,-2,3,3,-4,3,-4],
'12a_109' : [1,2,-3,-4,2,-4,1,-5,-2,-5,3,3,3,4,-5],
'12a_110' : [-1,2,-3,-4,-1,2,-1,-4,-5,-3,-5,4,-5],
'12a_111' : [-1,-2,-2,-1,-1,2,3,-4,-2,3,-4,3,-4,-4],
'12a_112' : [-1,2,2,-3,4,-1,-1,2,-3,4,4,4],
'12a_113' : [-1,2,2,-3,-1,-3,-4,-1,-2,3,-2,-4,3,2],
'12a_114' : [1,-2,-3,-4,1,-4,-5,-3,-5,-3,-4,-2,3,4,-5],
'12a_115' : [-1,-2,-2,-1,-1,2,3,-4,3,3,-2,3,-4,3],
'12a_116' : [-1,2,2,3,-1,-1,-2,-3,4,2,2,-3,2,4],
'12a_117' : [-1,2,3,-1,-2,-2,3,-4,-2,-4,-5,-3,-5,4,-5],
'12a_118' : [1,-2,3,4,1,-2,4,-5,-5,4,3,-4,-5],
'12a_119' : [-1,2,2,-3,-1,-3,-4,-1,-2,3,2,-4,-4,-3],
'12a_120' : [-1,-2,-2,-1,-1,2,3,-4,3,3,-4,-2,3,-4],
'12a_121' : [1,2,-3,4,2,4,1,-5,-2,-5,-3,4,-5],
'12a_122' : [-1,2,2,-3,4,-1,-1,2,2,2,-3,4],
'12a_123' : [-1,2,-3,-1,-3,2,-3,4,-3,-3,-3,4],
'12a_124' : [-1,2,-3,-1,-3,2,-3,4,5,-3,-4,5,-4],
'12a_125' : [-1,2,3,-1,3,4,-5,6,2,-3,-4,-4,-5,6],
'12a_126' : [-1,2,-3,-1,-3,4,2,4,-3,4,-3,4],
'12a_127' : [-1,2,3,-1,3,4,2,4,4,-5,-3,4,-5],
'12a_128' : [-1,2,3,-1,3,4,5,-6,2,-3,-4,5,4,-6],
'12a_129' : [-1,2,-3,-1,-3,4,2,4,4,-3,4,4],
'12a_130' : [-1,2,-1,-2,3,3,-4,5,-2,-2,3,-4,5],
'12a_131' : [-1,2,-1,2,-3,4,-3,-3,4,-3,4,-2,-2,3],
'12a_132' : [-1,2,-1,2,-3,4,-3,4,-3,4,-2,4,-2,3],
'12a_133' : [-1,2,-3,-1,-3,4,2,-3,4,-3,-3,4],
'12a_134' : [-1,2,-1,2,-3,-3,-4,-2,-2,3,3,3,-4,3],
'12a_135' : [-1,2,-1,2,-3,-3,-2,-2,3,-4,-5,3,4,-5,4],
'12a_136' : [-1,2,-3,-1,2,-3,2,4,-3,-3,-3,4],
'12a_137' : [-1,2,-3,-1,2,-3,2,-3,-3,4,-3,4],
'12a_138' : [-1,2,-3,-1,2,-3,2,4,-3,4,4,4],
'12a_139' : [-1,2,-3,-1,2,-3,2,4,4,-3,4,-3],
'12a_140' : [-1,2,-3,-1,2,-3,2,4,5,-3,-4,5,4],
'12a_141' : [-1,-2,-2,-1,-1,2,3,-2,3,3,-4,3,-4,3],
'12a_142' : [-1,-2,-2,-1,-1,2,3,-4,-2,-4,-4,3,-4,3],
'12a_143' : [-1,-1,-1,-1,-1,-2,-2,-3,-1,-3,2,-3,-1],
'12a_144' : [-1,-2,-2,-3,-1,-1,2,-3,-3,-3,-4,3,-4,-3],
'12a_145' : [-1,-2,-2,-3,-1,-1,2,-3,-4,-4,-4,3,-4,-3],
'12a_146' : [-1,2,2,-1,-1,2,2,2,2,2,2,2],
'12a_147' : [1,2,2,-3,-3,2,2,2,2,2,1,-2,-3],
'12a_148' : [1,1,1,2,2,-3,-3,2,2,2,1,-2,-3],
'12a_149' : [-1,-2,-2,-1,-1,2,3,-2,3,-4,3,-4,-4,3],
'12a_150' : [-1,2,2,-3,-1,-1,2,3,4,3,4,3,2,-3,2,-4],
'12a_151' : [-1,-2,3,-4,-4,-5,-5,4,3,-4,-2,-5,-1,2,3],
'12a_152' : [-1,-2,-3,-4,-4,-5,-3,-5,4,-5,-3,-2,-1,2,3],
'12a_153' : [-1,2,2,-1,-1,2,2,2,3,4,-2,-3,4,3],
'12a_154' : [1,2,-3,-4,-2,-4,-2,-5,-3,1,-5,-2,4,-5,-3],
'12a_155' : [-1,2,2,-3,4,-3,4,-5,-4,3,2,1,-4,5,2,-3,2],
'12a_156' :  [-1,-1,-2,1,-2,-3,2,2,4,-3,-2,-5,-4,-4,-3,-5,-5],
'12a_157' : [-1,-2,-2,-1,-1,2,3,-4,3,-4,-2,3,3,3],
'12a_158' : [-1,-2,-2,-1,-1,2,3,-4,-2,-4,-4,-4,3,-4],
'12a_159' : [-1,-2,3,-4,-2,-4,-5,-5,4,3,-2,-4,-1,-5,2],
'12a_160' : [1,1,1,1,1,2,2,-3,-3,2,1,-2,-3],
'12a_161' : [-1,2,2,-1,-1,2,3,-2,3,3,4,-3,4,3],
'12a_162' : [1,-2,-2,-3,2,1,-3,-4,-2,-4,-5,-3,-5,4,-5],
'12a_163' : [-1,-2,3,-2,3,-1,3,-4,2,-4,-5,-3,-5,4,-5],
'12a_164' : [-1,-2,-2,-1,-1,2,3,-4,-2,-4,3,3,3,-4],
'12a_165' : [-1,2,3,-4,-1,-4,-5,-5,4,3,-4,2,-1,-5,-3],
'12a_166' : [-1,-2,-2,-1,-1,2,3,3,3,-4,-2,-4,3,-4],
'12a_167' : [1,1,-2,-3,1,1,1,2,2,-3,-3,2,1],
'12a_168' : [-1,2,-1,-2,-3,4,4,-3,-3,-3,4,-2,-2,3],
'12a_169' : [-1,2,-1,-2,-3,-4,5,5,-4,-3,4,5,-2,-2,3],
'12a_170' : [-1,2,3,-1,3,4,2,-3,4,-5,4,-5,4],
'12a_171' : [-1,2,3,-1,3,4,-5,2,-3,4,-5,-5,4],
'12a_172' : [-1,2,-3,-1,-3,2,-3,-3,-3,4,-3,4],
'12a_173' : [-1,2,-3,-1,-3,2,-3,4,-3,4,4,4],
'12a_174' : [-1,2,-3,-1,-3,2,-3,4,4,-3,4,-3],
'12a_175' : [1,-2,3,-4,1,-4,-3,4,-5,4,-2,4,3,5,5],
'12a_176' : [-1,2,-3,-1,-3,2,-3,4,5,-3,-4,5,4],
'12a_177' : [-1,2,-3,-1,-3,2,-3,4,-3,4,-5,-4,3,-4,5],
'12a_178' : [-1,2,3,-1,3,4,-5,2,-3,4,-5,-5,-5],
'12a_179' : [-1,2,-3,-1,-3,4,2,-3,4,4,4,4],
'12a_180' : [-1,2,-3,-1,-3,4,2,-3,4,5,-4,5,4],
'12a_181' : [-1,2,3,-1,-2,3,2,-4,5,-6,3,-4,5,-6],
'12a_182' : [-1,2,-1,2,-3,4,4,-3,-3,-3,4,-2,-2,3],
'12a_183' : [-1,2,3,-1,3,4,-5,2,-3,4,-5,-6,5,-6],
'12a_184' : [-1,2,-3,-1,2,2,-3,2,-3,4,-3,4],
'12a_185' : [-1,2,-3,-1,2,2,-3,4,2,-3,4,4],
'12a_186' : [-1,2,-1,2,-3,-3,-3,-3,-2,-2,3,-4,3,-4],
'12a_187' : [-1,2,3,-4,-1,3,-4,-2,3,-2,-4,-5,4,-3,-5],
'12a_188' : [-1,2,-1,2,-3,-3,-2,-2,3,-4,3,3,3,-4],
'12a_189' : [-1,2,-1,2,-3,-3,-2,-2,3,3,3,-4,3,-4],
'12a_190' : [-1,2,-1,2,-3,-3,-2,-2,3,-4,3,-4,-4,-4],
'12a_191' : [-1,2,-1,2,-3,-3,-2,-2,3,-4,-4,3,-4,3],
'12a_192' : [-1,2,-1,2,-3,-3,-2,-2,3,-4,-5,3,4,-5,-4],
'12a_193' : [-1,2,-3,4,-1,2,-3,-3,-3,-3,-3,4],
'12a_194' : [-1,2,3,-1,-2,3,2,-4,3,-4,-4,-5,4,-5,-4],
'12a_195' : [-1,2,3,-1,-2,3,2,-4,-4,-4,3,-4,-4,-4],
'12a_196' : [-1,2,-3,-4,5,-1,3,-4,2,-4,-4,5,-3],
'12a_197' : [-1,2,-3,4,-5,6,-1,2,-3,-5,6,-4,5,-4],
'12a_198' : [-1,2,-3,4,-1,2,4,-3,2,4,-5,4,-5,-3,-4],
'12a_199' : [-1,2,-1,2,-3,4,-3,2,2,3,4,4,-3,4,4,3],
'12a_200' : [-1,2,3,-1,3,-4,3,-2,-2,-2,3,-2,-4,-3],
'12a_201' : [-1,2,3,-1,3,4,-5,-4,3,-2,3,-2,-4,-3,-5],
'12a_202' : [-1,2,-1,2,3,3,-4,-2,3,-2,3,-2,-4,-3],
'12a_203' : [-1,2,-3,4,-1,-3,-3,-3,4,2,-3,2],
'12a_204' : [-1,2,-3,4,5,-1,-3,-4,5,-4,2,-3,2],
'12a_205' : [-1,2,-1,2,2,2,3,3,3,3,2,2,-3],
'12a_206' : [-1,2,-1,-2,-3,-3,-3,4,-3,4,-3,-2,-2,3],
'12a_207' : [-1,2,-3,-1,2,-3,-4,-3,2,2,2,-3,2,4],
'12a_208' : [-1,2,3,-4,-1,3,-4,-5,-4,3,-4,-2,5,3,2],
'12a_209' : [-1,2,-3,-1,2,-3,4,-3,2,-3,2,4],
'12a_210' : [-1,2,2,3,1,3,4,1,4,3,3,-4,-2,-2,-3,2],
'12a_211' : [-1,2,2,-1,-1,-1,2,-3,2,2,-1,3,3],
'12a_212' : [-1,2,-1,-2,3,3,4,-2,4,-2,3,3,-4,3],
'12a_213' : [-1,2,-3,4,-1,-3,4,2,-3,2,4,4],
'12a_214' : [-1,2,-3,4,-1,-3,-3,4,2,-3,2,4],
'12a_215' : [-1,2,-1,2,3,-4,3,-4,3,-2,-2,-2,-2,-3],
'12a_216' : [-1,2,-1,2,-3,4,2,2,2,2,-3,4],
'12a_217' : [-1,2,-1,2,-3,-4,-2,-4,3,3,-2,3,-4,3],
'12a_218' : [-1,2,-1,2,-3,-4,5,2,3,-2,3,2,-4,3,5],
'12a_219' : [-1,2,-1,2,3,-4,-4,3,-4,-2,-2,-2,-2,-3],
'12a_220' : [-1,2,-3,4,-1,-3,4,2,2,2,-3,2],
'12a_221' : [-1,2,-3,-4,5,-1,3,-4,5,-4,2,-3,2],
'12a_222' : [-1,2,-3,4,-1,2,-3,2,-3,4,-3,2],
'12a_223' : [-1,2,-3,-4,-5,-1,-2,3,-4,3,-4,5,-4,3,-2,3,4],
'12a_224' : [-1,2,-3,4,-1,2,2,-3,4,2,-3,2],
'12a_225' : [-1,2,-1,2,-3,-4,-2,-4,3,-2,3,-4,-2,3],
'12a_226' : [-1,2,2,1,1,2,2,2,3,-4,-2,3,-4,3],
'12a_227' : [-1,2,-1,2,3,3,-4,3,-2,3,4,4,3,2],
'12a_228' : [-1,2,-3,4,-1,-3,2,-3,-3,4,-3,2],
'12a_229' : [-1,2,3,-4,-1,3,-4,-5,-4,3,-4,2,5,-3,2],
'12a_230' : [-1,2,-3,4,-5,-1,-3,4,-5,-4,2,-3,2,-4,-4],
'12a_231' : [-1,2,-1,2,2,2,3,4,4,3,2,2,-3,4,-3,-4],
'12a_232' : [-1,2,2,-3,4,1,4,1,-2,3,3,-2,-4,3,3,2],
'12a_233' : [-1,2,-3,4,-1,2,2,-3,4,-3,2,-3],
'12a_234' : [-1,-1,-1,2,2,-1,2,-3,2,2,-1,3,3],
'12a_235' : [-1,2,2,-3,-4,3,1,-4,-3,1,2,2,-3,2],
'12a_236' : [-1,2,2,3,3,2,-1,2,2,2,2,2,-3],
'12a_237' : [-1,2,2,3,1,3,1,3,4,-3,4,3,-2,-2,-3,2],
'12a_238' : [-1,2,2,1,1,2,-3,-4,2,3,3,3,-4,3],
'12a_239' : [-1,-2,3,4,4,5,5,4,-3,4,2,-5,-1,2,3],
'12a_240' : [1,1,1,2,2,-3,-1,-3,2,-3,2,2,1],
'12a_241' : [-1,2,-1,-2,-3,-3,-3,4,4,-3,4,-2,-2,3],
'12a_242' : [-1,2,-3,4,2,-3,-1,-3,-1,-3,2,4],
'12a_243' : [-1,2,3,-4,5,-1,5,-4,3,-4,5,2,-3],
'12a_244' : [-1,2,2,3,4,-3,4,3,2,2,-3,-1,4,-3,-1,2],
'12a_245' : [-1,2,3,3,-4,3,-2,3,-2,-4,-3,-1,-1,2],
'12a_246' : [-1,2,-3,4,-1,2,4,-3,2,4,4,4],
'12a_247' : [-1,2,-1,-2,3,-4,5,-2,-2,3,-4,5,-4],
'12a_248' : [-1,2,-3,4,-5,-1,-2,4,-5,-3,4,-3,-2,3,4],
'12a_249' : [-1,2,3,-4,-5,-1,-3,-3,-3,4,-5,-4,2,-3,2],
'12a_250' : [-1,2,-3,4,-1,2,4,2,2,-3,2,4],
'12a_251' : [-1,2,3,-4,5,-1,3,5,2,-4,5,-3,2],
'12a_252' : [-1,2,-1,2,3,3,3,3,2,2,2,2,-3],
'12a_253' : [-1,2,3,-1,3,3,4,-3,4,2,2,2,-3,2],
'12a_254' : [-1,2,-1,2,3,4,-3,4,3,2,2,2,2,-3],
'12a_255' : [-1,2,3,4,5,5,4,-5,4,3,-4,2,-1,2,-3],
'12a_256' : [-1,2,-1,2,-3,-4,5,2,3,3,-4,2,3,-4,5],
'12a_257' : [-1,2,-3,-4,5,-1,3,-4,5,-4,-3,2,-3],
'12a_258' : [-1,2,-3,4,-1,2,-3,-3,-3,2,4,2],
'12a_259' : [-1,2,3,-4,5,-1,-4,5,-4,3,-4,2,-3],
'12a_260' : [-1,2,-3,-1,-2,3,-4,3,-2,3,-4,3,3,2],
'12a_261' : [-1,2,-1,2,3,-4,3,-2,-4,3,3,-2,-4,-3],
'12a_262' : [-1,2,-1,2,3,3,-4,3,-2,3,3,-2,-4,-3],
'12a_263' : [-1,2,-3,4,-5,-1,2,3,3,3,4,-5,4],
'12a_264' : [-1,2,-3,4,-1,2,-3,2,4,-3,2,4],
'12a_265' : [-1,2,-3,4,-1,-3,2,-3,4,-3,2,4],
'12a_266' : [-1,2,-3,2,2,2,1,1,1,2,-3,2,-3],
'12a_267' : [-1,2,-1,-2,-3,-3,-4,2,-4,-4,-3,2,-3,2,4,3],
'12a_268' : [-1,-2,3,-2,3,-2,4,-3,-1,4,-1,2,4,3],
'12a_269' : [-1,2,-1,2,3,-4,3,3,3,2,-4,3,3,2,4,-3],
'12a_270' : [-1,2,-1,-2,-3,4,-3,4,-5,-4,3,-4,-3,5,-2,-2,3],
'12a_271' : [-1,2,-3,-4,-1,-1,2,-3,2,-4,2,2,-3,4],
'12a_272' : [-1,2,-3,4,-5,-1,-3,4,-5,4,-3,-4,2,-3,4],
'12a_273' : [-1,2,2,-3,1,-3,4,1,2,-3,2,-3,-4,-4],
'12a_274' : [-1,2,2,2,2,-1,2,-3,2,2,-1,3,3],
'12a_275' : [-1,2,2,-3,-4,1,-4,1,2,3,-2,3,-4,2,3,2],
'12a_276' : [-1,-2,-2,-2,-2,-3,-1,-3,-1,-1,2,-3,-1],
'12a_277' : [-1,2,-1,-2,-3,-3,-3,-3,-4,-2,-2,3,-4,-4],
'12a_278' : [-1,2,2,2,2,-3,4,-1,-1,2,-3,4],
'12a_279' : [-1,2,3,-1,-2,-2,3,4,-2,-3,4,5,-4,5,4],
'12a_280' : [-1,2,-3,2,-3,2,4,-3,-1,-1,2,-3,-3,-4],
'12a_281' : [-1,2,-3,-3,-4,2,-3,-1,-4,-1,2,-3,-3,4],
'12a_282' : [-1,2,-3,4,-1,-3,4,-3,4,2,4,-3],
'12a_283' : [-1,2,-3,4,-1,-3,-3,4,-3,4,2,-3],
'12a_284' : [-1,2,-3,-1,2,-3,2,4,2,2,-3,4],
'12a_285' : [-1,2,-3,4,-1,-3,4,2,-3,2,-3,-3],
'12a_286' : [-1,2,-3,-4,5,-1,2,-3,4,2,3,3,-4,-4,5],
'12a_287' : [-1,2,-1,2,-3,-3,-3,-4,-2,3,-2,-4,3,3],
'12a_288' : [-1,2,-3,-1,2,-3,-4,-3,2,-3,2,-3,-3,4],
'12a_289' : [-1,2,-1,2,3,3,4,2,2,-3,2,2,3,-4,3,-4],
'12a_290' : [-1,2,2,3,-1,3,-1,2,-1,2,2,2,-3],
'12a_291' : [-1,2,2,3,4,-3,1,4,3,1,-2,-2,-3,-3,-3,2],
'12a_292' : [-1,-2,-2,3,3,-2,-2,3,4,-1,-1,2,-3,4],
'12a_293' : [-1,2,2,3,1,3,-4,1,2,2,2,3,-2,3,4,4],
'12a_294' : [1,2,2,-3,-3,2,2,-1,2,-3,2,2,1],
'12a_295' : [-1,2,2,1,1,2,-3,4,2,4,3,3,3,4],
'12a_296' : [-1,2,3,-4,5,-1,2,-3,-4,2,-3,-3,-4,-4,5],
'12a_297' : [-1,2,2,2,-1,2,-3,2,2,3,3,2,-1],
'12a_298' : [-1,2,-3,4,2,-3,4,-1,-1,2,2,2],
'12a_299' : [-1,2,-3,4,-1,-1,2,-3,-3,-3,4,-3],
'12a_300' : [-1,2,3,-4,5,-1,3,5,-2,-4,5,3,2],
'12a_301' : [1,-2,3,4,-2,3,1,3,4,-2,-5,-3,-5,4,-5],
'12a_302' : [-1,2,2,1,1,2,3,-4,-4,3,2,-3,-4,2],
'12a_303' : [-1,2,-3,-4,5,-1,5,-4,-3,4,5,2,-3],
'12a_304' : [-1,2,-3,4,-1,-3,-3,-3,4,-3,2,-3],
'12a_305' : [-1,2,-3,4,-1,4,-3,4,2,4,4,-3],
'12a_306' : [-1,2,-3,4,5,-1,-3,-4,5,-4,-3,2,-3],
'12a_307' : [-1,2,-1,-2,3,-4,5,3,-4,-2,5,-2,3],
'12a_308' : [-1,2,-3,-4,-1,3,-4,2,-5,-3,2,4,-3,4,5],
'12a_309' : [-1,2,-3,-4,5,-1,2,-3,-4,2,-4,3,3,4,5],
'12a_310' : [-1,2,-3,4,-1,2,4,-3,2,-3,-3,4],
'12a_311' : [-1,2,-1,2,3,4,4,3,2,2,2,2,-3,4,-3,-4],
'12a_312' : [-1,-1,-2,1,-2,-3,2,-3,-2,4,-3,2,-3,-4,5,-4,5],
'12a_313' : [-1,2,2,3,-4,1,-4,1,3,2,2,-3,4,-3,2,-4],
'12a_314' : [1,-2,3,4,1,-2,4,5,3,5,3,4,-3,4,-5],
'12a_315' : [-1,2,3,-4,-1,3,-2,3,3,4,4,4,3,2],
'12a_316' : [-1,2,-3,4,-1,2,4,-3,2,-3,4,-3],
'12a_317' : [-1,2,3,3,4,2,-3,-1,-1,2,2,3,-4,3,-4,2],
'12a_318' : [-1,2,-3,4,-1,4,-3,2,-3,-3,4,-3],
'12a_319' : [-1,2,2,3,1,3,1,2,-3,4,2,2,2,-3,4,3],
'12a_320' : [-1,-1,-2,1,-2,-3,2,4,3,-2,-5,-4,-3,-3,-3,-4,-5],
'12a_321' : [-1,2,-3,2,2,1,1,1,2,2,2,-3,2],
'12a_322' : [-1,2,-1,-2,-3,-3,-4,-4,-4,-3,2,-3,-3,2,4,3],
'12a_323' : [-1,2,3,-1,-1,-2,3,3,4,-2,4,-2,-3,4],
'12a_324' : [-1,2,2,-3,-4,2,2,3,-1,-4,-1,2,3,3],
'12a_325' : [-1,2,3,3,-4,2,3,-1,-4,-1,2,2,-3,2],
'12a_326' : [-1,2,2,-3,-4,2,1,-4,3,3,4,5,2,-3,-4,2,5],
'12a_327' : [-1,2,2,3,-4,3,1,-4,1,2,-3,-3,2,4,-3,2],
'12a_328' : [-1,2,-3,4,-1,2,4,2,-3,4,2,-3],
'12a_329' : [-1,2,3,-1,3,-4,3,-2,3,2,4,4,4,4],
'12a_330' : [-1,2,-1,-2,-3,4,5,-3,-4,5,-4,-3,-2,-2,3],
'12a_331' : [-1,2,-3,-4,-1,-2,-4,3,-2,-4,-4,-4,3,3],
'12a_332' : [-1,2,-1,-2,-3,4,-5,-3,-2,-2,3,4,-3,4,-5],
'12a_333' : [-1,2,-3,4,-1,2,4,-3,2,4,-3,-3],
'12a_334' : [-1,2,-3,-4,-1,-2,3,3,-4,3,-2,-4,3,3],
'12a_335' : [-1,-2,-2,3,4,-2,-2,-3,-1,4,-1,2,3,3],
'12a_336' : [-1,2,2,3,-4,3,1,3,1,2,2,3,-4,-3,-3,2],
'12a_337' : [-1,2,-3,-4,-1,3,-4,-2,5,-2,3,-4,-2,3,5],
'12a_338' : [1,-2,-3,4,1,4,5,3,5,3,-4,-2,3,-4,-5],
'12a_339' : [-1,-1,-2,1,-2,3,2,-4,3,-2,-2,5,-4,-3,-3,5,-4],
'12a_340' : [-1,2,-3,4,-1,2,4,-3,2,4,5,-3,-4,3,5],
'12a_341' : [-1,2,-3,-1,-3,2,-3,4,2,2,-3,4],
'12a_342' : [-1,2,-3,4,-1,2,-3,2,2,-3,-3,4],
'12a_343' : [-1,2,3,-4,-1,-2,-4,3,-2,-4,5,3,-4,-3,5],
'12a_344' : [-1,2,-1,-2,-3,-3,-4,-2,-4,-2,-4,3,-4,-4],
'12a_345' : [-1,2,-1,-2,-3,-3,-4,-5,4,-2,-5,-2,3,-4,-4],
'12a_346' : [-1,2,-3,2,1,1,1,2,-3,2,-3,-3,-3],
'12a_347' : [-1,2,3,-1,-2,3,-4,3,-2,3,-2,4,4,4],
'12a_348' : [-1,2,-3,4,-1,-3,-2,3,-4,3,2,-5,4,-5,4],
'12a_349' : [-1,2,-3,-4,-1,-2,-4,3,-2,-4,3,-4,-4,3],
'12a_350' : [-1,2,2,-3,2,2,3,1,3,-4,1,2,-3,2,3,-4],
'12a_351' : [-1,2,-3,-4,-1,-2,-4,3,-2,3,3,-4,3,3],
'12a_352' : [-1,2,-3,-4,-1,-2,-4,3,-2,3,-4,3,-4,3],
'12a_353' : [-1,2,2,-3,1,-3,4,1,-2,4,-2,3,3,-4,3,2],
'12a_354' : [-1,-2,3,-2,-2,1,1,2,3,4,4,4,3,-2,3,-4],
'12a_355' : [-1,2,-3,-1,-3,-3,-4,-2,-4,3,-2,-4,-4,-4],
'12a_356' : [-1,2,-1,-2,3,-4,-5,-2,-2,-3,-3,-3,4,-5,-4],
'12a_357' : [-1,2,-3,4,-5,-1,2,3,-5,3,3,4,-5],
'12a_358' : [-1,2,-3,4,-1,-3,-1,2,-3,4,-3,4],
'12a_359' : [-1,2,-3,4,-1,-1,2,-3,2,4,-3,4],
'12a_360' : [-1,2,-1,-2,-3,2,-3,2,-3,-4,5,2,3,-4,5],
'12a_361' : [-1,2,-3,4,-1,2,-3,4,-3,2,-3,4],
'12a_362' : [-1,2,-3,-4,-1,-2,-2,3,-4,-2,3,-2,-4,3],
'12a_363' : [-1,2,-3,-4,-1,-2,-4,-2,-2,3,-2,-4,3,3],
'12a_364' : [-1,2,-3,-4,-1,-2,3,-2,3,-4,3,-2,-4,3],
'12a_365' : [-1,2,2,3,-1,3,-1,-1,-1,2,-1,2,-3],
'12a_366' : [-1,2,2,-3,-4,3,1,-4,-3,1,2,-3,2,-3],
'12a_367' : [-1,-1,-1,-2,-2,-2,-2,-3,-1,-3,2,-3,-1],
'12a_368' : [-1,-2,-2,-2,-2,-3,-1,-1,2,-3,-4,3,-4,-3],
'12a_369' : [-1,2,2,2,2,-1,-1,2,2,2,2,2],
'12a_370' : [1,2,2,2,2,-3,-3,2,2,2,1,-2,-3],
'12a_371' : [1,2,-3,-3,2,2,2,2,2,-3,2,1,-2],
'12a_372' : [-1,2,3,-2,3,2,4,-1,-1,2,2,2,3,-2,3,-4],
'12a_373' : [-1,-2,-2,-2,-2,-1,-1,2,3,-4,-2,-4,3,-4],
'12a_374' : [-1,2,-3,4,-1,-1,2,2,2,-3,4,-3],
'12a_375' : [1,1,1,2,2,2,2,-3,-3,2,1,-2,-3],
'12a_376' : [-1,2,3,4,-3,4,3,-2,3,-1,3,-1,3,2],
'12a_377' : [-1,2,-3,4,-1,-1,2,-3,4,-3,4,4],
'12a_378' : [-1,2,-3,-4,5,-1,3,5,2,-4,5,-3,2],
'12a_379' : [-1,2,-1,-2,-3,4,4,-3,4,-2,-2,-2,-2,3],
'12a_380' : [-1,2,-1,-2,3,-2,-3,-4,5,5,-4,-3,-2,4,5],
'12a_381' : [-1,2,3,-1,3,3,3,4,-5,2,-3,4,-5],
'12a_382' : [-1,2,-3,4,-1,-3,4,-3,2,-3,-3,-3],
'12a_383' : [-1,2,-3,4,-1,4,-3,4,2,-3,-3,-3],
'12a_384' : [-1,2,-3,-4,5,-1,-4,5,-4,3,-4,2,-3],
'12a_385' : [-1,2,-3,-4,5,-1,5,-4,3,-4,5,2,-3],
'12a_386' : [-1,2,-1,2,-3,-3,-4,-2,-2,3,-2,-4,-2,3],
'12a_387' : [-1,2,-1,2,-3,-3,-4,-2,3,3,-2,3,-4,3],
'12a_388' : [-1,2,-3,4,-1,-3,4,2,2,-3,2,-3],
'12a_389' : [-1,2,-3,-4,-1,-2,-2,3,-4,3,-2,3,-4,3],
'12a_390' : [-1,2,-3,2,2,1,1,1,2,-3,2,-3,-3],
'12a_391' : [-1,2,2,3,1,3,1,3,3,2,-3,4,2,-3,4,3],
'12a_392' : [-1,-1,-2,1,-2,-3,2,4,3,-2,-5,-4,-3,-3,-4,-5,-5],
'12a_393' : [-1,-2,3,2,2,1,1,-2,3,-4,3,2,2,2,3,-4],
'12a_394' : [1,2,-3,-3,2,2,-1,2,2,2,-3,2,1],
'12a_395' : [-1,2,3,3,2,-1,-1,-2,3,4,-3,4,2,2,2,-3],
'12a_396' : [-1,-2,3,-4,-2,-1,-1,2,3,3,3,-2,3,-4],
'12a_397' : [-1,2,-3,4,-5,-2,-5,-2,-3,4,-2,-5,-1,2,-3],
'12a_398' : [-1,2,-3,4,-1,-3,-1,-3,2,-3,4,-3],
'12a_399' : [-1,2,3,4,4,3,-2,3,-4,3,-1,3,-1,2],
'12a_400' : [-1,2,2,-3,4,5,2,-3,-4,1,2,-3,5,4,-3,5,2],
'12a_401' : [-1,-2,3,-2,1,-2,3,-2,4,-5,4,3,-4,-5,-5],
'12a_402' : [-1,2,-3,4,-1,-3,-1,2,-3,2,4,-3],
'12a_403' : [-1,2,-3,-4,5,-1,-3,-4,2,3,3,4,4,5,-3],
'12a_404' : [-1,2,-1,-2,-3,2,2,-3,-4,5,2,2,3,-4,5],
'12a_405' : [-1,2,-1,-2,3,-4,5,2,-3,-3,2,-3,-3,-4,5],
'12a_406' : [-1,2,-3,4,-1,2,4,5,5,4,-3,4,-5],
'12a_407' : [-1,2,-3,-4,-1,2,-3,-4,-3,-5,4,2,-5,-3,4],
'12a_408' : [-1,-2,3,-4,3,2,2,1,1,-2,3,2,-4,2,2,3],
'12a_409' : [-1,2,-3,2,2,2,2,1,1,1,2,-3,2],
'12a_410' : [-1,2,-1,-2,-2,-2,-3,4,3,3,-2,-2,-3,4,-3,-3],
'12a_411' : [1,2,-3,-3,2,2,2,2,-1,2,-3,2,1],
'12a_412' : [-1,2,-1,-2,-2,-2,-3,4,4,-3,-2,-2,3,-4,3,4],
'12a_413' : [-1,2,-3,-1,-1,2,-3,4,-3,2,-3,4],
'12a_414' : [-1,-1,-2,1,-2,-1,3,-2,1,-2,-3,-3,-4,3,5,-4,5],
'12a_415' : [-1,2,-3,4,-1,4,-3,2,-3,4,-3,4],
'12a_416' : [-1,2,-3,4,-1,4,-3,4,2,-3,4,4],
'12a_417' : [-1,2,-1,2,-3,-3,-4,-2,3,-2,3,-2,-4,3],
'12a_418' : [-1,2,-3,-1,2,-3,4,-3,-3,2,-3,4],
'12a_419' : [-1,2,-3,4,-1,2,4,-3,2,4,-3,4],
'12a_420' : [-1,2,-1,-2,-3,-3,-4,-2,-2,3,-4,-4,-4,-4],
'12a_421' : [-1,2,-1,-2,-3,-3,-4,-2,-2,3,-4,-5,4,-5,-4],
'12a_422' : [-1,2,-1,-2,3,3,-2,-2,3,3,3,3,3],
'12a_423' : [-1,2,-1,-2,3,3,-2,-2,3,3,3,4,-3,4],
'12a_424' : [-1,2,-1,-2,3,3,-2,-2,3,4,-3,4,4,4],
'12a_425' : [-1,2,-1,-2,3,3,-2,-2,3,4,5,-3,-4,5,4],
'12a_426' : [-1,2,3,3,2,-1,-1,2,-3,-4,2,-4,3,-4],
'12a_427' : [-1,2,-3,-1,-3,4,2,-3,2,4,2,-3],
'12a_428' : [-1,2,2,3,-1,3,-1,-1,2,-1,2,2,-3],
'12a_429' : [-1,2,2,-3,-4,3,1,-4,1,2,-3,2,2,-3],
'12a_430' : [1,1,1,2,2,-3,-3,2,-1,2,-3,2,2],
'12a_431' : [-1,2,2,3,1,1,2,2,3,-4,3,-2,3,3,4,4],
'12a_432' : [-1,2,2,3,1,3,1,-2,3,4,2,2,2,-3,4,3],
'12a_433' : [-1,2,-3,4,-5,-1,2,-3,-5,-4,-4,-4,-5],
'12a_434' : [-1,2,3,-4,-1,2,-4,-3,2,3,3,3,-4,3],
'12a_435' : [-1,2,-3,4,-1,4,-1,-2,-2,-2,3,3,3,4],
'12a_436' : [-1,2,-3,4,-1,4,-1,2,-3,4,4,4],
'12a_437' : [-1,2,-1,-2,3,-4,5,-2,5,-2,3,-4,5],
'12a_438' : [-1,2,-1,2,-3,2,-3,-2,3,-2,3,-4,3,-4],
'12a_439' : [-1,2,-3,4,-1,-3,4,2,-3,2,4,-3],
'12a_440' : [-1,2,2,3,-1,3,2,-1,2,2,2,2,-3],
'12a_441' : [-1,2,2,-3,1,-3,1,-2,-2,3,3,3,4,-3,2,4],
'12a_442' : [-1,2,-3,-4,-1,-1,-2,-2,-2,-2,-2,3,-4,-3],
'12a_443' : [1,2,-3,4,5,2,5,1,-2,3,3,3,4,-5,4],
'12a_444' : [-1,2,-3,4,-5,-1,3,-5,-2,-4,3,-2,-4,-4,-5],
'12a_445' : [-1,2,-3,4,-1,4,-1,2,2,2,-3,4],
'12a_446' : [-1,2,-3,4,-1,-3,-1,-3,4,2,-3,4],
'12a_447' : [1,-2,-3,4,-5,1,2,-3,-2,-5,1,4,-5],
'12a_448' : [-1,2,3,4,-1,4,5,-6,3,2,-3,-4,5,3,-4,-6],
'12a_449' : [-1,-2,-2,-3,4,2,1,2,-3,2,4,-5,4,-3,2,4,5],
'12a_450' : [-1,2,-3,-4,-5,-1,2,4,-5,-3,4,-3,2,-3,-4],
'12a_451' : [-1,2,-3,4,-1,2,4,2,-3,2,-3,4],
'12a_452' : [-1,2,3,-4,-1,3,-1,2,-3,2,-4,2,3,-4],
'12a_453' : [-1,2,-3,4,-1,2,-3,-3,-3,4,4,4],
'12a_454' : [-1,2,-3,-4,5,-1,3,5,2,5,-4,5,-3],
'12a_455' : [-1,2,-3,-1,-3,4,-3,2,-3,2,4,-3],
'12a_456' : [-1,2,-3,4,-1,2,-3,4,4,-3,-3,4],
'12a_457' : [-1,2,-3,4,-1,-3,2,-3,4,-3,2,-3],
'12a_458' : [-1,2,-3,4,-1,2,-3,2,4,-3,2,-3],
'12a_459' : [-1,2,-3,-4,-1,2,3,-4,-3,-5,2,-3,4,-5,-4],
'12a_460' : [1,2,3,-4,5,3,4,-2,1,-2,-3,4,-3,-5,-4,3,-4],
'12a_461' : [-1,2,2,-3,-4,2,2,3,1,-4,3,1,2,-3,2,3],
'12a_462' : [-1,2,-3,4,-1,2,2,2,-3,-3,-3,4],
'12a_463' : [-1,2,3,-4,5,-1,-2,3,-4,2,-4,-4,5],
'12a_464' : [-1,2,-3,-4,-1,-2,3,3,-2,3,-4,3,-2,3],
'12a_465' : [-1,2,-3,4,-1,2,-3,-3,2,2,-3,4],
'12a_466' : [-1,2,-3,-4,-1,-2,-2,3,-4,-2,-2,3,-2,3],
'12a_467' : [-1,2,-3,-4,-1,-2,3,-2,3,-2,-4,3,-2,3],
'12a_468' : [-1,-2,3,3,-2,3,-1,3,-1,3,4,2,-3,4],
'12a_469' : [-1,-2,3,3,-2,3,-4,3,-1,-1,-2,3,2,-4],
'12a_470' : [-1,2,-3,-4,-1,2,-4,2,2,3,-2,-4,-3,-3],
'12a_471' : [-1,2,3,-4,-5,6,-1,3,-5,6,2,-4,5,-3],
'12a_472' : [-1,2,-3,-4,-1,-4,-3,2,-3,4,-5,-3,4,-5,-4],
'12a_473' : [-1,2,-3,-4,-1,-2,3,-2,3,-4,3,-2,3,3],
'12a_474' : [-1,2,-3,-4,-1,-2,-2,3,-4,-2,3,-2,3,3],
'12a_475' : [-1,-2,3,-2,-2,3,-2,3,4,-1,-1,2,-3,4],
'12a_476' : [-1,2,-3,-1,-3,4,-3,-3,2,-3,4,-3],
'12a_477' : [-1,2,-3,4,-5,6,-1,2,-3,4,-5,6],
'12a_478' : [-1,2,-3,-1,-3,4,-3,-3,4,2,-3,4],
'12a_479' : [-1,2,3,-1,3,-4,-2,3,-2,3,3,-2,-4,-3],
'12a_480' : [-1,-2,3,-2,3,-2,-4,-1,-1,2,3,-2,3,-4],
'12a_481' : [-1,2,-3,4,5,-1,2,-3,-3,-3,-4,5,4],
'12a_482' : [-1,2,-3,4,5,6,-1,2,-3,-5,6,-4,5,-4],
'12a_483' : [-1,2,-3,-4,-1,-2,3,-2,-4,3,-2,-4,3,3],
'12a_484' : [-1,-2,3,-2,3,-2,4,-3,-1,4,-1,2,3,3],
'12a_485' : [-1,2,-3,4,-1,-3,4,-3,2,-3,4,-3],
'12a_486' : [-1,2,-3,4,-1,-3,4,-3,4,2,-3,4],
'12a_487' : [-1,2,3,-1,3,-4,-2,-2,3,-2,3,-2,-4,-3],
'12a_488' : [-1,2,3,-1,3,-4,3,-2,3,3,3,-2,-4,-3],
'12a_489' : [-1,2,3,-4,5,-1,2,-3,-4,2,-3,-3,-3,-4,5],
'12a_490' : [-1,2,2,3,-4,3,1,1,-2,3,2,4,2,4,2,3],
'12a_491' : [-1,2,-3,4,-1,-3,4,-2,-5,4,4,3,2,-4,-5],
'12a_492' : [1,-2,3,4,5,-2,-3,4,1,2,-3,-2,4,-5,4,-3,-2],
'12a_493' : [-1,2,3,-1,3,-4,3,3,3,-2,3,-2,-4,-3],
'12a_494' : [-1,2,-3,4,5,-2,-2,-3,4,1,2,-3,4,-5,4,-3,2],
'12a_495' : [-1,2,-3,2,2,1,1,1,2,2,-3,2,-3],
'12a_496' : [-1,2,-1,2,-3,2,2,3,-1,3,2,-1,2],
'12a_497' : [-1,2,-3,4,2,-3,4,-3,2,-1,-1,2],
'12a_498' : [-1,2,-1,2,-3,2,-3,4,4,-3,2,4],
'12a_499' : [-1,2,-3,4,4,-3,2,-3,4,-1,-1,2],
'12a_500' : [-1,2,-1,2,2,-3,4,-3,4,2,-3,2],
'12a_501' : [-1,2,-3,4,-1,-3,4,2,4,4,-3,2],
'12a_502' : [-1,2,2,3,3,2,2,2,2,2,-1,2,-3],
'12a_503' : [-1,2,-1,2,2,-3,2,-3,-4,-3,2,-3,2,4],
'12a_504' : [-1,2,2,3,1,1,2,3,-4,3,-2,-4,3,2,-3,2],
'12a_505' : [-1,2,-3,-1,2,-3,-4,-3,2,-4,3,-4,-3,2],
'12a_506' : [-1,2,-1,2,-3,2,-3,4,-3,4,-3,2],
'12a_507' : [-1,2,2,3,3,2,2,2,-1,2,2,2,-3],
'12a_508' : [-1,2,2,1,1,2,2,2,-3,-4,2,3,-4,3],
'12a_509' : [-1,-1,2,2,-3,-1,2,2,3,3,2,-1,2],
'12a_510' : [-1,2,2,1,1,2,-3,2,-3,-4,-4,-3,-3,4],
'12a_511' : [-1,2,-1,2,-3,2,2,3,3,2,2,2,-1],
'12a_512' : [-1,2,-3,-1,-3,-3,4,4,-3,4,2,-3],
'12a_513' : [-1,2,2,1,1,2,-3,2,3,-4,3,-2,4,-3,4,-3],
'12a_514' : [-1,2,2,1,1,2,-3,2,3,-4,3,-4,-4,3],
'12a_515' : [-1,2,-3,-4,-2,3,-4,3,-2,3,-1,3,-1,2],
'12a_516' : [-1,2,-3,-4,2,-3,-4,-3,2,-3,-1,4,-1,2],
'12a_517' : [-1,2,-1,2,2,-3,4,2,4,-3,2,4],
'12a_518' : [-1,2,-3,4,5,-1,-3,-4,5,4,2,-3,2],
'12a_519' : [-1,2,2,2,2,3,3,2,2,2,-1,2,-3],
'12a_520' : [-1,2,3,-2,3,3,-4,3,-4,3,2,1,1,2],
'12a_521' : [-1,2,-3,-1,-3,-3,4,-3,4,-3,2,-3],
'12a_522' : [-1,2,2,1,1,2,-3,2,3,3,-4,3,-4,3],
'12a_523' : [-1,2,-1,-1,2,-3,2,2,3,-1,3,2,-1],
'12a_524' : [-1,2,-3,4,-5,-1,3,4,-5,-4,3,-4,2,-4,-3],
'12a_525' : [-1,2,3,-4,-1,3,-4,-5,-4,3,-4,-2,5,3,-2],
'12a_526' : [-1,2,-1,-1,2,-3,2,2,3,3,2,-1,2],
'12a_527' : [-1,2,2,3,3,2,2,-1,2,-1,2,2,-3],
'12a_528' : [-1,2,-3,4,2,4,-3,2,4,-1,-1,2],
'12a_529' : [-1,2,-3,4,-1,-3,4,-5,-4,3,-4,2,5,-3,2],
'12a_530' : [-1,2,3,-4,5,-1,-4,5,3,4,2,-5,-3,2,-4],
'12a_531' : [-1,-1,-1,2,2,3,3,2,-1,2,2,2,-3],
'12a_532' : [-1,2,2,1,1,2,-3,-4,2,-4,-4,3,-4,3],
'12a_533' : [-1,2,-1,2,-3,2,2,2,2,3,3,2,-1],
'12a_534' : [-1,2,-1,-2,3,-2,-3,-3,-3,4,4,-3,-2,4],
'12a_535' : [-1,2,-3,4,2,4,-1,4,-1,-3,2,4],
'12a_536' : [-1,2,-3,4,-1,2,4,4,4,-3,2,4],
'12a_537' : [-1,2,-3,4,5,-1,2,5,4,-3,2,4,-5],
'12a_538' : [-1,2,-1,2,3,3,2,2,2,2,2,2,-3],
'12a_539' : [-1,2,2,2,3,-4,-2,3,-4,3,2,1,1,2],
'12a_540' : [-1,2,3,-4,-2,3,-4,3,2,1,1,2,2,2],
'12a_541' : [-1,2,-3,4,-1,2,-3,2,4,2,4,4],
'12a_542' : [-1,2,-1,2,3,-2,3,4,-3,4,-5,4,-3,4,3,5,2],
'12a_543' : [-1,2,3,-4,5,-1,3,3,-4,5,4,2,-3,2,-4],
'12a_544' : [-1,2,-1,-1,-1,2,-3,2,2,3,3,2,-1],
'12a_545' : [-1,2,-1,-2,3,3,4,4,3,3,-4,-2,-2,3],
'12a_546' : [-1,2,-3,-4,5,-1,-4,5,3,-4,-2,3,-2,-4,3],
'12a_547' : [-1,2,3,3,2,1,1,-2,3,-4,3,-4,2,2,2,-3],
'12a_548' : [-1,2,2,1,1,2,-3,-4,2,2,2,3,-4,-3],
'12a_549' : [-1,-2,3,4,4,5,5,4,-3,4,-2,-5,-1,2,3],
'12a_550' : [-1,2,3,-4,5,-1,-2,5,-4,3,-2,-4,5],
'12a_551' : [-1,2,3,-4,5,3,5,4,-5,4,3,2,-1,2,-3],
'12a_552' : [-1,2,3,-4,5,-1,-2,-4,5,-4,3,-2,-4],
'12a_553' : [-1,2,2,-1,2,-3,2,2,-1,3,3,2,2],
'12a_554' : [-1,-1,2,1,-3,2,-1,4,-3,-3,5,-4,3,2,5,4,-3],
'12a_555' : [-1,2,-3,4,-1,2,4,5,3,5,-4,3,-4,-4,-5],
'12a_556' : [-1,2,2,1,1,2,3,-2,3,4,-3,2,2,2,-3,-4],
'12a_557' : [-1,-1,-1,-2,1,-2,-2,-3,2,2,-4,3,-2,5,-4,-3,5],
'12a_558' : [-1,2,-1,2,3,3,3,2,-1,2,2,2,-3],
'12a_559' : [-1,2,3,-4,-1,-2,3,-4,-4,-3,-3,2,3,-4,3,-2],
'12a_560' : [-1,2,-3,4,-5,-1,-3,4,-5,-4,3,4,2,-3,4],
'12a_561' : [-1,2,-3,-1,-3,-1,2,-3,4,-3,2,-3,-3,-4],
'12a_562' : [-1,2,3,4,-5,-1,-2,3,-2,-5,-3,4,-5,3,-2],
'12a_563' : [-1,2,2,2,2,1,1,2,-3,2,-3,4,3,-2,3,-4],
'12a_564' : [-1,2,-1,-2,3,-2,-3,4,-3,4,-5,-4,3,-4,-3,5,-2],
'12a_565' : [-1,2,-3,-1,-3,-3,-4,2,-4,-3,2,3,-4,-3],
'12a_566' : [-1,2,3,-4,-5,-1,-4,-5,3,-4,-2,5,3,-2,-4],
'12a_567' : [-1,2,-1,2,-1,3,-1,3,3,2,-1,2,-3],
'12a_568' : [-1,2,2,1,1,2,3,-2,3,3,3,4,-3,2,-3,-4],
'12a_569' : [-1,2,-3,-4,-1,-2,-4,-4,-4,3,-2,-4,3,3],
'12a_570' : [-1,2,-3,-4,-5,-1,2,4,-5,-3,-4,-3,2,-3,4],
'12a_571' : [1,1,1,2,-3,2,-3,-1,2,-3,2,2,-3],
'12a_572' : [-1,2,2,3,-1,3,-1,2,2,2,-1,2,-3],
'12a_573' : [-1,-1,-1,2,2,3,-1,3,-1,2,-1,2,-3],
'12a_574' : [-1,-2,-2,-2,-2,-2,-2,-3,-1,-3,2,-3,-1],
'12a_575' : [-1,2,-3,-1,-1,-2,-2,-2,-3,-3,-4,3,-4,-3],
'12a_576' : [-1,2,2,2,2,2,2,-1,-1,2,2,2],
'12a_577' : [1,2,-3,-3,2,2,2,-3,2,2,2,1,-2],
'12a_578' : [1,1,1,2,-3,-3,2,2,2,-3,2,1,-2],
'12a_579' : [-1,2,-3,4,-1,4,-1,2,4,-3,4,-3],
'12a_580' : [-1,2,-1,-2,3,3,-2,-2,-2,-2,-2,-2,3],
'12a_581' : [-1,2,2,2,3,-4,-4,3,2,-3,-4,1,1,2],
'12a_582' : [-1,2,3,-4,-4,3,2,-3,-4,1,1,2,2,2],
'12a_583' : [-1,2,-3,4,-1,-3,4,4,4,-3,2,-3],
'12a_584' : [-1,2,-3,4,-1,4,4,4,-3,4,2,-3],
'12a_585' : [-1,2,-3,4,5,-1,5,4,-3,4,-5,2,-3],
'12a_586' : [-1,2,2,3,1,3,1,2,2,2,-3,4,2,-3,4,3],
'12a_587' : [-1,2,2,3,3,3,2,-1,2,2,2,-3,2],
'12a_588' : [-1,2,3,-1,3,-1,3,2,2,-1,2,-3,2],
'12a_589' : [1,2,-3,-3,2,2,-1,2,-3,2,2,2,1],
'12a_590' : [-1,2,2,2,-1,2,3,3,3,3,2,2,-3],
'12a_591' : [-1,2,-1,-2,-3,4,-3,-3,-3,4,-3,-2,-2,3],
'12a_592' : [-1,2,2,3,3,2,2,-3,-4,1,1,-2,3,2,-4,2],
'12a_593' : [-1,2,2,-3,1,-3,1,2,-3,-4,2,3,-4,-3],
'12a_594' : [-1,2,3,4,-2,-3,4,3,2,-1,-1,2,2,2],
'12a_595' : [-1,2,3,-4,5,-1,3,5,-2,-4,5,3,-2],
'12a_596' : [1,2,3,-4,-5,3,-5,4,-5,4,3,2,1,-2,-3],
'12a_597' : [-1,2,-3,4,5,-1,-3,-4,5,4,-3,2,-3],
'12a_598' : [1,1,1,2,-3,2,-1,2,2,-3,-3,-3,2],
'12a_599' : [1,1,1,2,-3,-3,2,2,-1,2,-3,2,1],
'12a_600' : [-1,2,2,2,2,1,1,2,-3,-4,2,3,-4,3],
'12a_601' : [-1,-2,3,4,5,5,4,-5,4,3,-4,2,-1,2,3],
'12a_602' : [-1,2,-1,-1,-1,2,3,3,3,2,-1,2,-3],
'12a_603' : [-1,2,3,-4,-1,-2,3,-2,3,4,4,4,3,-2],
'12a_604' : [-1,2,3,-4,5,-1,-3,5,2,4,-3,2,4,5,-3],
'12a_605' : [-1,-1,2,-3,-1,2,2,3,-1,3,-1,2,-1],
'12a_606' : [-1,2,2,-3,1,-3,1,2,-3,-4,3,-4,2,-3],
'12a_607' : [-1,2,3,3,2,2,-1,2,2,2,-3,2,-1],
'12a_608' : [-1,2,-3,-3,2,1,1,2,2,-3,4,2,3,-2,3,-4],
'12a_609' : [-1,2,3,3,-4,2,1,1,-2,3,2,-4,2,-4,2,-3],
'12a_610' : [-1,-1,-1,-2,1,-3,2,-1,-3,-2,-2,-4,3,-4,-5,4,-5],
'12a_611' : [-1,-2,3,4,4,3,-2,3,-4,3,1,1,2,2,-3,2],
'12a_612' : [-1,2,3,-4,-1,3,-2,3,3,4,4,4,3,-2],
'12a_613' : [-1,2,3,-4,-4,3,-2,3,-4,3,1,3,1,2],
'12a_614' : [-1,2,-3,4,-1,2,4,5,3,5,3,-4,3,-4,-5],
'12a_615' : [-1,2,2,3,1,3,1,2,2,-3,4,2,4,3,3,-4],
'12a_616' : [1,1,1,2,2,-3,2,-1,2,-3,2,2,-3],
'12a_617' : [-1,2,2,3,-1,3,-1,2,2,-1,2,-3,-1],
'12a_618' : [1,1,1,2,-3,2,2,-3,-1,2,-3,2,2],
'12a_619' : [-1,-1,-1,-2,1,-2,3,-2,-2,-4,3,2,-4,-5,4,3,-5],
'12a_620' : [-1,2,-1,2,3,3,3,2,-1,2,-3,2,2],
'12a_621' : [-1,2,-3,4,-1,-2,3,3,3,-2,-2,3,3,4],
'12a_622' : [-1,-2,3,-4,5,2,2,3,4,-1,2,-3,4,-5,-4,-4,3],
'12a_623' : [-1,2,2,1,1,2,-3,2,-3,4,4,4,3,-2,3,-4],
'12a_624' : [-1,2,3,4,2,-3,4,3,2,-3,-1,-1,2,2,-3,2],
'12a_625' : [-1,2,-3,-4,5,-1,3,5,-2,-4,3,-2,-4,5,3],
'12a_626' : [1,1,1,2,-3,2,-1,2,-3,-3,2,-3,2],
'12a_627' : [-1,2,-3,4,-1,2,-3,2,4,2,-3,-3],
'12a_628' : [-1,2,2,1,1,2,3,-4,3,-2,3,-4,3,-4],
'12a_629' : [-1,-2,3,-4,3,2,2,3,-4,-1,-1,2,3,-4],
'12a_630' : [-1,2,-3,4,-1,-2,4,3,3,-2,3,-2,3,4],
'12a_631' : [-1,2,2,-3,4,-3,1,1,2,-3,2,-4,-4,-3],
'12a_632' : [-1,2,2,1,1,2,-3,4,3,-2,-3,2,-3,-3,4,-3],
'12a_633' : [-1,2,2,1,1,2,-3,4,-3,2,-3,-2,3,4,-3,4],
'12a_634' : [-1,2,3,4,-2,3,4,3,2,-3,-1,-4,-1,2,2,2],
'12a_635' : [-1,2,3,4,-5,-1,-3,-5,2,4,-5,-3,2,3,3],
'12a_636' : [-1,-1,-2,1,-2,-2,-3,2,2,-4,3,-2,5,-4,-3,5,5],
'12a_637' : [-1,2,3,-4,-1,-4,3,-2,3,-4,3,2,2,3],
'12a_638' : [-1,2,2,-3,2,2,3,1,3,1,-2,3,4,-3,-2,4],
'12a_639' : [1,-2,-3,1,-3,1,2,-3,-3,-3,-2,1,-2],
'12a_640' : [-1,2,-1,-2,-3,4,-3,4,-3,4,-2,4,-2,3],
'12a_641' : [-1,2,-1,-2,3,3,3,3,-2,-2,3,3,3],
'12a_642' : [-1,2,-1,-2,3,4,-3,4,3,-2,-2,3,3,3],
'12a_643' : [-1,2,-1,-2,3,3,3,3,-2,-2,3,4,-3,4],
'12a_644' : [-1,2,-1,-2,3,4,5,-4,5,4,-3,4,-2,-2,3],
'12a_645' : [-1,-1,2,3,-1,3,3,2,-1,2,-3,2,2],
'12a_646' : [-1,-1,-1,2,2,3,-1,3,2,-1,2,2,-3],
'12a_647' : [-1,-1,-2,-2,-2,-3,-1,-1,-1,2,-1,-3,-3],
'12a_648' : [-1,2,-3,-1,-3,-3,-4,-2,-4,-2,-2,3,-2,-4],
'12a_649' : [-1,2,-3,4,-1,4,-1,2,4,4,-3,4],
'12a_650' : [1,2,-3,4,-5,-1,2,-3,2,-5,1,4,-5],
'12a_651' : [-1,2,-3,4,-1,2,-3,4,4,4,4,4],
'12a_652' : [-1,2,-3,4,-1,2,-3,4,4,5,-4,5,4],
'12a_653' : [-1,-1,-1,-2,1,-2,-3,2,-4,3,-2,-4,-3,-3,-5,4,-5],
'12a_654' : [-1,2,2,1,1,2,3,-4,3,3,-2,3,-4,3],
'12a_655' : [-1,2,-1,-2,3,4,4,3,-2,-2,3,3,-4,3],
'12a_656' : [-1,2,-3,-3,4,2,-3,1,1,2,2,3,-4,3,-4,2],
'12a_657' : [-1,-1,2,2,-3,-1,2,2,3,-1,3,2,-1],
'12a_658' : [-1,2,2,-3,1,1,2,-3,-4,3,2,-4,2,-3],
'12a_659' : [-1,2,2,3,1,1,2,2,3,-4,3,-2,3,4,4,3],
'12a_660' : [-1,2,2,3,3,3,2,-1,2,-3,2,2,2],
'12a_661' : [-1,2,-1,-2,3,-4,-2,-2,3,4,-3,-2,-2,3,-4,-4],
'12a_662' : [-1,2,-3,4,-1,-2,4,3,-2,3,-2,-2,3,4],
'12a_663' : [-1,2,-3,-4,5,-1,3,5,-2,-4,5,3,-2,3,3],
'12a_664' : [-1,2,-3,4,-1,-2,4,3,3,3,-2,3,3,4],
'12a_665' : [-1,-1,2,1,1,3,-2,-1,-4,3,-2,-4,-5,4,3,-5,-4],
'12a_666' : [-1,2,3,-1,3,3,2,-3,2,-4,-5,3,4,-5,4],
'12a_667' : [-1,2,2,3,-1,3,-1,-1,2,2,2,-3,-1],
'12a_668' : [-1,2,2,3,-1,3,2,2,-1,-1,2,-3,-1],
'12a_669' : [-1,2,-1,-2,-3,4,4,-3,4,-2,4,-2,4,3],
'12a_670' : [-1,-1,2,-3,-1,2,2,3,-1,3,2,-1,2],
'12a_671' : [-1,2,2,3,-1,3,2,2,2,-1,2,2,-3],
'12a_672' : [-1,2,2,3,-1,3,2,2,-1,2,-1,2,-3],
'12a_673' : [-1,2,-3,4,-1,2,4,-3,4,-3,4,4],
'12a_674' : [-1,2,-3,4,-1,-3,-3,4,2,4,-3,4],
'12a_675' : [1,-2,-3,-3,2,-3,1,-3,-3,-2,1,-2,-2],
'12a_676' : [-1,2,-1,-2,-3,4,-3,-3,4,-3,-2,-2,3,4],
'12a_677' : [-1,2,2,1,1,2,-3,4,-3,2,-3,-2,3,-4,3,4],
'12a_678' : [-1,2,2,-3,1,1,2,-3,-4,2,2,3,-4,-3],
'12a_679' : [-1,-2,-3,4,-5,-3,-5,-2,-4,-1,-4,2,-4,-5,3],
'12a_680' : [-1,-1,2,2,-3,-1,2,-1,2,3,3,3,3],
'12a_681' : [-1,2,-3,4,-1,2,2,2,-3,4,4,4],
'12a_682' : [-1,2,3,-4,5,-1,-2,3,2,5,5,-4,5],
'12a_683' : [-1,2,-3,4,-1,2,4,4,-3,4,4,4],
'12a_684' : [-1,2,3,-4,5,-1,-2,-2,-2,3,-4,-2,5],
'12a_685' : [-1,2,2,1,1,2,3,-2,3,4,4,-3,2,2,-3,-4],
'12a_686' : [-1,2,2,3,-4,3,2,2,1,1,2,-3,2,-4],
'12a_687' : [-1,2,3,-4,5,-1,-2,3,-4,-2,-4,-3,-3,4,5],
'12a_688' : [1,-2,-3,1,-3,2,-3,-3,-3,-2,1,-2,-2],
'12a_689' : [-1,2,3,-4,5,-1,-2,3,-4,-2,-4,-4,5],
'12a_690' : [-1,2,3,-4,5,6,-1,3,-5,6,2,-4,5,-3],
'12a_691' : [-1,2,-3,4,5,6,-1,2,-3,-5,6,-4,5,4],
'12a_692' : [1,-2,1,1,1,2,-3,2,2,2,1,-3,-3],
'12a_693' : [-1,2,-3,-1,-3,-3,4,2,-3,-3,-3,4],
'12a_694' : [-1,-2,-2,-1,-1,-2,-3,4,-3,4,2,-3,-3,-3],
'12a_695' : [-1,-2,3,-4,3,-2,-2,-1,-1,2,3,-2,-4,3],
'12a_696' : [-1,2,-3,-1,-2,3,-2,3,-4,3,-2,3,-4,3],
'12a_697' : [-1,2,-3,-1,-3,4,2,-3,2,4,-3,4],
'12a_698' : [-1,2,-3,4,-1,-3,2,-3,2,4,-3,-3],
'12a_699' : [-1,2,-1,2,3,-4,3,3,-2,3,-2,-4,-3,-3],
'12a_700' : [-1,-2,3,-2,-1,-1,2,3,-4,3,-2,3,-4,3],
'12a_701' : [1,1,1,2,2,-3,2,-1,2,2,-3,-3,2],
'12a_702' : [-1,2,-3,4,-1,-3,-3,2,-3,4,-3,-3],
'12a_703' : [-1,2,-3,-4,-1,-2,-2,3,-4,-2,3,3,-4,3],
'12a_704' : [-1,2,3,-4,-1,2,-4,2,2,3,-2,3,3,-4],
'12a_705' : [-1,2,-3,-1,2,-3,2,4,-3,2,-3,4],
'12a_706' : [-1,-2,3,-4,-2,-1,-1,2,3,-2,3,-4,3,3],
'12a_707' : [-1,2,-3,-4,-1,-2,3,-2,-4,3,3,-4,3,3],
'12a_708' : [-1,2,-1,2,-3,-4,-2,3,-2,3,3,-4,3,3],
'12a_709' : [-1,2,-3,-1,2,-3,4,-3,2,-3,-3,4],
'12a_710' : [-1,2,-1,2,-3,-3,-4,-2,-2,3,-2,3,-4,3],
'12a_711' : [-1,2,-3,4,-1,-3,-3,4,2,-3,4,-3],
'12a_712' : [-1,2,-3,-1,-2,3,-2,-4,3,-2,-4,3,-4,3],
'12a_713' : [-1,-1,-1,2,2,3,3,2,2,2,-1,2,-3],
'12a_714' : [-1,-1,-1,-1,-1,2,2,3,3,2,-1,2,-3],
'12a_715' : [-1,2,2,1,1,2,-3,2,-3,-3,-4,3,-4,-3],
'12a_716' : [-1,2,2,2,2,2,2,2,2,-1,-1,2],
'12a_717' : [1,2,-3,-3,2,-3,2,2,2,2,2,1,-2],
'12a_718' : [-1,2,3,-1,3,2,2,2,-3,2,2,2,-1],
'12a_719' : [-1,2,2,2,3,4,-2,3,4,3,2,-3,-1,-4,-1,2],
'12a_720' : [-1,2,3,-1,3,2,2,2,2,2,-3,2,-1],
'12a_721' : [-1,2,2,2,3,-4,-4,3,-2,3,-4,1,1,2],
'12a_722' : [-1,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,2],
'12a_723' : [-1,2,3,3,2,-3,2,2,2,2,2,-1,2],
'12a_724' : [-1,2,3,3,2,2,2,-3,2,2,2,-1,2],
'12a_725' : [-1,2,2,2,-3,4,2,-3,-4,3,2,-3,1,4,1,2],
'12a_726' : [-1,2,3,3,2,2,2,2,2,-3,2,-1,2],
'12a_727' : [-1,2,-1,2,-3,2,3,3,3,4,4,3,2,-4],
'12a_728' : [-1,-1,-1,2,-1,2,-3,2,2,3,3,2,-1],
'12a_729' : [-1,2,2,1,1,2,-3,-4,3,-4,-3,2,-3,2],
'12a_730' : [-1,2,-3,4,2,-3,-4,3,2,-3,1,4,1,2,2,2],
'12a_731' : [-1,2,2,1,1,2,2,2,-3,-4,2,3,-4,-3],
'12a_732' : [-1,2,2,2,3,4,-2,-3,4,3,2,-1,-1,2],
'12a_733' : [-1,2,-1,2,2,2,-3,2,3,4,4,3,2,-4],
'12a_734' : [-1,2,2,-3,-1,-1,2,2,3,3,2,-1,2],
'12a_735' : [-1,2,-1,-2,-3,2,-3,4,-3,4,-5,-4,3,-4,-3,5,-2],
'12a_736' : [-1,2,2,1,1,2,-3,-4,2,-4,-4,3,-4,-3],
'12a_737' : [1,1,-2,1,1,1,2,-3,-3,2,-3,2,1],
'12a_738' : [-1,2,3,-4,-4,3,-2,3,1,3,1,3,-4,2],
'12a_739' : [-1,2,-1,2,2,3,3,3,-2,3,3,3,2],
'12a_740' : [-1,2,3,-4,3,-4,3,-2,3,1,3,1,3,2],
'12a_741' : [-1,2,3,-4,2,3,-4,3,2,-3,1,1,2,2,-3,2],
'12a_742' : [-1,-1,2,-3,-1,-1,-1,2,2,3,3,2,-1],
'12a_743' : [-1,-2,-3,4,4,5,5,4,-3,4,-2,-5,-1,2,3],
'12a_744' : [1,2,3,4,-5,-5,4,-5,4,3,-4,2,1,-2,-3],
'12a_745' : [-1,2,-1,2,-3,2,3,4,5,5,4,3,2,-4,-5],
'12a_746' : [-1,2,-1,2,-1,-3,-1,2,2,3,3,2,-1],
'12a_747' : [-1,2,3,-4,-1,2,-4,-3,2,2,2,3,3,-4],
'12a_748' : [-1,2,2,1,1,2,-3,2,-3,-3,-3,4,3,-2,3,-4],
'12a_749' : [-1,2,3,-4,-2,-3,4,-3,2,-3,1,4,1,2,2,2],
'12a_750' : [-1,-2,-2,-3,2,1,-3,4,-3,4,-5,-4,3,-4,2,5,-3,-2,-2],
'12a_751' : [-1,2,-3,4,5,-1,-3,5,-3,-4,-2,5,3,-2,4],
'12a_752' : [-1,2,-3,-3,-2,-2,1,-2,-2,-3,4,5,2,-3,5,4,-5],
'12a_753' : [-1,-1,2,-1,2,2,3,-2,-2,4,-3,2,4,5,-4,3,5],
'12a_754' : [-1,2,-3,4,-1,-2,4,-2,3,-2,3,3,3,4],
'12a_755' : [-1,-1,2,-3,2,-1,2,-1,3,3,3,2,2],
'12a_756' : [-1,2,3,-4,-1,2,-4,-3,2,3,3,3,3,-4],
'12a_757' : [1,1,1,-2,-3,-3,2,-3,-3,-3,-2,1,-2],
'12a_758' : [-1,2,-1,-2,-3,4,-3,4,4,4,-3,-2,-2,3],
'12a_759' : [-1,2,-1,-2,3,3,3,3,3,3,-2,-2,3],
'12a_760' : [-1,2,-1,-2,3,3,3,4,-3,4,3,-2,-2,3],
'12a_761' : [-1,2,-1,-2,3,4,-3,4,4,4,3,-2,-2,3],
'12a_762' : [-1,2,3,-1,-2,-2,-2,-2,-2,-2,-2,3,-2],
'12a_763' : [-1,2,2,2,-3,-4,2,3,-4,3,2,1,1,2],
'12a_764' : [-1,2,-3,-4,2,3,-4,3,2,1,1,2,2,2],
'12a_765' : [-1,2,2,3,-4,1,-4,1,-3,-2,3,-2,3,-4,3,-4],
'12a_766' : [-1,2,-3,4,-1,-2,4,3,-2,-2,-2,3,3,4],
'12a_767' : [-1,-1,-2,1,-2,-2,-2,-3,2,2,-4,3,-2,5,-4,-3,5],
'12a_768' : [-1,2,3,-4,-1,2,-4,2,2,-3,2,3,3,-4],
'12a_769' : [-1,2,-3,4,4,-3,4,5,-2,-2,1,-2,3,-4,-2,-3,5],
'12a_770' : [-1,-1,-1,-2,1,-2,-3,2,-3,-4,3,-2,5,-4,3,5,4],
'12a_771' : [-1,2,3,-4,2,-4,3,2,-4,-3,1,1,2,2,-3,2],
'12a_772' : [-1,2,3,-1,3,-4,3,-2,3,-2,4,4,4,4],
'12a_773' : [-1,2,-1,-2,-3,4,5,-3,-4,5,4,-3,-2,-2,3],
'12a_774' : [-1,2,-1,-2,3,4,5,-3,-4,5,4,3,-2,-2,3],
'12a_775' : [-1,-2,3,-4,5,3,5,4,-5,4,3,2,-1,2,3],
'12a_776' : [-1,2,-3,4,-1,-2,4,-2,3,3,3,-2,3,4],
'12a_777' : [-1,2,-3,4,-1,-2,4,3,-2,3,3,3,3,4],
'12a_778' : [-1,2,-3,4,-1,-2,4,-2,-2,3,-2,3,3,4],
'12a_779' : [1,2,-3,-4,2,-4,5,4,-3,2,4,1,-5,-4,-2,-3,4],
'12a_780' : [-1,-2,3,3,-2,1,1,2,3,4,4,3,3,-2,3,-4],
'12a_781' : [-1,2,-3,4,-5,-1,3,-5,3,4,-2,-5,3,-2,4],
'12a_782' : [-1,2,-3,4,5,-1,-3,5,-2,-4,5,3,-2,4,4],
'12a_783' : [-1,2,-3,4,-5,-1,4,-3,2,-3,4,-3,5,4,-3,-2,-3],
'12a_784' : [-1,2,2,-3,-1,-1,2,2,3,-1,3,2,-1],
'12a_785' : [-1,-2,3,-4,-2,-2,-1,-1,2,3,-2,-4,3,-4],
'12a_786' : [-1,2,-1,-2,-3,4,5,-3,-4,-2,5,-2,3,4,4],
'12a_787' : [-1,2,-1,-2,3,4,-3,4,-5,4,-3,4,3,5,-2,-2,3],
'12a_788' : [-1,-2,3,-2,-2,-1,-1,2,3,-4,3,-2,3,-4],
'12a_789' : [-1,-1,-1,2,2,3,-1,3,2,2,2,-3,-1],
'12a_790' : [-1,2,2,-3,1,1,2,2,2,-3,-4,3,-4,-3],
'12a_791' : [-1,2,-1,-2,-3,4,4,4,4,-3,4,-2,-2,3],
'12a_792' : [-1,2,-1,-2,-3,4,5,-4,5,4,-3,4,-2,-2,3],
'12a_793' : [-1,2,-3,4,-1,-3,4,2,-3,4,-3,4],
'12a_794' : [-1,2,2,2,3,-1,3,2,2,2,2,2,-3],
'12a_795' : [-1,2,-1,-2,-2,-3,4,-3,-3,-3,4,-2,3,-2],
'12a_796' : [-1,2,-3,4,-1,-3,-3,-3,-3,-3,4,-2,3,-2],
'12a_797' : [-1,-2,3,4,5,5,4,-5,4,-3,4,2,-1,2,3],
'12a_798' : [-1,2,3,-1,3,-4,3,-2,3,3,4,4,3,2],
'12a_799' : [-1,2,-1,-2,-3,4,5,-3,-3,-4,-2,5,-2,3,4],
'12a_800' : [-1,2,-3,4,-1,-3,-3,-3,4,-2,-2,-2,3,-2],
'12a_801' : [-1,2,2,2,3,-1,3,3,-2,3,3,3,2],
'12a_802' : [-1,2,-3,4,5,-1,-3,-4,-2,-4,-4,5,-4,3,-2],
'12a_803' : [-1,2,-3,4,-5,6,-1,-3,-5,6,-2,-4,5,-4,3,-2],
'12a_804' : [-1,-2,-2,-1,-1,-2,-3,4,-3,2,-3,4,-3,4],
'12a_805' : [-1,2,-1,2,-1,2,-1,2,2,2,2,2],
'12a_806' : [-1,2,3,-1,3,2,-3,2,2,-1,2,-1,2],
'12a_807' : [-1,2,3,-1,3,2,2,2,-1,-3,2,-1,2],
'12a_808' : [-1,2,-3,4,-1,-3,4,-3,4,-3,-2,3,-2,4],
'12a_809' : [-1,2,-1,2,3,3,3,3,3,2,-1,2,-3],
'12a_810' : [-1,2,-1,-2,-2,-3,4,-3,2,-3,4,-3,-2,4],
'12a_811' : [-1,-2,-2,-3,-1,-3,-1,-1,2,-3,-1,-3,-3],
'12a_812' : [-1,2,3,-2,3,2,-4,1,1,2,-3,2,2,2,3,-4],
'12a_813' : [-1,-1,-1,-2,-2,-3,-1,-3,2,-3,-1,-3,-3],
'12a_814' : [-1,2,3,3,4,2,4,1,4,1,-3,2,4,4],
'12a_815' : [-1,-1,-1,2,2,-1,-1,2,2,2,2,2],
'12a_816' : [-1,2,-1,-2,-2,-2,3,3,-2,-2,3,3,3],
'12a_817' : [-1,-1,-2,-2,-3,-1,-3,-1,2,-3,-1,-3,-3],
'12a_818' : [-1,2,2,2,3,-1,3,-4,3,-2,3,-2,-4,-3],
'12a_819' : [-1,2,-1,2,-1,-1,-1,2,-1,2,2,2],
'12a_820' : [-1,2,-1,-2,3,-2,3,3,3,-2,3,-2,3],
'12a_821' : [-1,2,-1,-2,3,-2,3,4,-3,-2,4,3,-2,3],
'12a_822' : [-1,2,2,2,2,3,3,2,-1,2,2,2,-3],
'12a_823' : [-1,2,-1,-2,-2,-3,4,-3,-3,-3,4,2,-3,-2],
'12a_824' : [-1,-1,-1,2,2,2,2,-1,-1,2,2,2],
'12a_825' : [-1,2,2,2,3,-1,3,-1,-1,2,-3,2,-1],
'12a_826' : [-1,2,-1,-2,3,3,-2,-2,-2,-2,3,3,3],
'12a_827' : [-1,2,3,-4,-4,3,2,-3,-4,1,-4,1,2,-4],
'12a_828' : [-1,2,-3,-1,-3,4,-2,-2,-3,2,-3,-2,-4,-4,-4,-4],
'12a_829' : [-1,-2,-2,-1,-1,-2,-3,4,-3,2,-3,-3,4,-3],
'12a_830' : [-1,2,3,3,2,-1,-1,-1,2,-3,2,2,-1],
'12a_831' : [-1,2,3,3,2,2,-1,-1,-1,2,-3,2,-1],
'12a_832' : [-1,-2,-2,-1,-1,-2,-3,4,-3,-3,2,-3,4,-3],
'12a_833' : [-1,2,2,2,2,3,-1,3,-1,2,-1,2,-3],
'12a_834' : [-1,2,3,-4,3,-4,3,-4,2,-4,1,-3,1,2],
'12a_835' : [-1,-1,-1,2,2,2,2,2,2,-1,-1,2],
'12a_836' : [-1,2,3,-1,3,-1,-1,2,-3,2,2,2,-1],
'12a_837' : [-1,2,3,-1,3,-1,-1,2,2,2,-3,2,-1],
'12a_838' : [-1,-1,-1,2,-1,-1,-1,-1,-1,-1,-1,2],
'12a_839' : [-1,2,-1,-2,-2,-2,-2,3,-2,-2,-2,3,-2],
'12a_840' : [-1,2,3,3,2,2,2,-3,2,-1,2,2,2],
'12a_841' : [-1,2,-3,4,2,2,2,-3,-4,3,2,-3,1,4,1,2],
'12a_842' : [-1,2,3,-4,-4,3,-2,3,-4,1,-4,1,2,-4],
'12a_843' : [-1,2,-3,-1,-3,-3,4,-3,-3,-3,4,-2,3,-2],
'12a_844' : [-1,2,3,-4,-1,2,-4,-3,2,3,3,-4,-4,-4],
'12a_845' : [-1,2,-1,-2,3,-2,-3,4,-3,-4,3,-2,3,3,3,4],
'12a_846' : [-1,2,3,-1,-2,3,2,-4,2,-4,-4,3,-4,-4],
'12a_847' : [-1,2,-3,4,-1,-2,4,3,-2,3,3,4,4,4],
'12a_848' : [-1,2,2,2,2,3,-1,3,2,-1,2,2,-3],
'12a_849' : [-1,2,3,-4,3,3,-4,3,2,-3,-4,1,1,2],
'12a_850' : [-1,2,-1,2,2,-1,-1,-1,-1,-1,-1,2],
'12a_851' : [-1,2,3,-1,3,-1,2,-3,2,2,2,-1,2],
'12a_852' : [-1,2,3,-1,3,-1,2,2,2,-3,2,-1,2],
'12a_853' : [-1,2,-3,-1,2,2,-3,4,4,-3,4,-3,4,-2,-3,-2],
'12a_854' : [-1,2,3,-4,3,-4,3,-4,-2,-4,1,3,1,2],
'12a_855' : [-1,-1,-1,2,3,3,2,-1,2,-3,-1,2,-1],
'12a_856' : [-1,2,-1,-2,-2,3,4,-2,4,3,-2,3,-4,3],
'12a_857' : [-1,2,-1,2,3,3,3,3,2,-1,-1,2,-3],
'12a_858' : [-1,2,3,-4,-4,3,-4,-2,3,1,-4,3,1,2],
'12a_859' : [-1,2,-1,2,2,-1,2,2,2,2,2,2],
'12a_860' : [-1,2,3,-1,3,2,-3,2,2,2,-1,2,2],
'12a_861' : [-1,2,3,-1,3,2,2,2,-3,2,-1,2,2],
'12a_862' : [-1,2,-1,-2,3,2,-3,-4,3,2,-4,-3,2,-3,-3,-3],
'12a_863' : [-1,2,3,-4,3,3,-4,3,-2,3,-4,1,1,2],
'12a_864' : [-1,2,-1,2,-1,-1,2,-1,2,2,2,2],
'12a_865' : [-1,-1,2,-1,2,3,-1,3,2,-3,2,-1,2],
'12a_866' : [-1,2,3,-1,3,2,-1,2,2,-3,2,-1,2],
'12a_867' : [-1,2,3,-4,-1,2,2,3,-4,3,-4,-2,3,-4],
'12a_868' : [-1,-2,3,-2,3,-2,3,4,1,1,2,-3,2,-3,-4,-4],
'12a_869' : [-1,2,2,2,-1,2,-1,2,-1,2,2,2],
'12a_870' : [-1,2,-1,-2,3,-2,3,-2,3,-2,-2,-2,3],
'12a_871' : [-1,2,-1,2,2,2,-1,-3,2,-1,2,3,3],
'12a_872' : [-1,2,-1,-2,3,-2,3,-4,3,2,4,-3,-2,-4,-4,3],
'12a_873' : [-1,2,3,-2,3,2,-4,1,-4,1,2,-4,-3,2,3,-4],
'12a_874' : [-1,2,-1,2,-1,2,2,-3,2,-1,2,3,3],
'12a_875' : [-1,-2,3,4,-2,4,3,-2,1,1,2,2,3,-4,3,-2],
'12a_876' : [-1,-1,-1,-2,-2,-3,-1,-3,-3,-3,2,-3,-1],
'12a_877' : [-1,2,3,3,4,2,-3,1,4,1,2,4,4,4],
'12a_878' : [-1,2,2,-1,-1,-1,-1,2,2,2,2,2],
'12a_879' : [-1,2,-1,-2,-2,-2,3,3,3,3,-2,-2,3],
'12a_880' : [-1,2,-1,-2,3,-4,-5,-2,-5,-4,-3,-3,-2,-4,5],
'12a_881' : [-1,2,3,-1,3,-1,-1,-1,-1,2,-3,2,-1],
'12a_882' : [-1,2,-1,-2,-2,-2,3,4,-3,4,3,-2,-2,3],
'12a_883' : [-1,2,-1,-2,3,-2,3,-4,3,2,-3,-3,-4,3,-2,3],
'12a_884' : [-1,-2,3,-2,3,-2,1,1,2,-3,-4,2,3,-4,2,3],
'12a_885' : [-1,2,3,-4,-1,2,2,2,3,-4,3,-2,3,-4],
'12a_886' : [1,-2,-2,-3,4,2,1,4,4,3,-2,3,-2,4],
'12a_887' : [-1,2,-3,4,-1,-2,3,-2,3,-2,3,-2,3,4],
'12a_888' : [-1,2,3,-1,-2,3,-4,3,-4,3,2,2,3,-4],
'12a_889' : [-1,2,-1,-2,3,-2,3,-2,3,-2,3,3,3],
'12a_890' : [-1,2,-1,-2,3,-2,3,-2,3,-2,3,4,-3,4],
'12a_891' : [-1,2,3,3,2,-1,2,2,2,-3,2,-1,2],
'12a_892' : [-1,2,-1,-2,-3,-3,-4,-4,-3,2,-3,2,-3,4,2,3],
'12a_893' : [-1,2,3,-4,-1,2,2,3,-4,3,-2,3,-4,-4],
'12a_894' : [-1,2,3,-1,3,-1,2,-1,2,-3,2,-1,2],
'12a_895' : [-1,2,2,-1,-1,2,2,3,3,2,-1,2,-3],
'12a_896' : [-1,2,-1,-1,-1,2,-1,-3,2,-1,2,3,3],
'12a_897' : [-1,2,-1,-2,3,4,-2,4,3,-2,3,-4,-2,3],
'12a_898' : [-1,2,2,-1,-1,2,2,-1,-1,2,2,2],
'12a_899' : [-1,2,-1,-2,3,3,-2,-2,3,3,-2,-2,3],
'12a_900' : [-1,2,2,-3,4,2,2,3,1,3,1,2,-3,2,3,4],
'12a_901' : [-1,2,3,-1,3,-2,3,3,3,4,-2,-2,-3,4],
'12a_902' : [-1,-1,-2,1,-2,3,-2,3,2,-4,3,2,-4,-3,5,-4,5],
'12a_903' : [-1,2,3,3,-4,2,1,1,-2,3,-2,3,3,-4,3,2],
'12a_904' : [-1,2,-1,-2,3,-2,3,-2,-2,-2,3,-2,3],
'12a_905' : [-1,2,-1,-2,3,3,2,2,-3,-4,3,-4,-3,-2,-2,3],
'12a_906' : [-1,2,3,-1,-2,3,3,-2,-2,3,-2,4,-3,4],
'12a_907' : [-1,2,3,3,2,-1,2,-3,2,-1,2,2,2],
'12a_908' : [-1,2,-1,-2,3,-4,3,-2,-2,-3,4,-3,4,-2,-2,3],
'12a_909' : [-1,-1,2,2,-1,2,-1,-1,-1,-1,-1,2],
'12a_910' : [-1,2,-1,-2,-2,3,-2,-2,3,3,-2,3,-2],
'12a_911' : [-1,2,2,-1,-1,2,3,-1,3,2,2,2,-3],
'12a_912' : [-1,2,-3,4,-1,-3,4,4,-3,-3,4,-2,3,-2],
'12a_913' : [-1,2,-3,4,-3,2,1,-3,2,-3,4,-3,-3,2],
'12a_914' : [-1,2,3,4,4,3,-2,3,-4,1,1,-2,3,3,-2,-2],
'12a_915' : [-1,-2,-2,-3,4,-3,-3,-2,3,-1,2,4,5,4,-3,4,-5],
'12a_916' : [-1,2,2,-1,-1,2,2,2,2,-1,-1,2],
'12a_917' : [-1,2,-1,2,2,3,-1,3,-1,2,-3,2,-1],
'12a_918' : [-1,2,3,-1,3,-2,3,4,-2,-2,-3,4,4,4],
'12a_919' : [-1,2,3,-1,3,-2,3,4,5,-2,-2,-3,-4,5,4],
'12a_920' : [-1,2,-1,-1,-1,2,2,-1,-1,-1,-1,2],
'12a_921' : [-1,2,2,2,3,-1,3,-1,2,-3,2,-1,2],
'12a_922' : [-1,2,3,3,2,2,-1,-1,2,-3,2,-1,2],
'12a_923' : [-1,2,2,-3,2,-1,2,2,2,2,3,3,2],
'12a_924' : [-1,2,-3,4,2,-3,-4,3,2,-3,1,4,1,2,4,4],
'12a_925' : [-1,2,3,-1,3,2,2,-1,-1,2,-3,2,-1],
'12a_926' : [-1,2,3,-1,-2,3,-2,-2,-2,-2,3,3,-2],
'12a_927' : [-1,2,-1,-2,-3,-2,-3,4,-3,2,4,-3,-2,4,4,3],
'12a_928' : [-1,2,-1,2,-3,4,-3,2,-1,2,-3,2,-4,-3],
'12a_929' : [-1,2,3,3,2,-1,-1,-1,2,-3,-1,2,-1],
'12a_930' : [-1,2,2,-3,2,-1,2,2,3,3,2,2,2],
'12a_931' : [-1,2,-1,-2,3,-4,2,-4,-3,-3,2,-3,4,-3,-3,-3],
'12a_932' : [-1,2,2,-3,4,2,-3,2,-4,-1,2,-3,2,-4],
'12a_933' : [-1,2,3,-4,-1,2,-4,2,3,-4,-2,3,-4,-4],
'12a_934' : [-1,-1,2,-3,-1,2,-1,2,2,3,3,2,2],
'12a_935' : [-1,2,2,-3,4,-3,2,-1,-3,2,-4,-3,2,-4],
'12a_936' : [-1,2,-3,-3,2,1,1,2,-3,-4,3,-4,2,-3],
'12a_937' : [-1,2,-1,-2,-2,3,-2,-2,-2,-2,-2,3,-2],
'12a_938' : [-1,2,-3,-2,3,-2,3,1,3,1,3,3,4,-3,2,4],
'12a_939' : [-1,-1,-2,1,-2,-1,3,-2,1,-2,-3,4,-3,4,5,-4,5],
'12a_940' : [-1,2,-3,4,-1,-3,4,-2,-5,4,4,3,-2,-4,-5],
'12a_941' : [-1,2,3,-1,-2,-2,-2,-2,3,3,-2,3,-2],
'12a_942' : [-1,2,-1,-2,-2,-2,-3,-4,3,-4,-3,2,2,3,3,3],
'12a_943' : [-1,2,-3,-3,2,1,1,2,-3,-4,2,3,-4,-3],
'12a_944' : [-1,-1,-1,2,3,3,2,2,-1,2,-3,2,-1],
'12a_945' : [-1,2,-3,-4,-4,-3,2,-3,4,-3,1,-3,1,2],
'12a_946' : [-1,2,2,3,3,2,-1,2,2,2,-3,2,2],
'12a_947' : [-1,2,-1,-2,3,-4,2,-4,-3,-3,2,-3,-3,4,-3,-3],
'12a_948' : [-1,2,-1,-2,-3,-3,4,-3,2,-3,2,3,4,-2,-3,4],
'12a_949' : [-1,2,3,3,2,2,2,-1,2,-3,-1,2,-1],
'12a_950' : [-1,2,-1,-2,3,-4,2,-4,-3,2,2,-3,2,4,-3,-3],
'12a_951' : [-1,2,3,-4,-1,2,2,3,3,-4,3,-2,3,-4],
'12a_952' : [-1,2,2,3,3,2,-1,2,-3,2,2,2,2],
'12a_953' : [-1,-2,3,3,-2,1,1,2,-3,2,3,3,4,-3,4,3],
'12a_954' : [-1,2,2,2,3,3,2,-1,2,-3,-1,2,-1],
'12a_955' : [-1,-2,-2,3,-2,-2,3,4,1,-3,1,4,3,2,-3,2],
'12a_956' : [-1,2,-1,2,2,2,-3,2,-1,2,2,3,3],
'12a_957' : [-1,2,3,-4,-2,-3,4,-3,2,-3,1,4,1,2,4,4],
'12a_958' : [-1,2,2,-3,-1,2,-1,2,3,3,2,2,2],
'12a_959' : [-1,2,-1,-2,3,-4,2,-4,-3,2,-3,4,2,-3,-3,-3],
'12a_960' : [-1,2,-3,-4,-4,-3,2,1,1,2,-3,4,2,-3],
'12a_961' : [-1,2,3,-4,-1,2,-4,2,3,-2,3,-4,3,-4],
'12a_962' : [-1,2,-3,4,-1,-2,-2,-2,3,-2,-2,3,3,4],
'12a_963' : [-1,2,3,-4,-2,-4,3,2,-4,1,1,2,-3,2,3,-4],
'12a_964' : [-1,2,-3,4,-1,-2,3,-2,3,3,-2,3,3,4],
'12a_965' : [-1,2,3,-1,-2,3,-4,-4,3,-4,2,2,3,-4],
'12a_966' : [-1,2,3,3,2,2,-1,2,-1,-3,-1,2,-1],
'12a_967' : [-1,2,3,-2,3,-4,3,3,2,1,1,2,-3,2,3,-4],
'12a_968' : [-1,2,3,-1,-2,3,2,-4,2,2,3,-4,-4,-4],
'12a_969' : [-1,2,3,-1,-2,3,2,-4,-5,2,2,3,4,-5,-4],
'12a_970' : [-1,2,-1,-2,3,-2,3,3,-2,3,3,3,3],
'12a_971' : [-1,2,-1,-2,3,-2,3,3,-2,3,3,4,-3,4],
'12a_972' : [-1,2,3,3,2,-1,2,-3,-1,-1,-1,2,-1],
'12a_973' : [-1,2,-3,-1,-2,-2,-3,4,-3,2,-3,-2,-4,-4,-4,-4],
'12a_974' : [-1,-1,-2,1,-2,-3,2,-4,-3,-3,-4,5,-4,3,-4,-5,-5],
'12a_975' : [-1,2,-3,4,-5,-1,-2,3,-2,3,3,-4,3,-4,-5],
'12a_976' : [-1,2,-3,-4,-1,-2,-2,3,-4,3,-5,-2,3,4,-5],
'12a_977' : [-1,2,2,-3,2,-1,2,3,3,3,3,2,2],
'12a_978' : [-1,2,3,3,-4,3,3,-2,3,1,-4,3,1,2],
'12a_979' : [-1,2,3,-1,3,-1,2,2,-1,2,-3,2,-1],
'12a_980' : [-1,2,3,3,2,2,-1,2,-3,2,-1,2,2],
'12a_981' : [-1,2,2,-1,-1,2,-1,-1,2,2,2,2],
'12a_982' : [-1,2,-1,-2,-2,3,3,-2,3,3,-2,-2,3],
'12a_983' : [-1,2,3,3,-4,2,1,1,-2,3,3,-2,3,-4,3,2],
'12a_984' : [-1,2,2,2,-1,2,2,-1,2,2,2,2],
'12a_985' : [-1,2,2,2,3,-1,3,2,-3,2,-1,2,2],
'12a_986' : [-1,2,-1,-1,2,-3,-1,2,-1,2,3,3,2],
'12a_987' : [-1,2,2,3,-1,3,2,-1,2,2,-3,2,2],
'12a_988' : [-1,2,-1,-2,3,-2,-2,-2,-2,3,-2,-2,3],
'12a_989' : [-1,2,3,-1,2,-3,4,-3,-2,-4,-2,-2,3,-4,3,-2],
'12a_990' : [-1,2,3,-4,-1,2,-4,2,2,3,-2,-4,3,-4],
'12a_991' : [-1,2,3,-1,2,2,2,3,-4,3,3,-2,3,-4],
'12a_992' : [-1,2,3,-1,-2,3,-2,3,3,4,-2,-2,-3,4],
'12a_993' : [-1,2,-1,-2,3,-2,3,-2,-2,3,-2,3,3],
'12a_994' : [-1,2,3,3,2,-1,2,-3,-1,2,-1,2,2],
'12a_995' : [-1,2,-3,-1,-2,-2,-2,-2,-3,4,-3,2,-3,-2,-4,-4],
'12a_996' : [-1,-1,-2,1,-2,-3,2,4,3,-2,-5,-4,-3,-3,-4,-4,-5],
'12a_997' : [-1,2,3,3,2,-1,2,2,2,-3,-1,2,-1],
'12a_998' : [-1,2,3,3,2,-1,2,-3,2,2,-1,2,-1],
'12a_999' : [-1,2,2,-1,-1,2,2,2,-1,-1,2,2],
'12a_1000' : [-1,2,-1,-2,3,3,-2,-2,3,-2,-2,3,3],
'12a_1001' : [-1,2,-1,-2,-3,-4,-4,-3,2,2,-3,4,-3,2,2,3],
'12a_1002' : [-1,2,2,2,-1,2,-1,-1,2,-1,2,2],
'12a_1003' : [-1,2,2,-1,2,-3,2,2,-1,2,2,3,3],
'12a_1004' : [-1,2,-3,-1,-3,-4,-2,-4,-2,-4,-3,2,-3,-2,4,-3],
'12a_1005' : [-1,2,3,-1,3,2,-1,2,2,-3,-1,2,-1],
'12a_1006' : [-1,2,-1,-2,3,-2,3,3,-2,3,-2,-2,3],
'12a_1007' : [-1,2,3,-1,3,-1,-1,-1,2,-3,2,-1,2],
'12a_1008' : [-1,2,-3,2,-3,2,-3,1,-3,-4,3,1,2,-4],
'12a_1009' : [-1,2,3,-1,3,2,-3,2,-1,2,2,2,2],
'12a_1010' : [-1,2,-1,-2,3,2,-3,2,-3,2,-3,-3,-3,-4,3,-4],
'12a_1011' : [-1,2,-1,-1,-1,2,-1,2,2,2,2,-1],
'12a_1012' : [-1,-1,-1,2,3,-1,3,-1,2,-3,2,-1,2],
'12a_1013' : [-1,2,2,2,-1,2,-1,-1,-1,-1,2,-1],
'12a_1014' : [-1,-1,-1,2,3,-1,3,2,-3,2,-1,2,2],
'12a_1015' : [-1,2,3,-1,-2,-2,3,3,3,3,-2,3,-2],
'12a_1016' : [-1,2,-3,-4,2,3,-4,-3,2,-3,1,-3,1,2],
'12a_1017' : [-1,2,-1,-2,3,-2,3,3,3,3,-2,3,3],
'12a_1018' : [-1,2,-1,-2,3,-2,3,4,4,3,-2,-4,3,3],
'12a_1019' : [-1,2,-3,4,-1,2,-3,-1,2,4,-3,4],
'12a_1020' : [-1,2,-3,4,-1,-3,2,-1,-3,2,4,-3],
'12a_1021' : [1,2,2,-3,4,2,-3,1,2,4,-3,4,-3,-2],
'12a_1022' : [1,2,-3,4,2,-3,4,-3,1,5,4,-2,-3,4,3,-5,4],
'12a_1023' : [-1,-1,-1,2,2,2,2,3,3,2,-1,2,-3],
'12a_1024' : [-1,2,3,-4,-2,-4,-4,3,-4,3,2,1,1,2],
'12a_1025' : [1,1,1,2,-3,2,-3,-1,2,-3,2,1,-3],
'12a_1026' : [-1,2,3,-4,3,-4,-2,3,1,-4,3,1,2,-4],
'12a_1027' : [-1,2,2,2,2,-1,-1,-1,-1,2,2,2],
'12a_1028' : [-1,-1,-1,2,2,2,3,-1,3,2,-3,2,-1],
'12a_1029' : [-1,2,-1,-2,3,3,3,3,-2,-2,-2,-2,3],
'12a_1030' : [-1,2,3,-4,-4,-4,-4,3,2,-3,-4,1,1,2],
'12a_1031' : [-1,-1,-1,2,3,-1,3,-1,-1,2,-3,2,-1],
'12a_1032' : [-1,2,-3,-4,3,-4,-3,2,-3,1,-3,1,-3,2],
'12a_1033' : [-1,2,-1,-2,3,4,-3,4,3,-2,-2,-2,-2,3],
'12a_1034' : [-1,2,-1,-2,3,-2,-3,4,5,5,4,-3,-2,4,-5],
'12a_1035' : [-1,2,-3,4,2,3,1,1,2,2,3,3,3,3,-2,4],
'12a_1036' : [-1,2,-3,2,2,1,1,1,1,1,2,-3,2],
'12a_1037' : [-1,-1,-2,1,-2,-2,-3,2,-4,3,-2,-4,-3,-3,-5,4,-5],
'12a_1038' : [-1,2,-1,-2,-2,-3,4,-3,2,-3,-3,4,-3,-2],
'12a_1039' : [-1,-1,-1,2,-3,4,-1,2,-3,4,4,4],
'12a_1040' : [-1,2,3,-4,5,-1,-2,3,-2,5,5,-4,5],
'12a_1041' : [-1,2,3,3,3,3,2,-1,2,-3,2,-1,2],
'12a_1042' : [-1,2,3,3,2,-1,-1,-1,2,-3,2,-1,2],
'12a_1043' : [-1,2,-3,2,-3,2,1,1,2,-3,-4,3,2,-4],
'12a_1044' : [-1,2,3,-4,3,-4,3,-2,3,1,-4,3,1,2],
'12a_1045' : [-1,2,3,-4,-1,2,-3,2,2,2,2,3,3,-4],
'12a_1046' : [-1,2,-3,4,5,-1,-2,-4,5,4,3,-2,3,3,4],
'12a_1047' : [-1,2,2,2,2,-1,-1,2,2,-1,-1,2],
'12a_1048' : [-1,2,2,-1,-1,2,3,-1,3,2,-3,2,-1],
'12a_1049' : [-1,2,3,-1,3,-2,3,4,-2,-2,-2,-2,-3,4],
'12a_1050' : [-1,2,3,-4,3,-2,3,-2,-4,-3,-1,2,-3,2],
'12a_1051' : [-1,2,-1,-1,-1,-1,-1,2,2,-1,-1,2],
'12a_1052' : [-1,2,-1,-2,-2,3,3,-2,-2,3,-2,3,-2],
'12a_1053' : [-1,-1,2,2,-1,-1,2,-3,2,-1,2,3,3],
'12a_1054' : [-1,2,-1,-2,-3,-3,4,-3,2,-3,2,-3,2,3,4,-3],
'12a_1055' : [1,2,-3,2,-3,-3,-4,5,3,4,2,1,-2,-3,4,-5,-4],
'12a_1056' : [-1,-1,2,2,-3,-1,2,-1,2,2,3,3,2],
'12a_1057' : [-1,-2,3,-2,-3,4,-3,-2,4,5,-1,4,2,-3,4,-5,4],
'12a_1058' : [1,2,-3,-3,-4,5,3,4,2,-3,2,4,1,-5,-4,-2,-3],
'12a_1059' : [-1,2,3,3,3,3,2,2,-1,2,-3,2,2],
'12a_1060' : [-1,-1,2,2,2,-3,-1,2,-1,2,2,3,3],
'12a_1061' : [-1,2,-1,-1,2,-3,2,-1,2,2,3,3,2],
'12a_1062' : [-1,2,3,-4,3,3,-2,3,-4,3,1,3,1,2],
'12a_1063' : [-1,2,-3,4,-1,-3,4,-3,-3,-2,4,4,3,-2],
'12a_1064' : [-1,2,3,-1,3,-1,2,-3,2,-1,2,2,2],
'12a_1065' : [-1,2,-3,2,-3,4,-3,2,-4,-1,2,-3,2,-4],
'12a_1066' : [-1,2,3,-1,-2,-2,3,3,-2,-2,-2,3,-2],
'12a_1067' : [-1,2,-3,-3,4,-3,2,-4,-1,2,-3,2,-4,-3],
'12a_1068' : [-1,2,-1,-2,-3,-4,3,-4,-3,2,2,-3,-3,2,2,3],
'12a_1069' : [-1,-1,-2,1,-2,-2,3,2,-1,-4,3,2,-4,-3,5,-4,5],
'12a_1070' : [-1,2,3,-4,-1,-2,3,-4,3,2,2,2,3,-4],
'12a_1071' : [-1,2,3,3,2,-1,2,-3,-1,2,2,2,-1],
'12a_1072' : [1,1,1,2,2,-3,2,-1,2,-3,2,1,-3],
'12a_1073' : [-1,-2,3,3,-4,-2,1,1,2,-3,2,3,3,4,4,3],
'12a_1074' : [-1,2,3,-4,-1,3,-2,3,-4,3,2,2,2,3],
'12a_1075' : [-1,-2,-2,-3,4,3,-2,-2,3,1,3,1,2,-3,2,4],
'12a_1076' : [-1,2,3,-4,-1,-2,3,-4,-4,3,2,2,3,-4],
'12a_1077' : [-1,2,3,-4,3,-4,-2,3,1,3,-4,1,3,2],
'12a_1078' : [-1,2,3,3,2,-1,-1,2,-1,2,-3,2,-1],
'12a_1079' : [-1,2,3,3,2,-1,2,-1,2,2,-3,2,-1],
'12a_1080' : [-1,2,3,-1,3,-2,3,-4,3,3,2,2,3,-4],
'12a_1081' : [-1,2,3,-4,-1,2,-4,-3,2,3,-4,3,-4,3],
'12a_1082' : [-1,2,3,-1,3,3,2,2,2,-3,2,-4,3,-4],
'12a_1083' : [-1,2,3,-1,3,2,2,2,-1,-3,-1,2,-1],
'12a_1084' : [-1,2,3,-1,-2,-2,-2,3,-2,4,-2,-2,-3,4],
'12a_1085' : [-1,-1,-2,1,-2,3,-2,-2,4,4,3,2,-5,4,-3,-5,-4],
'12a_1086' : [-1,2,-1,-2,3,4,-2,4,3,3,-2,3,-4,3],
'12a_1087' : [-1,2,3,-1,-2,-2,3,3,-2,3,-2,4,-3,4],
'12a_1088' : [-1,2,-1,-2,-3,4,4,-3,2,2,3,4,-2,-2,-3,4],
'12a_1089' : [-1,2,3,-1,3,3,2,-3,2,-4,2,2,3,-4],
'12a_1090' : [1,2,2,3,-4,-3,2,-3,2,-4,5,1,-2,4,-3,4,-5],
'12a_1091' : [-1,2,3,-1,3,2,-1,-1,2,2,-3,2,-1],
'12a_1092' : [-1,2,-1,-2,-3,4,-3,4,-3,2,2,3,-2,4,-2,-3],
'12a_1093' : [-1,2,3,-4,-1,2,-4,-3,2,3,-4,-4,3,-4],
'12a_1094' : [-1,2,3,-1,3,3,-2,3,-2,4,5,-3,-4,5,4],
'12a_1095' : [-1,2,-3,4,-1,4,-3,4,-3,-2,3,-2,4,4],
'12a_1096' : [-1,2,3,-1,3,-4,-2,3,-4,3,2,2,3,-4],
'12a_1097' : [-1,-1,-2,1,-2,3,2,-1,-4,3,-4,-3,-2,-2,-3,-4,-5,4,-5],
'12a_1098' : [-1,2,3,-4,3,-2,3,-4,3,2,1,1,2,-3,2,3],
'12a_1099' : [-1,2,2,2,-1,2,-3,2,-1,2,2,3,3],
'12a_1100' : [-1,-1,2,-1,-1,2,-3,2,-1,2,3,3,2],
'12a_1101' : [-1,2,2,-1,2,2,-3,2,-1,2,3,3,2],
'12a_1102' : [-1,2,-3,4,-3,2,-1,2,-3,2,4,-3],
'12a_1103' : [-1,2,-1,-2,-3,4,-2,-3,2,-3,4,-3,-3,-2,4,3],
'12a_1104' : [-1,2,-3,4,-1,-2,3,3,-2,3,3,-2,3,4],
'12a_1105' : [-1,2,-3,4,2,-1,2,-3,2,-3,4,-3],
'12a_1106' : [1,2,-3,4,-3,2,1,-3,4,-3,5,4,-2,-3,4,3,-5],
'12a_1107' : [-1,2,-1,-2,3,3,3,-2,3,3,-2,3,3],
'12a_1108' : [-1,2,-1,-2,3,4,-3,-2,4,3,3,-2,3,3],
'12a_1109' : [-1,2,2,-1,2,2,3,-1,3,2,-1,2,-3],
'12a_1110' : [-1,2,3,-4,3,-4,-2,3,2,-4,1,1,2,-3,2,3],
'12a_1111' : [-1,2,3,-1,3,-1,2,-1,2,-3,-1,2,-1],
'12a_1112' : [-1,2,-3,4,2,3,1,3,1,3,3,2,-3,2,3,4],
'12a_1113' : [-1,-1,-2,1,3,2,4,-3,-2,-2,-5,-4,-4,-3,-3,-4,-5],
'12a_1114' : [-1,2,2,2,2,2,-1,2,2,-1,2,2],
'12a_1115' : [-1,2,-1,-2,-2,-2,3,-2,-2,3,-2,-2,3],
'12a_1116' : [-1,2,2,3,-1,3,2,2,2,-3,-1,2,2],
'12a_1117' : [-1,2,-3,-4,-1,-2,-4,-2,3,-4,-5,-2,3,4,-5],
'12a_1118' : [-1,2,-3,-1,-3,4,-3,-3,4,-3,-2,3,-2,4],
'12a_1119' : [-1,2,3,-1,3,-1,-1,2,-3,2,-1,2,2],
'12a_1120' : [-1,2,2,2,2,2,-1,2,-1,-1,2,-1],
'12a_1121' : [-1,2,-1,-2,-2,-2,3,-2,3,3,-2,3,3],
'12a_1122' : [1,2,-1,2,-3,4,2,-3,1,-3,2,-3,4,-3],
'12a_1123' : [-1,2,-1,-2,-3,4,-2,4,3,2,-3,2,-3,4,-3,4],
'12a_1124' : [-1,2,3,-4,5,6,-1,-2,3,-4,-5,-2,-3,4,6,5],
'12a_1125' : [-1,2,2,2,2,1,1,2,-3,-4,2,3,-4,-3],
'12a_1126' : [-1,-2,3,4,5,5,4,-5,4,3,-4,-2,-1,2,3],
'12a_1127' : [-1,2,3,-4,5,6,-1,-2,3,-2,-5,6,-4,5],
'12a_1128' : [-1,2,2,2,2,2,2,-1,-1,-1,-1,2],
'12a_1129' : [-1,-1,-1,2,3,-1,3,2,-3,2,2,2,-1],
'12a_1130' : [-1,-1,-1,2,3,-1,3,2,2,2,-3,2,-1],
'12a_1131' : [-1,-1,-1,-1,-1,2,3,-1,3,2,-3,2,-1],
'12a_1132' : [-1,2,-1,-2,3,-2,3,3,3,4,4,3,-2,-4],
'12a_1133' : [-1,2,-3,-4,3,-4,-3,2,-3,1,1,2,2,2],
'12a_1134' : [-1,2,-1,-1,-1,-1,-1,-1,-1,2,2,2],
'12a_1135' : [-1,-1,-1,2,3,3,2,-3,2,2,2,-1,2],
'12a_1136' : [-1,-1,-1,2,3,3,2,2,2,-3,2,-1,2],
'12a_1137' : [-1,2,3,-4,2,-4,-4,3,-4,3,2,-3,1,-3,1,2],
'12a_1138' : [-1,2,3,-4,-4,-4,-4,3,-2,3,-4,1,1,2],
'12a_1139' : [-1,-2,-3,4,5,-3,5,4,-5,4,-3,-2,-1,2,3],
'12a_1140' : [-1,2,3,-4,-4,-4,3,-4,3,-2,3,1,1,2],
'12a_1141' : [-1,2,-3,4,-1,-2,3,-2,-2,-2,-2,3,3,4],
'12a_1142' : [-1,2,3,-4,-2,-3,4,-3,-3,-3,2,-3,1,4,1,2],
'12a_1143' : [-1,2,3,-4,-5,-1,2,4,-5,-4,-3,2,3,3,-4],
'12a_1144' : [-1,2,-1,-2,3,-2,3,4,-3,4,-5,4,-3,4,3,5,-2],
'12a_1145' : [-1,2,3,-1,3,3,-2,-2,-2,-2,-2,3,-2],
'12a_1146' : [-1,2,-3,-4,2,-4,-4,3,-4,3,2,1,1,2],
'12a_1147' : [-1,-1,-1,2,2,2,3,-1,3,2,2,2,-3],
'12a_1148' : [-1,2,-3,4,-1,-3,-3,-3,4,-2,4,4,3,-2],
'12a_1149' : [-1,2,-3,4,5,-1,-3,5,-2,5,-4,5,-4,3,-2],
'12a_1150' : [-1,2,3,-1,3,3,-2,-2,-2,3,-2,4,-3,4],
'12a_1151' : [-1,2,3,-1,3,3,2,-3,2,-4,-5,3,4,-5,-4],
'12a_1152' : [-1,2,-3,4,2,-3,-1,2,-3,2,4,-3],
'12a_1153' : [-1,2,3,-1,-2,3,2,-4,2,2,2,2,3,-4],
'12a_1154' : [1,2,3,-4,-3,2,-3,2,-4,5,4,-3,4,-5,2,1,-2],
'12a_1155' : [-1,-2,3,3,-4,-2,3,1,1,-2,3,4,4,3,2,2],
'12a_1156' : [-1,2,3,-1,2,2,2,3,-4,3,-2,3,3,-4],
'12a_1157' : [-1,2,3,-1,3,3,3,3,3,3,-2,3,-2],
'12a_1158' : [-1,2,2,2,-3,-4,2,3,-4,-3,2,1,1,2],
'12a_1159' : [-1,2,-3,-4,2,3,-4,-3,2,1,1,2,2,2],
'12a_1160' : [-1,-1,-2,1,-2,-2,-3,2,2,4,-3,-2,4,5,-4,-3,5],
'12a_1161' : [-1,-2,3,-4,5,3,5,4,-5,4,3,-2,-1,2,3],
'12a_1162' : [-1,2,3,4,-1,-3,4,-2,-2,-2,-2,-2,3,-2],
'12a_1163' : [-1,-2,3,4,5,5,4,-5,4,-3,4,-2,-1,2,3],
'12a_1164' : [-1,2,3,4,-1,4,4,-3,4,-2,4,4,3,-2],
'12a_1165' : [-1,2,-3,4,5,-1,-3,-3,-3,-4,5,4,-2,3,-2],
'12a_1166' : [-1,2,-3,4,5,6,-1,-3,-5,6,-2,-4,5,-4,3,-2],
'12a_1167' : [-1,2,-3,4,-1,-2,-2,3,-2,3,-2,3,3,4],
'12a_1168' : [-1,2,-1,-1,2,2,2,-1,-1,2,2,2],
'12a_1169' : [-1,2,3,-1,3,-2,3,-2,-2,-2,3,3,-2],
'12a_1170' : [-1,2,-1,-2,3,-2,3,3,-2,-2,-2,3,3],
'12a_1171' : [-1,2,-1,-2,3,-2,3,-4,-3,4,-3,-2,3,4,3,3],
'12a_1172' : [-1,-1,2,-1,-1,2,2,-3,2,-1,2,3,3],
'12a_1173' : [-1,-2,3,-2,-3,-3,4,5,-3,4,-2,-1,2,-3,4,-5,4],
'12a_1174' : [-1,2,-1,-2,3,-2,-2,3,-2,-2,3,3,3],
'12a_1175' : [-1,2,2,3,-1,3,-1,2,-1,2,-3,2,2],
'12a_1176' : [-1,2,-1,-1,2,2,2,2,2,-1,-1,2],
'12a_1177' : [-1,2,-1,-2,-2,3,3,-2,3,-2,3,3,-2],
'12a_1178' : [-1,-1,2,2,2,-3,-1,-1,2,-1,2,3,3],
'12a_1179' : [-1,2,-3,4,-1,4,-3,4,-3,-2,4,4,3,-2],
'12a_1180' : [-1,2,-1,-2,3,-2,-2,3,3,3,-2,-2,3],
'12a_1181' : [-1,2,-1,-2,3,4,-2,-2,-3,4,3,-2,-2,3],
'12a_1182' : [-1,-1,-1,2,2,3,3,2,-1,2,-3,2,2],
'12a_1183' : [-1,2,2,3,-4,-3,2,2,1,1,2,-3,2,-4],
'12a_1184' : [-1,2,-1,2,-3,2,-1,2,2,2,2,3,3],
'12a_1185' : [-1,2,3,-4,-1,3,-4,-2,-2,-3,4,-3,2,3,-2,-4],
'12a_1186' : [-1,2,-1,2,-3,2,-1,2,2,3,3,2,2],
'12a_1187' : [-1,2,3,-1,3,2,2,-1,2,-3,2,-1,2],
'12a_1188' : [1,2,-3,4,-3,4,-2,1,-2,1,-3,-2,4,-3],
'12a_1189' : [-1,-2,3,-2,3,-2,-4,3,1,3,1,2,-3,2,4,4],
'12a_1190' : [-1,2,3,-4,-1,2,2,3,-4,3,-2,3,-4,3],
'12a_1191' : [-1,2,2,-1,2,-1,2,-1,2,2,2,2],
'12a_1192' : [-1,2,-1,2,2,3,-1,3,2,-3,2,-1,2],
'12a_1193' : [-1,2,-1,2,-1,2,-3,2,-1,2,3,3,2],
'12a_1194' : [-1,2,-1,-2,3,3,-2,3,-2,3,-2,3,3],
'12a_1195' : [-1,2,3,-1,-2,-2,3,-2,3,4,-2,-2,-3,4],
'12a_1196' : [-1,2,3,-1,3,2,-1,2,-3,-1,2,-1,2],
'12a_1197' : [-1,-1,-1,2,3,3,2,-1,2,-3,2,-1,2],
'12a_1198' : [-1,2,-1,-2,3,-2,3,4,4,3,-2,3,-4,3],
'12a_1199' : [-1,2,2,-1,2,-1,-1,-1,2,-1,2,2],
'12a_1200' : [-1,2,3,-1,-2,3,3,-2,3,3,-2,3,-2],
'12a_1201' : [-1,2,-1,-1,-1,2,-3,2,-1,2,2,3,3],
'12a_1202' : [-1,2,-1,2,-3,-2,4,-3,-2,5,4,-3,4,-5,6,-5,4,6],
'12a_1203' : [-1,2,2,2,-1,-1,2,-1,-1,2,2,2],
'12a_1204' : [-1,2,-1,-2,3,-2,-2,-2,3,3,-2,3,3],
'12a_1205' : [-1,2,-1,-2,3,-2,3,-4,2,3,-4,-2,3,-2,3,3],
'12a_1206' : [-1,2,2,3,-4,3,2,-4,2,1,1,2,-3,4,2,-3],
'12a_1207' : [-1,2,3,3,2,-1,2,-3,2,2,2,-1,2],
'12a_1208' : [-1,-2,3,-2,3,-2,3,4,1,-3,1,4,3,2,-3,2],
'12a_1209' : [-1,-1,-1,2,-1,2,-1,2,-1,2,2,2],
'12a_1210' : [-1,2,-1,2,2,2,-1,2,-1,2,2,2],
'12a_1211' : [-1,2,-1,2,-1,2,-1,2,2,-1,-1,2],
'12a_1212' : [-1,2,-1,2,-1,2,-1,2,-1,-1,-1,2],
'12a_1213' : [-1,2,3,-1,-2,3,-2,3,-2,3,-2,3,-2],
'12a_1214' : [-1,-1,-1,-1,-1,2,-1,-1,-1,-1,-1,2],
'12a_1215' : [-1,-1,-1,2,-1,2,2,-1,-1,-1,-1,2],
'12a_1216' : [-1,-1,-1,2,-1,2,-1,-3,2,-1,2,3,3],
'12a_1217' : [-1,2,-1,-2,3,-2,3,4,-2,4,3,-2,3,-4],
'12a_1218' : [-1,2,-1,2,2,2,2,-1,-1,-1,-1,2],
'12a_1219' : [-1,-1,-1,2,-1,2,2,-1,2,2,2,2],
'12a_1220' : [-1,2,-1,2,2,2,2,-1,2,2,2,2],
'12a_1221' : [-1,-1,-1,2,-1,2,-1,-1,2,-1,2,2],
'12a_1222' : [-1,2,-1,2,-1,2,-1,-1,2,2,2,-1],
'12a_1223' : [-1,-1,-1,2,-1,-1,-1,2,2,-1,-1,2],
'12a_1224' : [-1,2,3,-1,3,-2,-2,3,-2,-2,-2,3,-2],
'12a_1225' : [-1,2,-1,2,2,-1,-1,2,2,-1,-1,2],
'12a_1226' : [-1,-1,-1,2,2,2,-1,2,2,-1,2,2],
'12a_1227' : [-1,2,-1,2,-1,-1,2,2,2,-1,2,2],
'12a_1228' : [-1,2,3,-1,3,-2,3,-2,3,-2,-2,3,-2],
'12a_1229' : [-1,2,-1,2,2,-1,-1,2,-1,2,2,-1],
'12a_1230' : [-1,2,-1,2,-1,-1,2,2,-1,-1,2,-1],
'12a_1231' : [-1,2,-1,2,-1,2,2,2,-1,-1,2,-1],
'12a_1232' : [-1,2,3,-1,3,-2,3,3,-2,3,-2,3,-2],
'12a_1233' : [-1,-1,-1,2,-1,-1,-1,-1,-1,2,2,2],
'12a_1234' : [-1,2,-1,-2,-2,3,3,3,-2,-2,-2,3,-2],
'12a_1235' : [-1,2,-1,2,2,-1,-1,-1,-1,2,2,2],
'12a_1236' : [-1,2,-1,-2,-2,3,3,3,-2,3,-2,3,3],
'12a_1237' : [-1,2,-1,2,-1,-3,-1,2,-1,2,2,3,3],
'12a_1238' : [-1,2,-1,2,-1,-1,-1,-1,2,2,2,-1],
'12a_1239' : [-1,-1,2,2,-1,2,3,-1,3,2,-3,2,-1],
'12a_1240' : [-1,2,3,-1,3,3,3,-2,3,-2,3,3,-2],
'12a_1241' : [-1,2,-3,-4,3,-4,2,2,-3,2,-3,1,1,2],
'12a_1242' : [-1,2,3,-1,3,3,3,3,-2,3,3,3,-2],
'12a_1243' : [-1,2,-1,-2,-2,3,4,-3,4,-2,-2,-2,3,-2],
'12a_1244' : [-1,2,3,-1,3,3,3,-2,-2,3,-2,3,-2],
'12a_1245' : [-1,2,-1,-2,-2,3,4,-3,4,-2,3,-2,3,3],
'12a_1246' : [-1,-1,-1,2,-1,-1,2,2,2,-1,-1,2],
'12a_1247' : [-1,2,3,-1,3,-2,3,3,3,-2,3,3,-2],
'12a_1248' : [-1,2,-1,2,-1,2,2,-1,2,-1,2,2],
'12a_1249' : [-1,2,-1,2,-1,2,2,-1,2,-1,-1,2],
'12a_1250' : [-1,-1,2,2,-1,2,-1,2,2,-1,-1,2],
'12a_1251' : [-1,2,-3,2,-3,1,4,1,2,-3,2,-3,-4,-4],
'12a_1252' : [-1,2,2,-3,-1,-1,2,-1,2,2,3,3,2],
'12a_1253' : [-1,2,2,-1,-1,2,-1,2,2,-1,2,2],
'12a_1254' : [-1,2,-1,-1,-1,2,2,2,-1,2,2,-1],
'12a_1255' : [-1,2,-1,-1,-1,2,-1,2,-1,-1,2,-1],
'12a_1256' : [-1,2,3,-1,3,3,-2,3,3,-2,-2,3,-2],
'12a_1257' : [-1,2,3,-1,-2,-2,3,-2,-2,3,-2,3,-2],
'12a_1258' : [-1,-1,2,2,-1,2,-1,-1,-1,2,2,2],
'12a_1259' : [-1,2,3,-1,3,3,-2,-2,3,3,-2,3,-2],
'12a_1260' : [-1,2,-1,-1,-1,2,2,-1,-1,2,2,2],
'12a_1261' : [-1,-1,-1,2,2,-3,2,-1,2,2,3,3,2],
'12a_1262' : [-1,2,3,-1,3,-2,-2,3,3,3,-2,3,-2],
'12a_1263' : [-1,2,-1,-2,3,-2,3,4,4,3,-2,3,3,-4],
'12a_1264' : [-1,2,3,-1,3,3,-2,3,-2,-2,3,3,-2],
'12a_1265' : [-1,2,3,4,-1,-3,4,-2,-2,3,3,-2,3,-2],
'12a_1266' : [-1,2,3,-1,3,-4,3,-2,3,3,4,4,3,-2],
'12a_1267' : [-1,2,3,-1,3,-2,-2,3,4,-3,4,-2,3,-2],
'12a_1268' : [-1,-1,2,2,3,-1,3,2,-1,2,-3,2,-1],
'12a_1269' : [-1,2,3,4,-1,-3,4,-2,3,3,-2,-2,3,-2],
'12a_1270' : [-1,2,2,-1,2,-3,-1,2,-1,2,2,3,3],
'12a_1271' : [-1,2,3,-1,3,-4,-2,3,-2,3,4,4,3,-2],
'12a_1272' : [-1,-1,-1,2,-1,2,-3,2,-1,2,2,3,3],
'12a_1273' : [-1,2,-1,-1,-1,-1,-1,2,2,2,2,2],
'12a_1274' : [-1,-1,-1,-1,-1,2,3,3,2,-3,2,-1,2],
'12a_1275' : [-1,2,-3,2,-3,-3,-4,3,-4,-3,2,1,1,2],
'12a_1276' : [-1,2,3,-1,3,3,3,3,-2,-2,-2,3,-2],
'12a_1277' : [-1,2,3,-1,3,3,4,-3,4,-2,-2,-2,3,-2],
'12a_1278' : [-1,2,-3,4,-1,-3,4,-2,4,4,4,4,3,-2],
'12a_1279' : [-1,-2,-3,4,5,5,4,-5,4,-3,4,-2,-1,2,3],
'12a_1280' : [-1,2,3,-1,3,3,-2,3,-2,4,-2,-2,-3,4],
'12a_1281' : [-1,2,3,4,-1,-3,4,-2,4,-2,4,-2,3,-2],
'12a_1282' : [-1,2,3,4,5,-1,-3,-4,5,4,-2,-2,-2,3,-2],
'12a_1283' : [-1,2,2,2,-1,-1,-1,-1,-1,2,2,2],
'12a_1284' : [-1,2,-1,-2,-2,3,3,3,-2,3,3,3,-2],
'12a_1285' : [-1,2,3,-1,3,3,-2,-2,-2,3,3,3,-2],
'12a_1286' : [-1,2,-3,4,-1,4,4,-3,4,-2,4,4,3,-2],
'12a_1287' : [-1,2,-3,4,5,6,-1,-3,-5,6,-2,-4,5,4,3,-2],
'12a_1288' : [-1,-1,-1,2,2,2,-1,-1,-1,2,2,2],
'12n_1' : [-1,2,2,-3,4,-1,-1,-2,-2,-3,2,4],
'12n_2' : [-1,2,-1,2,3,3,-4,2,2,3,-4,-4],
'12n_3' : [-1,2,-1,2,-3,-3,4,-2,-2,-3,4,4],
'12n_4' : [-1,2,3,-4,-1,3,3,-4,2,-3,2,-4],
'12n_5' : [-1,2,-1,2,3,-4,-3,4,-3,-4,-2,-4,-2,-3],
'12n_6' : [-1,2,-1,2,3,4,3,4,3,4,-2,4,-2,-3],
'12n_7' : [-1,2,3,-1,3,2,-3,4,-3,-3,-3,4],
'12n_8' : [-1,2,-1,2,3,-4,2,2,3,3,3,-4],
'12n_9' : [-1,2,-1,2,-3,4,-2,-2,-3,-3,-3,4],
'12n_10' : [-1,2,3,-4,-1,3,-4,2,-3,2,-4,-4],
'12n_11' : [-1,2,3,-1,-2,3,2,4,5,-3,-4,5,-4],
'12n_12' : [-1,2,-1,2,3,4,-5,-3,4,2,-5,2,3],
'12n_13' : [-1,2,-1,2,-3,-4,5,3,-4,-2,5,-2,-3],
'12n_14' : [-1,2,-1,2,-3,-3,2,2,3,-4,3,-4],
'12n_15' : [-1,2,-1,2,3,3,2,2,-3,4,-3,4],
'12n_16' : [-1,2,-1,2,3,3,2,2,3,-4,3,-4],
'12n_17' : [-1,2,-1,2,3,-2,-2,-4,-3,-3,5,-4,5],
'12n_18' : [-1,2,-1,2,3,3,4,-5,-2,-2,-3,4,-5],
'12n_19' : [-1,2,-1,2,-3,-3,-4,5,2,2,3,-4,5],
'12n_20' : [-1,-1,2,-1,2,3,-2,3,-2,-4,3,-4],
'12n_21' : [-1,2,3,-1,3,4,2,4,-3,4,-3,4],
'12n_22' : [-1,2,3,-1,3,-4,2,-4,3,-4,3,-4],
'12n_23' : [-1,2,-1,2,-3,4,-3,4,3,-2,-2,-3,4,4],
'12n_24' : [-1,2,-1,2,3,-2,-2,-4,3,3,3,-4],
'12n_25' : [-1,2,3,-4,-1,-2,3,4,-3,2,-3,4],
'12n_26' : [-1,2,-1,2,-3,4,-3,-3,4,-3,4,2,2,3],
'12n_27' : [-1,2,-1,2,-3,-3,2,2,3,4,-3,-3,4,4],
'12n_28' : [-1,-1,2,2,-1,3,-2,3,-2,-4,3,-4],
'12n_29' : [-1,2,-1,2,-3,4,-3,4,-3,4,2,4,2,3],
'12n_30' : [-1,2,-1,2,-3,-3,2,2,3,4,-3,-3,-3,4],
'12n_31' : [-1,2,-1,-3,2,-3,2,-4,3,3,3,-4],
'12n_32' : [-1,2,3,-1,3,4,2,-3,4,-3,-3,4],
'12n_33' : [-1,2,3,-1,3,-4,2,3,-4,3,3,-4],
'12n_34' : [-1,2,-1,2,3,3,-4,-2,-4,-2,3,3,-4,-3],
'12n_35' : [-1,2,-1,2,3,-4,3,-4,3,-2,-2,3],
'12n_36' : [-1,2,-1,2,-3,4,-3,4,-3,-2,-2,-3],
'12n_37' : [-1,2,-1,2,3,-4,3,-4,3,2,2,3],
'12n_38' : [-1,2,-1,2,3,-4,-4,3,-4,-2,-2,3],
'12n_39' : [-1,2,-1,2,-3,4,4,-3,4,-2,-2,-3],
'12n_40' : [-1,2,-1,2,3,-4,-4,3,-4,2,2,3],
'12n_41' : [-1,2,3,-1,-2,-2,-2,3,2,4,-3,4],
'12n_42' : [-1,2,3,-1,-2,3,2,4,-3,4,4,4],
'12n_43' : [-1,2,-1,2,3,-4,2,2,3,-4,-4,-4],
'12n_44' : [-1,2,-1,2,-3,4,-2,-2,-3,4,4,4],
'12n_45' : [-1,2,3,-1,-2,3,2,4,4,-3,4,-3],
'12n_46' : [-1,2,3,-1,-2,3,2,4,5,-3,-4,5,4],
'12n_47' : [-1,2,-1,2,3,-4,-5,2,2,3,4,-5,-4],
'12n_48' : [-1,2,-1,2,-3,4,5,-2,-2,-3,-4,5,4],
'12n_49' : [-1,2,-3,-4,5,-1,2,-3,-4,2,3,-4,5],
'12n_50' : [-1,2,-1,2,-3,-4,5,-3,2,2,3,4,-3,4,5],
'12n_51' : [-1,2,-1,2,-3,-4,5,-3,-2,-2,3,-4,-3,4,5],
'12n_52' : [-1,2,-1,2,-3,-4,-4,-3,-2,-2,3,-4,3,4],
'12n_53' : [-1,2,-1,2,-3,4,3,3,-2,-2,-3,4,3,3],
'12n_54' : [1,-2,3,3,2,-1,2,2,2,-3,-1,-2,1],
'12n_55' : [-1,2,2,-3,4,-1,-1,-2,-2,-2,-3,4],
'12n_56' : [-1,-2,-2,3,-4,-1,-1,2,2,2,3,-4],
'12n_57' : [-1,2,-1,2,3,-4,-4,3,-2,-2,3,-4,-3,4],
'12n_58' : [-1,2,-1,2,-3,-4,-4,-3,-2,-2,-3,4,-3,-4],
'12n_59' : [-1,-2,-2,-3,4,-1,-1,-2,-2,-2,-3,4],
'12n_60' : [-1,2,2,3,-4,-1,-1,2,2,2,3,-4],
'12n_61' : [-1,2,-1,2,3,-4,-4,3,2,2,3,-4,-3,4],
'12n_62' : [-1,2,-1,2,-3,4,4,-3,-3,-3,4,2,2,3],
'12n_63' : [-1,2,2,3,-4,-1,-1,-2,-2,-2,3,-4],
'12n_64' : [-1,2,-1,2,3,4,4,3,3,3,4,-2,-2,-3],
'12n_65' : [-1,-1,-2,1,3,-2,3,4,-3,-3,-5,4,-5],
'12n_66' : [-1,-2,-2,-3,4,-1,-1,2,2,2,-3,4],
'12n_67' : [-1,-2,-2,3,-4,-1,-1,-2,-2,-2,3,-4],
'12n_68' : [-1,-2,-2,3,-4,-1,-1,-2,-2,3,-2,-4],
'12n_69' : [-1,-2,-2,-3,4,-1,-1,2,2,-3,2,4],
'12n_70' : [-1,2,2,3,-4,-1,-1,-2,-2,3,-2,-4],
'12n_71' : [-1,-2,-2,-3,4,-1,4,-1,-3,2,2,3,4,-2],
'12n_72' : [-1,-2,-2,3,-4,-1,-4,-1,3,-2,-2,-3,-4,2],
'12n_73' : [-1,2,-3,-4,-1,2,-4,-3,2,3,-4,3],
'12n_74' : [-1,-1,-1,-2,-2,1,-2,-3,-2,-2,-1,-3,-3],
'12n_75' : [1,1,1,2,2,-1,2,-3,-2,-2,1,-3,-3],
'12n_76' : [-1,-1,-1,-2,-2,1,-2,-3,2,2,-1,-3,-3],
'12n_77' : [-1,2,-1,-2,-3,-4,-3,-4,-3,-4,-2,-4,-2,3],
'12n_78' : [-1,2,-1,-2,-3,4,3,-4,3,4,-2,4,-2,3],
'12n_79' : [-1,2,-1,-2,-3,4,-3,4,-3,-4,-2,-4,-2,3],
'12n_80' : [1,2,2,-1,-1,-1,2,-3,2,2,1,3,3],
'12n_81' : [-1,2,2,1,1,1,2,-3,2,2,-1,3,3],
'12n_82' : [-1,2,-1,-2,-3,-3,4,-2,4,-2,3,3,4,-3],
'12n_83' : [-1,2,2,3,1,3,4,1,-2,-2,-3,2,4,4],
'12n_84' : [-1,2,-3,-3,2,2,1,1,2,-3,-2,1,-2],
'12n_85' : [-1,-2,-2,-3,-4,3,-1,3,-1,3,2,-4,3,3],
'12n_86' : [-1,2,2,-3,-1,-3,-4,-1,2,2,3,-2,-4,-4],
'12n_87' : [-1,-2,-2,3,-1,3,4,-1,-2,-2,-3,2,4,4],
'12n_88' : [1,1,2,2,3,3,-2,-2,1,1,2,-3,2,2,1],
'12n_89' : [1,-2,3,3,2,2,1,1,1,2,-3,-2,1],
'12n_90' : [1,2,2,1,1,1,-2,-3,2,2,1,-3,-3],
'12n_91' : [-1,-2,-2,-1,-1,-1,2,-3,-2,-2,-1,-3,-3],
'12n_92' : [1,-2,-2,1,1,1,2,-3,-2,-2,1,-3,-3],
'12n_93' : [-1,-2,-2,-3,-1,-3,-4,-1,2,2,3,-2,-4,-4],
'12n_94' : [-1,2,-1,-2,-3,-3,-2,-2,3,4,-3,-3,-3,4],
'12n_95' : [-1,2,-1,-2,-3,-3,4,-2,4,-2,-3,-3,4,3],
'12n_96' : [-1,2,-1,-2,-3,-3,-4,-2,-4,-2,-3,-3,-4,3],
'12n_97' : [-1,2,-3,-1,-3,2,-3,-4,3,3,3,-4],
'12n_98' : [-1,-2,-2,3,-4,-1,-1,-2,3,-2,3,-4],
'12n_99' : [-1,-2,-2,-3,4,-1,-1,2,-3,2,-3,4],
'12n_100' : [-1,-2,-2,-3,-4,-1,-4,-1,-3,-2,-2,3,-4,3,-2,4],
'12n_101' : [-1,-2,-2,3,4,-1,4,-1,3,2,2,-3,4,-3,2,-4],
'12n_102' : [-1,2,2,-1,-1,-2,3,-4,3,-2,-2,-3,-4,-4,-3,4],
'12n_103' : [1,2,2,2,2,3,1,3,1,-2,1,-2,-3],
'12n_104' : [1,1,1,2,2,1,-2,-3,2,2,1,-3,-3],
'12n_105' : [-1,-1,-1,-2,-2,-1,2,-3,-2,-2,-1,-3,-3],
'12n_106' : [1,1,1,-2,-2,1,2,-3,-2,-2,1,-3,-3],
'12n_107' : [1,-2,-2,-3,-3,2,1,-2,-2,-2,-2,-2,-3],
'12n_108' : [-1,2,3,-2,3,2,-4,3,1,3,1,3,2,-4],
'12n_109' : [-1,2,2,3,4,-3,-1,4,3,-1,2,2,3,-2],
'12n_110' : [-1,-2,-2,-3,-4,3,-1,-4,-3,-1,-2,-2,-3,2],
'12n_111' : [-1,-2,-2,3,4,-3,-1,4,3,-1,-2,-2,3,2],
'12n_112' : [-1,-2,-2,3,-4,-1,-1,2,3,-2,-2,-2,3,-4],
'12n_113' : [-1,2,-1,2,-1,-2,1,-2,-2,-2,-2,-2],
'12n_114' : [-1,-1,-1,-2,-2,1,1,-2,-2,-2,-2,-2],
'12n_115' : [1,1,1,2,2,1,2,-3,-2,-2,1,-3,-3],
'12n_116' : [-1,2,-1,-2,-2,-2,-3,-3,-2,-2,3,3,3],
'12n_117' : [-1,2,-1,-2,-2,-2,3,3,-2,-2,-3,-3,-3],
'12n_118' : [-1,-2,-2,3,4,-3,-1,4,3,-1,2,2,3,2],
'12n_119' : [-1,-1,2,-1,-1,2,-1,3,-2,-4,3,-4],
'12n_120' : [1,1,-2,-2,-3,1,2,2,3,3,2,1,-2],
'12n_121' : [-1,-2,1,1,-2,-3,2,-1,-2,-2,-3,-3,2],
'12n_122' : [-1,2,-1,2,-3,-3,-2,-2,3,4,3,3,4,4],
'12n_123' : [-1,2,-1,2,-3,-3,-2,-2,3,-4,-3,-3,-4,-4],
'12n_124' : [-1,2,-1,2,-3,-3,-2,-2,3,4,4,-3,-3,4],
'12n_125' : [-1,2,-3,-1,2,-3,2,-4,-3,-3,-3,-4],
'12n_126' : [-1,2,-3,-1,2,-3,2,4,3,3,3,4],
'12n_127' : [-1,2,-1,2,-3,-3,4,-2,4,-2,3,3,4,3],
'12n_128' : [-1,2,-1,2,-3,-3,-4,-2,-4,-2,-3,-3,-4,3],
'12n_129' : [-1,2,-1,2,2,-1,3,-2,-2,-4,3,-4],
'12n_130' : [-1,-2,-2,3,-1,3,-1,3,-4,2,3,-2,3,-4],
'12n_131' : [-1,2,2,3,-4,-1,-1,2,2,-3,-3,-2,-4,-4],
'12n_132' : [-1,-2,-2,-3,4,-1,-1,-2,-2,3,3,2,4,4],
'12n_133' : [-1,2,2,1,1,2,2,3,3,-2,1,2,2,2,-3],
'12n_134' : [-1,-1,-2,-2,-3,1,-3,1,2,-3,-1,-3,-3],
'12n_135' : [1,1,2,2,1,1,-2,-3,2,2,1,-3,-3],
'12n_136' : [-1,-1,-2,-2,-1,-1,2,-3,-2,-2,-1,-3,-3],
'12n_137' : [1,1,-2,-2,1,1,2,-3,-2,-2,1,-3,-3],
'12n_138' : [-1,-2,-2,3,-4,-1,-1,2,2,-3,-3,-2,-4,-4],
'12n_139' : [-1,-2,-2,3,4,-1,-1,2,-3,2,-3,4,-3,-3],
'12n_140' : [-1,-2,-2,-3,-4,-1,-1,-2,3,-2,3,-4,3,3],
'12n_141' : [-1,2,2,3,4,-1,-1,2,-3,2,-3,4,-3,-3],
'12n_142' : [-1,2,3,-4,-1,3,-4,-2,-2,-2,3,2],
'12n_143' : [-1,2,3,-4,-1,-2,-4,-2,-2,3,2,-4],
'12n_144' : [-1,2,3,-1,-2,-2,-2,3,-2,-4,3,-4],
'12n_145' : [-1,-2,-3,2,-3,-2,-4,1,1,-2,3,-2,3,-4],
'12n_146' : [-1,2,-1,2,-3,-3,-4,3,-2,-3,-3,-2,-4,3],
'12n_147' : [1,-2,3,1,3,-2,-2,1,1,-2,-3,-2,1],
'12n_148' : [-1,-2,-2,-3,2,-1,-2,-2,-2,-2,-3,-3,2],
'12n_149' : [-1,2,-1,-2,-3,-3,-4,3,-2,-3,-3,-2,-4,3],
'12n_150' : [-1,-2,-2,-1,-1,-2,3,-4,-2,3,-4,3],
'12n_151' : [-1,-2,-2,-1,-1,2,-3,4,2,-3,4,-3],
'12n_152' : [-1,2,2,-1,-1,-2,3,-4,-2,3,-4,3],
'12n_153' : [1,2,1,2,-3,2,2,3,1,3,2,1,2],
'12n_154' : [1,-2,-1,2,-3,2,2,3,-1,3,2,-1,-2],
'12n_155' : [-1,-2,-2,1,-2,-3,2,2,-3,-3,-2,-2,-1],
'12n_156' : [-1,2,3,-4,-1,2,3,2,3,-4,3,2],
'12n_157' : [-1,2,-3,-4,-1,-2,-2,3,-4,-2,-3,2],
'12n_158' : [-1,2,2,-1,-1,-2,3,-2,3,4,3,-2,3,-4],
'12n_159' : [1,2,-1,2,-3,2,2,3,-1,3,2,1,-2],
'12n_160' : [-1,2,-3,-4,-1,3,-4,-3,4,2,4,-3],
'12n_161' : [-1,2,2,-1,-1,-2,3,-4,-2,3,-2,-4],
'12n_162' : [-1,-2,-2,-1,-1,2,-3,4,2,-3,2,4],
'12n_163' : [-1,-2,-2,-1,-1,-2,3,-4,-2,-4,3,-4],
'12n_164' : [-1,-2,-2,-1,-1,2,-3,4,2,4,-3,4],
'12n_165' : [-1,2,2,-1,-1,-2,3,-4,-2,-4,3,-4],
'12n_166' : [-1,-2,-2,-2,-2,1,-2,-3,-2,-2,-1,-3,-3],
'12n_167' : [1,2,2,2,2,-1,2,-3,-2,-2,1,-3,-3],
'12n_168' : [-1,-2,-2,-2,-2,1,-2,-3,2,2,-1,-3,-3],
'12n_169' : [-1,-2,-2,-1,-1,-2,3,-2,-3,-3,-4,3,-4,-3],
'12n_170' : [-1,-2,-2,-1,-1,2,-3,2,3,3,4,-3,4,3],
'12n_171' : [-1,2,2,-1,-1,-2,3,-2,-3,-3,-4,3,-4,-3],
'12n_172' : [-1,-2,-2,-1,-1,-2,3,-4,-2,3,-2,-4],
'12n_173' : [-1,2,2,-1,-1,-2,-3,4,-3,2,-3,4,-3,4],
'12n_174' : [-1,2,2,-1,-1,-2,3,-4,2,3,2,-4,3,-4],
'12n_175' : [-1,-2,-2,-1,-1,2,-3,4,-2,-3,-2,4,-3,4],
'12n_176' : [-1,-2,-2,-1,-1,2,-3,2,-3,-4,3,-2,3,-4],
'12n_177' : [-1,2,-1,-2,-3,-4,-4,-3,-2,-2,-3,-3,4,-3],
'12n_178' : [-1,2,2,1,1,2,-3,4,-3,-2,-3,-2,4,-3],
'12n_179' : [-1,2,-1,-2,3,-4,-3,4,-3,4,-2,-2,-3,-3,4,-3],
'12n_180' : [-1,2,-3,-1,-3,2,2,-1,2,-3,-2,1,2],
'12n_181' : [1,-2,3,1,3,-2,1,1,-2,-2,-3,-2,1],
'12n_182' : [-1,2,3,-4,-1,2,-4,3,2,3,-4,3],
'12n_183' : [-1,2,-3,-4,-1,-2,-4,-2,3,-4,-2,-3],
'12n_184' : [-1,2,2,-3,-1,-3,4,-1,2,-3,2,4,4,3],
'12n_185' : [1,1,-2,-3,1,2,2,3,1,3,1,-2,1],
'12n_186' : [1,2,2,2,2,1,-2,-3,2,2,1,-3,-3],
'12n_187' : [-1,-2,-2,-2,-2,-1,2,-3,-2,-2,-1,-3,-3],
'12n_188' : [1,2,2,3,1,3,1,1,-2,1,-2,-2,-3],
'12n_189' : [1,2,2,3,1,3,1,-2,1,-2,-2,-2,-3],
'12n_190' : [-1,2,1,-2,1,1,1,2,-1,2,2,2],
'12n_191' : [-1,-1,-1,-2,-2,-2,-2,1,1,-2,-2,-2],
'12n_192' : [1,2,2,2,2,1,2,-3,-2,-2,1,-3,-3],
'12n_193' : [1,1,1,2,3,-1,3,-1,2,-3,2,1,-2],
'12n_194' : [1,1,1,-2,3,1,3,1,2,-3,2,-1,2],
'12n_195' : [-1,-2,-2,-1,-1,2,3,4,2,2,2,-3,4,3],
'12n_196' : [-1,-2,-2,-1,-1,2,3,4,-2,-2,-2,-3,4,3],
'12n_197' : [-1,2,2,3,4,-3,1,4,1,-2,3,-2,-2,3],
'12n_198' : [-1,2,-3,-4,-1,3,3,3,-4,2,-3,2],
'12n_199' : [-1,2,-1,-2,-3,-3,-2,-2,-2,-2,3,3,3],
'12n_200' : [-1,2,3,4,-2,-3,4,3,2,-3,1,-4,1,2],
'12n_201' : [-1,2,3,-1,-2,-3,-3,4,-2,-2,-3,-3,-3,4],
'12n_202' : [-1,2,2,3,-1,3,-1,2,-3,4,2,-3,4,3],
'12n_203' : [-1,-2,-2,-3,-1,-3,-1,-2,3,-4,-2,3,-4,-3],
'12n_204' : [-1,-2,-2,3,-4,3,-1,4,-1,2,-3,-4,-4,-3],
'12n_205' : [-1,2,2,-1,-1,-2,-3,4,-3,2,-3,-3,4,-3],
'12n_206' : [-1,2,2,3,-1,3,-4,-1,2,3,2,-4,3,-2],
'12n_207' : [-1,-2,-2,-3,-1,-3,4,-1,-2,-3,-2,4,-3,2],
'12n_208' : [1,2,3,3,2,-1,-1,-1,2,-3,2,2,1],
'12n_209' : [-1,2,3,3,2,1,1,1,2,-3,2,2,-1],
'12n_210' : [-1,-2,-2,3,-1,3,4,-1,2,-3,2,4,3,2],
'12n_211' : [-1,2,-3,-1,2,-3,-4,3,-2,-2,-2,3,2,4],
'12n_212' : [1,2,3,3,2,2,-1,-1,-1,2,-3,2,1],
'12n_213' : [-1,2,3,3,2,2,1,1,1,2,-3,2,-1],
'12n_214' : [-1,-2,-2,-1,-1,2,3,4,2,-3,2,4,2,3],
'12n_215' : [-1,2,2,3,1,3,1,-2,3,4,-3,4,-2,3],
'12n_216' : [-1,2,2,-1,-1,-2,3,4,2,2,2,-3,4,3],
'12n_217' : [-1,-2,-2,-1,-1,2,-3,-4,-2,-2,-2,3,-4,-3],
'12n_218' : [-1,2,-3,-4,-1,-1,2,3,3,3,-4,-3],
'12n_219' : [-1,2,2,3,-1,-1,-2,3,3,-2,4,-3,2,4],
'12n_220' : [-1,2,3,-1,3,3,4,2,3,3,3,4],
'12n_221' : [-1,2,-3,-1,-3,-3,-4,2,3,3,3,-4],
'12n_222' : [-1,-2,-2,-3,-1,-3,-4,-1,-2,3,-2,-4,3,2],
'12n_223' : [-1,2,2,-3,-1,-1,2,-3,-3,2,-4,3,-2,-4],
'12n_224' : [-1,2,-3,-1,-3,-3,4,2,3,3,3,4],
'12n_225' : [-1,2,2,-3,-1,-1,2,3,-4,-2,-2,3,-2,-4],
'12n_226' : [-1,2,2,-1,-1,-2,-3,4,-3,-3,2,-3,4,-3],
'12n_227' : [-1,2,2,-1,-1,-2,3,-4,3,2,3,2,-4,3],
'12n_228' : [-1,-2,-2,-1,-1,2,-3,4,-3,-2,-3,-2,4,-3],
'12n_229' : [-1,2,-3,-1,-3,-3,-4,2,-3,-3,-3,-4],
'12n_230' : [-1,2,3,-1,3,-4,5,2,-3,4,-3,4,5],
'12n_231' : [-1,2,-3,-1,-3,-4,2,-4,3,-4,3,-4],
'12n_232' : [-1,2,-1,2,-3,-4,3,-4,3,-4,-2,-4,-2,3],
'12n_233' : [-1,2,1,-2,1,2,-1,2,2,2,2,2],
'12n_234' : [-1,2,2,-1,-1,-2,-2,-2,-2,-2,-2,-2],
'12n_235' : [-1,-2,-2,-1,-1,2,2,2,2,2,2,2],
'12n_236' : [1,2,3,-1,3,-1,2,-3,2,2,2,1,-2],
'12n_237' : [-1,2,2,-3,-3,-2,-2,-2,-2,-2,-1,2,-3],
'12n_238' : [1,-2,-2,-3,-3,2,2,2,2,2,1,-2,-3],
'12n_239' : [1,2,3,-1,3,-1,2,2,2,-3,2,1,-2],
'12n_240' : [-1,-1,-1,2,2,-3,-3,-2,-2,-2,-1,2,-3],
'12n_241' : [1,1,1,-2,-2,-3,-3,2,2,2,1,-2,-3],
'12n_242' : [-1,-2,-2,-1,-1,-2,-2,-2,-2,-2,-2,-2],
'12n_243' : [-1,-2,-2,-3,-3,-2,-2,-2,-2,-2,-1,2,-3],
'12n_244' : [-1,-1,-1,-2,-2,-3,-3,-2,-2,-2,-1,2,-3],
'12n_245' : [-1,2,3,4,2,-3,4,3,2,3,1,3,1,2],
'12n_246' : [-1,2,-3,4,-2,-3,4,3,-2,-3,1,-3,1,2],
'12n_247' : [-1,2,2,3,-1,-1,-2,-3,-4,-3,-4,-3,-2,3,-2,4],
'12n_248' : [-1,2,3,4,-3,4,3,-4,-2,-4,1,3,1,2],
'12n_249' : [-1,2,2,-1,-1,-2,-2,-2,-3,-4,2,3,-4,-3],
'12n_250' : [-1,-2,-2,-1,-1,2,2,2,3,4,-2,-3,4,3],
'12n_251' : [-1,-2,-2,-1,-1,-2,-2,-2,-3,-4,2,3,-4,-3],
'12n_252' : [-1,2,3,4,-1,-3,-3,-3,4,2,-3,2,3,3],
'12n_253' : [-1,2,2,2,-3,-1,2,-3,-2,-2,-3,-3,-2],
'12n_254' : [-1,-2,-2,-3,-1,-1,2,2,-3,-3,-2,-1,2],
'12n_255' : [-1,2,2,3,-1,-1,-2,-2,-3,-3,-4,2,3,-4],
'12n_256' : [-1,-2,-2,-3,-1,-1,2,2,3,3,4,-2,-3,4],
'12n_257' : [1,2,2,-3,1,1,-2,-2,-3,-3,2,1,-2],
'12n_258' : [-1,-2,-2,3,-4,-1,-1,-2,3,2,4,3,3,4],
'12n_259' : [1,2,2,2,3,3,-2,1,2,2,2,-3,-1,2,1],
'12n_260' : [-1,2,3,4,-2,-2,-2,3,4,3,2,-3,1,-4,1,2],
'12n_261' : [-1,2,3,-1,3,3,-4,2,3,3,3,-4],
'12n_262' : [-1,2,-1,-2,-3,-3,2,-3,-4,2,3,3,3,-4],
'12n_263' : [-1,2,2,3,-4,-1,-1,-2,3,-2,-4,3,-4,-3],
'12n_264' : [-1,-2,-2,-3,4,-1,-1,2,-3,2,4,-3,4,3],
'12n_265' : [-1,2,-3,-4,-1,3,3,3,-4,-2,3,-2,3,3],
'12n_266' : [-1,2,2,3,-1,3,-1,-2,3,-4,-2,3,-4,-3],
'12n_267' : [-1,-2,-2,-3,-1,-3,-1,2,-3,4,2,-3,4,3],
'12n_268' : [-1,2,-1,2,-3,-4,5,-3,-2,-2,3,4,-3,4,5],
'12n_269' : [-1,2,-1,2,3,4,4,3,-2,-2,-3,4,-3,-4],
'12n_270' : [-1,2,-1,2,3,-4,-3,-3,-2,-2,3,-4,-3,-3],
'12n_271' : [-1,2,3,-1,-2,-2,3,-2,3,-4,3,-4],
'12n_272' : [-1,2,3,-1,-2,-2,3,-4,-2,3,-4,-4],
'12n_273' : [-1,2,-1,2,3,-4,-2,-2,-2,-2,3,-4],
'12n_274' : [-1,2,-3,2,1,1,2,3,-4,3,-2,-4,-3,4],
'12n_275' : [-1,2,-3,4,-1,2,4,3,-2,3,4,-3],
'12n_276' : [-1,-2,-2,1,-2,-2,-3,-1,-3,-2,1,-2,-3],
'12n_277' : [1,2,-3,-3,-2,1,-2,-3,-1,2,2,2,1],
'12n_278' : [-1,2,-1,-2,3,-4,-2,-4,3,3,-2,4,3,4],
'12n_279' : [-1,2,-1,2,-3,-3,4,2,-3,2,-3,2,4,3],
'12n_280' : [-1,2,3,4,-1,2,-3,2,-3,4,3,2],
'12n_281' : [-1,2,-1,2,-3,-4,2,-4,3,3,2,-4,3,-4],
'12n_282' : [-1,2,-3,-4,-1,-2,3,-2,3,-4,-3,2],
'12n_283' : [-1,2,3,-4,-1,2,3,2,-4,3,2,-4],
'12n_284' : [-1,2,-1,2,3,-2,3,-4,3,-2,3,-4],
'12n_285' : [-1,2,3,-1,-2,3,4,3,-2,3,2,4],
'12n_286' : [-1,2,-3,-1,2,-3,4,3,-2,3,2,4],
'12n_287' : [-1,2,-3,-1,2,-3,-4,-3,2,-3,2,-4],
'12n_288' : [-1,2,-1,-2,-3,-3,4,-2,4,-2,3,3,-4,3],
'12n_289' : [-1,2,-1,-2,-3,-3,-4,-2,-4,-2,-3,-3,4,-3],
'12n_290' : [1,-2,-2,1,1,1,2,-3,2,2,1,3,3],
'12n_291' : [-1,-2,-2,-1,-1,-1,2,-3,2,2,-1,3,3],
'12n_292' : [1,2,2,1,1,1,2,-3,2,2,1,3,3],
'12n_293' : [1,-2,-3,-1,-3,-2,1,-2,-3,-1,-2,1,-2],
'12n_294' : [-1,2,-1,2,3,-4,2,2,2,2,3,-4],
'12n_295' : [-1,2,-3,4,-1,-3,4,-2,-2,-2,-3,2],
'12n_296' : [-1,2,3,-4,-1,3,-4,2,2,2,3,2],
'12n_297' : [-1,2,-1,2,-3,4,-5,2,3,-2,3,2,4,3,-5],
'12n_298' : [-1,2,3,-4,-1,-2,3,-2,3,-4,3,2],
'12n_299' : [-1,2,-1,2,3,4,2,4,3,-2,3,-4,2,3],
'12n_300' : [-1,2,-3,4,-1,-2,4,-2,-2,-3,2,4],
'12n_301' : [-1,2,3,-4,-1,2,-4,2,2,3,2,-4],
'12n_302' : [-1,2,-1,2,-3,4,2,4,3,-2,3,-4,2,-3],
'12n_303' : [-1,2,-1,-2,3,3,-2,-2,-3,-3,-3,-3,-3],
'12n_304' : [-1,-1,-1,-2,-2,-1,2,-3,2,2,-1,3,3],
'12n_305' : [-1,2,-1,-2,-3,-3,-2,-2,-3,-3,-3,-3,-3],
'12n_306' : [-1,2,-1,-2,3,3,-2,-2,-3,-3,-3,-4,3,-4],
'12n_307' : [-1,2,2,-3,-4,3,1,-4,-3,1,-2,-2,-3,2],
'12n_308' : [-1,2,-1,-2,-3,-3,-2,-2,-3,-3,-3,-4,3,-4],
'12n_309' : [-1,2,-1,-2,-3,-3,-2,-2,3,3,3,3,3],
'12n_310' : [-1,2,-1,-2,-3,-3,-2,-2,3,3,3,4,-3,4],
'12n_311' : [-1,2,-1,-3,-2,4,3,-2,3,-5,4,-3,-5],
'12n_312' : [-1,2,-3,4,-1,-3,4,2,-3,2,3,3],
'12n_313' : [-1,-2,3,3,-2,1,1,2,-3,-4,2,3,-4,-3],
'12n_314' : [-1,2,-1,2,3,-2,-1,-4,3,2,-4,-3],
'12n_315' : [1,-2,3,3,2,-1,2,-3,-1,-1,-1,-2,1],
'12n_316' : [-1,2,-1,-2,3,-2,-2,3,-2,-2,-3,-3,-3],
'12n_317' : [1,-2,-2,-2,3,3,-2,1,-2,-3,1,-2,1],
'12n_318' : [-1,-2,-3,1,-3,2,2,-1,2,-3,-2,-1,2],
'12n_319' : [1,-2,3,3,-2,1,-2,-3,1,1,1,-2,1],
'12n_320' : [1,-2,-3,1,-3,2,2,-1,2,-3,-2,1,-2],
'12n_321' : [1,-2,-3,-1,-3,-2,1,-2,-3,-1,2,-1,-2],
'12n_322' : [-1,2,-3,-1,-3,4,2,3,-2,-4,3,4],
'12n_323' : [1,-2,-3,1,-3,2,-1,2,-3,1,2,-1,2],
'12n_324' : [-1,-2,3,3,-2,1,1,-2,3,4,-2,-3,4,3],
'12n_325' : [-1,2,-3,1,-3,2,-1,2,-3,-1,2,-1,2],
'12n_326' : [1,2,2,3,1,3,1,-2,-2,1,-2,-3,1],
'12n_327' : [1,1,1,2,2,3,1,3,-2,1,-2,-2,-3],
'12n_328' : [-1,-2,-3,-1,-3,-2,-2,1,-2,-3,-2,-1,-2],
'12n_329' : [-1,-2,-2,-3,-1,-1,2,-1,-2,-2,-3,-3,2],
'12n_330' : [-1,2,3,3,-2,1,-2,-2,-2,-3,-1,2,-1],
'12n_331' : [-1,-2,-2,-1,-1,-2,-3,2,-3,4,3,-2,3,4],
'12n_332' : [-1,2,-1,-2,3,-4,-3,-3,-2,-2,3,-4,-3,-3],
'12n_333' : [-1,2,-1,-2,3,4,4,3,-2,-2,-3,4,-3,-4],
'12n_334' : [-1,2,2,1,1,2,-3,2,-3,-4,3,-2,3,-4],
'12n_335' : [1,2,-3,-3,-2,1,-2,-2,-2,-3,-1,2,1],
'12n_336' : [-1,2,-3,4,-1,-3,-1,2,3,-2,-4,-2,3,-4],
'12n_337' : [-1,-2,3,3,-2,3,-4,1,1,2,-3,2,3,-4],
'12n_338' : [-1,2,-1,-2,-3,-3,-3,-3,-2,-2,-3,-3,-3],
'12n_339' : [-1,-2,-2,-2,-2,-1,2,-3,2,2,-1,3,3],
'12n_340' : [-1,2,-1,-2,3,3,3,3,-2,-2,-3,-3,-3],
'12n_341' : [-1,2,-1,-2,-3,-4,3,-4,-3,-2,-2,-3,-3,-3],
'12n_342' : [-1,2,2,1,1,2,-3,-4,-2,-2,-2,3,-4,-3],
'12n_343' : [-1,2,-1,-2,3,4,-3,4,3,-2,-2,-3,-3,-3],
'12n_344' : [-1,-1,-1,-2,-2,-2,-2,-1,-1,2,2,2],
'12n_345' : [-1,-1,-1,2,2,2,2,-1,-1,-2,-2,-2],
'12n_346' : [1,2,2,2,2,1,-2,-3,-2,-2,1,-3,-3],
'12n_347' : [-1,2,-1,-2,-3,-3,-3,-3,-2,-2,3,3,3],
'12n_348' : [-1,2,3,-1,-2,3,2,4,2,2,-3,4],
'12n_349' : [-1,2,-3,-1,2,-3,-2,-4,-2,-2,3,-4],
'12n_350' : [-1,2,-3,-1,2,-3,-2,4,-2,-2,-3,4],
'12n_351' : [-1,2,-3,-1,2,-3,2,-4,2,2,3,-4],
'12n_352' : [-1,2,3,-4,-1,3,-4,-2,3,-2,3,3],
'12n_353' : [-1,2,-3,4,-1,-3,4,-2,3,-2,-3,-3],
'12n_354' : [-1,2,3,-4,-1,3,-4,2,-3,2,-3,-3],
'12n_355' : [-1,-2,3,-4,-2,-3,-1,2,-3,2,-4,3],
'12n_356' : [-1,2,3,4,-1,-2,-3,4,-3,2,-3,4],
'12n_357' : [-1,2,-3,2,-3,2,-4,1,1,2,-3,2,3,-4],
'12n_358' : [-1,-2,1,-2,3,-2,-1,-4,3,2,-4,-3],
'12n_359' : [-1,2,-3,-4,5,-1,-2,3,4,-2,3,3,-4,-4,5],
'12n_360' : [-1,2,-3,4,-1,2,3,-4,3,-2,3,4],
'12n_361' : [-1,2,3,2,3,2,-4,1,1,2,-3,2,3,-4],
'12n_362' : [-1,-1,-2,-1,3,2,-1,2,2,-4,3,-4],
'12n_363' : [-1,2,-3,4,-1,2,-3,-2,4,-2,-3,-3],
'12n_364' : [-1,2,3,-1,-2,3,-4,3,-2,3,-2,3,3,4],
'12n_365' : [-1,2,3,-1,-2,3,-4,-3,2,-3,2,-3,-3,4],
'12n_366' : [-1,2,-3,-3,-2,-2,-3,-1,-3,2,-3,-2,-2],
'12n_367' : [-1,2,3,-2,3,2,-4,1,1,-2,-2,3,-2,-4],
'12n_368' : [1,1,1,2,2,3,1,3,1,-2,1,-2,-3],
'12n_369' : [1,2,2,3,1,3,1,-2,-2,-2,1,-2,-3],
'12n_370' : [1,-2,-2,1,2,-3,2,2,1,3,3,-2,-2],
'12n_371' : [-1,2,3,-1,3,-2,-2,1,-2,-3,-2,1,-2],
'12n_372' : [1,1,1,2,2,3,-1,3,-1,2,-1,2,-3],
'12n_373' : [1,2,2,3,-1,3,2,2,1,1,-2,-3,1],
'12n_374' : [-1,2,-1,-2,-3,-3,-2,-2,-3,-3,-2,-2,-3],
'12n_375' : [-1,2,-1,-2,-3,2,-3,-2,-2,-2,-3,2,-3],
'12n_376' : [-1,2,-1,-2,-3,-3,2,2,-3,-3,2,2,-3],
'12n_377' : [-1,2,-3,1,-3,2,2,-1,2,-3,2,-1,2],
'12n_378' : [-1,2,2,3,-1,3,-1,-2,-2,-2,-1,2,-3],
'12n_379' : [1,-2,1,2,-3,2,2,3,-1,3,2,-1,2],
'12n_380' : [-1,-1,-2,-2,-3,-1,2,2,3,3,2,-1,2],
'12n_381' : [-1,2,-3,-4,-1,-2,-4,3,-2,3,-4,-3],
'12n_382' : [-1,2,2,-3,1,-3,1,-2,3,4,-2,-3,4,3],
'12n_383' : [-1,2,-3,-4,-1,-1,-2,3,-2,-4,-3,4],
'12n_384' : [-1,2,2,3,1,3,1,2,-3,-4,2,3,-4,3],
'12n_385' : [-1,2,-3,-1,-3,2,2,1,1,-2,-3,2,-1],
'12n_386' : [1,2,2,-3,1,1,2,2,3,3,2,1,2],
'12n_387' : [-1,-2,3,-4,-2,3,-4,-1,-1,-2,-2,-2],
'12n_388' : [-1,-2,3,-4,-2,3,-4,-1,-1,2,2,2],
'12n_389' : [-1,2,-3,4,2,-3,4,-1,-1,-2,-2,-2],
'12n_390' : [-1,2,3,-1,3,2,2,-1,2,-3,-2,1,-2],
'12n_391' : [-1,2,3,3,-4,2,3,-1,-4,-1,2,3,3,4],
'12n_392' : [-1,2,3,-1,3,-4,-2,3,-4,3,2,2,-3,4],
'12n_393' : [-1,-2,-3,-3,-4,-2,3,1,1,-2,3,-4,3,-2],
'12n_394' : [-1,2,3,-4,-1,3,3,2,-3,2,-3,-4,3,-2],
'12n_395' : [-1,2,-3,4,2,-3,1,1,2,2,3,3,-2,4],
'12n_396' : [-1,2,-3,4,-1,-3,-3,-2,3,-2,3,4,-3,2],
'12n_397' : [-1,2,3,-4,-1,-2,-4,3,-2,3,3,-4],
'12n_398' : [-1,2,3,-4,-1,-2,-4,3,-2,-3,-3,-4],
'12n_399' : [-1,2,-3,4,-1,-2,4,3,-2,-3,-3,4],
'12n_400' : [-1,2,3,-4,-1,2,-4,-3,2,-3,-3,-4],
'12n_401' : [-1,2,-3,4,-1,2,4,-3,2,3,3,4],
'12n_402' : [1,1,1,2,-3,2,3,1,2,-3,2,1,3],
'12n_403' : [1,1,1,-2,3,3,2,-1,2,-3,-1,-2,1],
'12n_404' : [-1,-2,3,4,2,3,3,4,2,1,1,2,3,-4],
'12n_405' : [-1,2,-3,-4,-1,2,-4,-3,2,-3,-4,-3],
'12n_406' : [-1,2,-1,-2,-3,-3,-3,-4,-2,3,-2,-4,-3,-3],
'12n_407' : [-1,2,-1,-2,-3,2,-3,-2,3,-2,-3,-3,-3],
'12n_408' : [-1,2,-1,-2,-3,2,-3,-2,3,4,-2,-3,4,4],
'12n_409' : [-1,2,-1,-2,-3,-3,-2,-2,3,3,-2,-2,3],
'12n_410' : [-1,2,2,3,1,1,-2,3,4,-2,-2,-3,4,3],
'12n_411' : [-1,2,3,4,-3,4,-2,-2,3,-2,3,1,1,2],
'12n_412' : [1,-2,-2,-3,-3,-2,1,2,2,2,-3,-2,-2],
'12n_413' : [1,-2,-3,1,-3,1,2,2,-1,2,-3,-2,1],
'12n_414' : [-1,2,-3,4,-1,-3,2,-3,-2,3,-4,3,-2,4],
'12n_415' : [-1,2,-3,-1,-3,-1,2,-1,2,-3,1,2,-1],
'12n_416' : [1,-2,-2,-3,1,1,2,2,3,1,3,-2,1],
'12n_417' : [-1,2,2,1,1,2,2,2,1,1,2,2],
'12n_418' : [-1,2,3,-1,3,3,2,2,2,3,-2,3,3],
'12n_419' : [1,2,2,1,1,2,2,3,3,-2,1,-2,-3],
'12n_420' : [-1,2,3,-1,-1,-2,3,-4,3,-2,3,-4],
'12n_421' : [-1,2,3,-4,-1,2,3,3,-4,3,2,-4,-3,-3],
'12n_422' : [-1,2,3,4,-1,2,-3,-3,4,-3,2,4,-3,-3],
'12n_423' : [-1,2,-3,4,-1,-2,-3,-3,4,-3,-2,4,3,3],
'12n_424' : [-1,2,-1,-2,-3,2,-3,2,2,-3,2,-3,-3],
'12n_425' : [1,2,-3,1,-3,2,-1,2,-3,1,2,1,2],
'12n_426' : [-1,-2,-3,-1,-3,-2,1,-2,-3,-1,-2,-1,-2],
'12n_427' : [1,1,-2,-3,1,2,2,3,1,3,-2,1,-2],
'12n_428' : [-1,2,-1,-2,-3,-3,-3,2,-3,-3,2,-3,-3],
'12n_429' : [-1,-2,-3,-3,-4,-2,3,1,-4,1,-2,3,-2,-4],
'12n_430' : [-1,2,-3,-3,2,1,1,-2,3,4,-2,-3,4,3],
'12n_431' : [-1,2,-3,-3,2,1,1,-2,3,-4,-2,3,-4,3],
'12n_432' : [-1,-2,3,4,2,2,3,1,3,4,1,2,3,-4],
'12n_433' : [-1,2,-1,-2,3,4,2,4,3,-2,3,4,2,3],
'12n_434' : [-1,2,-3,-1,-3,2,-3,-4,2,2,3,-4],
'12n_435' : [-1,2,3,-4,-1,-2,3,-2,-2,3,3,-4],
'12n_436' : [-1,2,3,-4,-1,-2,3,-2,-2,-3,-3,-4],
'12n_437' : [-1,2,-1,-2,-3,-3,4,-2,4,-2,3,3,4,3],
'12n_438' : [1,-2,3,3,2,2,2,-1,2,-3,-1,-2,1],
'12n_439' : [-1,-2,-3,1,-3,2,-1,2,-3,1,-2,-1,2],
'12n_440' : [1,-2,3,3,-2,-2,-2,1,-2,-3,1,-2,1],
'12n_441' : [1,1,-2,-3,1,-2,1,2,2,3,3,2,2],
'12n_442' : [-1,2,3,-1,-2,3,4,3,-2,3,-2,-4,-4,-4],
'12n_443' : [1,2,3,-1,3,-2,1,-2,-3,-1,2,1,-2],
'12n_444' : [-1,2,-3,4,-1,-3,-1,2,3,-4,3,4],
'12n_445' : [-1,2,-3,-1,2,-3,4,-3,2,-3,-2,-4,-4,-4],
'12n_446' : [-1,2,-3,-4,-1,2,-4,3,-4,3,-4,-4],
'12n_447' : [1,-2,3,3,-2,1,-2,-2,-2,-3,1,-2,1],
'12n_448' : [-1,2,-1,2,-3,-3,4,-2,3,-2,3,-2,4,3],
'12n_449' : [-1,2,3,-4,-1,3,-2,3,-4,3,-2,3],
'12n_450' : [-1,2,3,-4,-1,-1,-2,3,-2,-4,3,-4],
'12n_451' : [-1,2,-3,-1,2,-3,-2,3,-2,-3,2,-3,-2],
'12n_452' : [-1,2,3,1,3,-2,1,-2,-3,1,2,-1,2],
'12n_453' : [-1,-2,-2,-3,-3,-2,-2,-3,-4,-1,-1,2,3,-4],
'12n_454' : [-1,2,-1,-2,3,-2,3,-2,-3,2,-3,-3,-3],
'12n_455' : [-1,2,3,-1,2,2,2,2,3,3,-2,3,-2],
'12n_456' : [-1,-2,-2,-1,-1,-2,3,4,2,2,2,-3,4,3],
'12n_457' : [-1,2,-1,-2,-3,-4,3,-4,-3,-2,-2,3,3,3],
'12n_458' : [-1,2,3,-4,-1,3,-1,2,3,-4,3,-4],
'12n_459' : [-1,2,-3,-4,-1,-1,2,-3,2,-4,-3,-4],
'12n_460' : [-1,2,3,-4,-1,3,-4,-2,3,2,-4,-3],
'12n_461' : [-1,2,3,-4,-1,-2,3,-4,3,-2,3,-4],
'12n_462' : [-1,2,3,4,-1,-2,-3,4,3,-2,3,-4],
'12n_463' : [-1,2,-3,-4,-1,2,3,-4,-3,2,-3,4],
'12n_464' : [1,-2,3,3,2,-1,2,-1,2,2,-3,-2,1],
'12n_465' : [-1,2,-1,2,-3,-3,4,-2,3,3,-2,3,4,3],
'12n_466' : [-1,2,2,2,-1,2,1,-2,1,2,2,2],
'12n_467' : [-1,2,2,2,2,-1,-1,-2,-2,-2,-2,-2],
'12n_468' : [-1,-2,-2,-2,-2,-1,-1,2,2,2,2,2],
'12n_469' : [1,2,-1,2,2,3,-1,3,2,-3,2,1,-2],
'12n_470' : [-1,2,2,2,2,-3,-3,-2,-2,-2,-1,2,-3],
'12n_471' : [1,-2,-2,-2,-2,-3,-3,2,2,2,1,-2,-3],
'12n_472' : [-1,-2,-2,-2,-2,-1,-1,-2,-2,-2,-2,-2],
'12n_473' : [-1,-2,-2,-2,-2,-3,-3,-2,-2,-2,-1,2,-3],
'12n_474' : [-1,-2,-3,-3,-2,-2,-2,-2,-2,-3,-2,-1,2],
'12n_475' : [-1,-2,-3,-3,2,2,2,2,2,-3,-2,-1,2],
'12n_476' : [1,2,-3,-3,-2,-2,-2,-2,-2,-3,2,1,-2],
'12n_477' : [-1,2,3,4,-3,4,2,2,3,2,3,1,1,2],
'12n_478' : [-1,2,-1,-2,3,-2,3,4,4,3,-2,-4,-3,-3],
'12n_479' : [-1,2,-3,-4,2,3,-4,3,-2,3,1,4,1,2],
'12n_480' : [-1,2,3,-1,3,-4,-2,3,2,-4,2,-3],
'12n_481' : [-1,2,3,-1,3,-4,3,-2,3,2,-4,-3],
'12n_482' : [-1,2,3,-1,3,-2,-2,1,1,-2,-3,2,-1],
'12n_483' : [-1,2,3,3,-2,-2,1,1,-2,-3,2,-1,2],
'12n_484' : [1,-2,-3,-3,2,2,2,1,-2,-3,1,-2,1],
'12n_485' : [1,-2,-3,-3,2,-1,2,-3,1,1,1,-2,1],
'12n_486' : [1,2,-3,-3,-2,1,-2,-1,2,2,-3,2,1],
'12n_487' : [1,2,-3,-3,-2,-2,-1,-1,-2,-3,2,1,-2],
'12n_488' : [-1,2,-1,-2,-3,2,-3,-2,3,-2,3,3,3],
'12n_489' : [-1,2,2,-3,1,-3,1,2,-3,4,2,-3,4,3],
'12n_490' : [-1,2,3,3,2,-1,-1,-2,3,4,-3,4,-2,-3],
'12n_491' : [-1,2,3,4,-1,-3,4,2,-3,2,3,-2,-2,3],
'12n_492' : [1,2,-3,-3,-2,-2,1,1,-2,-3,2,1,-2],
'12n_493' : [1,-2,-2,1,1,-2,-2,3,3,-2,1,-2,-3],
'12n_494' : [-1,2,3,-4,-1,2,3,2,-4,2,3,3],
'12n_495' : [-1,2,-3,4,2,-1,-1,-2,3,3,3,2,-3,4],
'12n_496' : [-1,2,-3,-4,-1,-2,3,-2,-4,-2,-3,-3],
'12n_497' : [-1,2,3,-2,3,2,-4,-1,-1,2,3,-2,3,-4],
'12n_498' : [-1,2,-3,4,4,-3,2,1,1,2,-3,-4,2,-3],
'12n_499' : [-1,2,3,-4,-1,3,-4,-2,3,-2,-4,3],
'12n_500' : [1,-2,3,-1,3,-1,-1,-1,2,-3,2,-1,-2],
'12n_501' : [-1,2,-3,-2,3,-2,-3,1,-3,-4,3,1,2,-4],
'12n_502' : [1,2,3,1,3,1,1,1,2,-3,2,1,2],
'12n_503' : [-1,2,3,2,3,2,3,1,3,4,-3,1,2,4],
'12n_504' : [-1,2,3,-4,-1,-4,3,2,3,-4,3,-4],
'12n_505' : [-1,2,-3,-4,-1,-4,-3,2,-3,4,-3,4],
'12n_506' : [-1,2,3,-1,-2,3,-4,3,3,-2,3,-4],
'12n_507' : [-1,2,3,-4,-1,-2,-4,3,-2,-4,3,-4],
'12n_508' : [1,2,2,3,1,3,-2,-2,1,1,-2,-3,1],
'12n_509' : [-1,2,3,-1,3,-4,2,3,2,-4,2,3],
'12n_510' : [-1,2,-3,-1,-3,-4,-2,3,-2,-4,-2,-3],
'12n_511' : [-1,2,2,3,-1,3,-2,-2,1,-2,-1,2,-3],
'12n_512' : [1,2,3,-1,3,2,2,-1,2,-3,2,1,-2],
'12n_513' : [-1,2,1,1,1,2,3,3,3,2,-1,2,-3],
'12n_514' : [-1,2,3,3,2,2,2,1,-2,-3,1,2,-1],
'12n_515' : [-1,2,2,3,1,3,1,-2,3,4,-2,-3,4,3],
'12n_516' : [-1,2,2,-3,4,1,1,2,-3,2,4,-3,4,3],
'12n_517' : [-1,2,-3,-1,2,2,-3,-3,2,2,2,-3,-2],
'12n_518' : [1,-2,-2,-3,-1,-3,-2,-2,-2,-3,-1,-2,-2],
'12n_519' : [-1,2,-1,-2,3,-2,3,2,-3,2,-3,-4,3,-4],
'12n_520' : [-1,2,-3,4,-1,-3,-4,-2,3,-2,-4,-3],
'12n_521' : [-1,2,3,-4,-1,3,-4,2,3,2,-4,3],
'12n_522' : [-1,2,-1,-2,-3,2,-3,-2,3,-2,-2,-2,3],
'12n_523' : [-1,2,3,4,-3,4,-2,-2,3,2,-3,1,1,2],
'12n_524' : [-1,2,3,-1,-2,3,4,-5,3,3,2,-3,4,3,-5],
'12n_525' : [-1,2,-1,-2,-3,4,-5,2,3,3,-4,2,3,-4,-5],
'12n_526' : [1,1,2,2,-3,1,-2,1,-2,-2,3,3,2],
'12n_527' : [-1,2,3,3,2,1,1,2,-3,-4,2,3,-4,3],
'12n_528' : [-1,-1,-2,-2,-3,-1,2,-1,-2,-2,-3,-3,2],
'12n_529' : [-1,-2,3,-4,-2,-3,1,1,2,2,3,3,2,-4],
'12n_530' : [-1,-2,3,-2,3,-2,4,1,1,-2,3,-2,3,4],
'12n_531' : [1,2,2,3,1,3,-2,-2,-2,1,-2,-2,-3],
'12n_532' : [-1,2,3,4,-1,2,-3,2,-3,4,-3,2,-3,-3],
'12n_533' : [-1,2,-1,-2,-3,-3,2,2,-3,2,2,-3,-3],
'12n_534' : [-1,2,3,-1,3,-1,-2,1,-2,-3,2,-1,2],
'12n_535' : [-1,2,-3,-1,-3,4,2,4,3,-4,-2,-2,3,-4],
'12n_536' : [-1,2,2,-1,-1,-2,-2,3,3,2,-1,2,-3],
'12n_537' : [-1,2,3,4,-1,2,-3,2,4,-3,2,4,-3,-3],
'12n_538' : [-1,2,-1,-2,-3,-3,2,-3,2,-3,2,-3,-3],
'12n_539' : [1,2,2,3,1,3,-2,-2,1,-2,1,-2,-3],
'12n_540' : [-1,2,3,3,-2,1,-2,-3,-1,2,-1,2,2],
'12n_541' : [-1,2,3,3,-2,1,-2,-3,-1,-1,-1,2,-1],
'12n_542' : [-1,2,-3,4,-1,2,-3,-3,-4,3,-2,-3,-3,4],
'12n_543' : [-1,2,3,3,2,-1,2,-3,1,1,1,2,-1],
'12n_544' : [1,-2,-2,3,-1,3,-1,2,-1,2,-3,-2,-2],
'12n_545' : [-1,2,2,3,-4,3,1,1,-2,3,-2,4,4,3],
'12n_546' : [-1,-1,-1,2,3,3,-2,1,-2,-3,-1,2,-1],
'12n_547' : [-1,2,3,-1,-2,-3,4,-3,-2,4,-3,4,3,-2],
'12n_548' : [1,-2,-3,-3,-2,1,2,2,2,-3,-2,1,-2],
'12n_549' : [1,-2,1,2,-3,2,2,3,1,3,-2,1,-2],
'12n_550' : [-1,-2,-3,-3,-2,1,1,-2,3,-4,3,-4,-2,3],
'12n_551' : [-1,2,3,-1,3,-4,3,2,3,-4,3,3,2,4],
'12n_552' : [-1,2,-3,-1,-3,-4,2,3,2,-4,3,-4],
'12n_553' : [-1,-2,1,-2,3,-4,3,2,-1,2,-3,4,-3,-4],
'12n_554' : [-1,-2,-2,3,-4,5,4,-3,2,-1,4,-2,-5,-2,3,2,-4],
'12n_555' : [-1,2,3,4,-3,4,3,2,1,1,-2,-2,-3,4,-3,2],
'12n_556' : [-1,-2,1,-2,-3,4,-3,2,-1,2,3,-4,3,-4],
'12n_557' : [-1,2,2,3,1,3,-4,1,2,2,3,-2,-4,3],
'12n_558' : [-1,2,-1,-2,-3,-4,-4,-3,-2,-2,3,-4,3,3,3,4],
'12n_559' : [1,-2,3,3,-2,1,1,1,-2,-3,1,-2,1],
'12n_560' : [1,-2,3,3,-2,-2,1,1,-2,-3,-2,1,-2],
'12n_561' : [-1,-2,3,3,-2,1,1,-2,3,4,-3,4,-2,3],
'12n_562' : [-1,2,3,-1,3,-2,3,-4,-3,-3,2,2,3,-4],
'12n_563' : [-1,2,2,3,1,3,1,2,-3,-4,2,3,-4,-3],
'12n_564' : [-1,-2,-3,-3,-4,-2,1,1,-2,3,-2,-4,-4,3],
'12n_565' : [1,1,1,-2,3,3,-2,1,-2,-3,1,-2,1],
'12n_566' : [-1,2,-3,4,2,-3,-4,3,2,-3,1,-4,1,2],
'12n_567' : [1,-2,3,3,-2,1,-2,1,-2,-2,-3,-2,1],
'12n_568' : [1,-2,3,3,-2,1,1,-2,1,-2,-3,-2,1],
'12n_569' : [-1,-1,-1,2,2,3,-1,3,-1,-2,1,-2,-3],
'12n_570' : [-1,-2,-2,-2,-2,-2,-2,-1,-1,2,2,2],
'12n_571' : [-1,2,2,2,2,2,2,-1,-1,-2,-2,-2],
'12n_572' : [1,-2,3,1,3,2,-3,2,2,-1,2,-1,2],
'12n_573' : [-1,2,-1,-2,-2,3,-1,3,2,-3,2,-1,2],
'12n_574' : [-1,-2,-2,-2,-2,-2,-2,-1,-1,-2,-2,-2],
'12n_575' : [-1,-2,-3,-3,-2,-2,-2,-3,-2,-2,-2,-1,2],
'12n_576' : [-1,2,-3,-1,-3,-3,-2,-2,-2,-3,-3,-3,-2],
'12n_577' : [-1,2,-1,-2,-3,2,-3,-2,-2,-2,3,-2,3],
'12n_578' : [1,-2,-2,3,-1,3,2,2,2,-3,-1,-2,-2],
'12n_579' : [-1,2,3,-1,3,-4,2,-3,2,-4,-3,-4],
'12n_580' : [-1,2,2,-3,1,-3,1,-2,3,-4,-2,3,-4,-3],
'12n_581' : [-1,-2,-3,-4,2,3,-4,-3,-2,-1,-1,-2,-2,-2],
'12n_582' : [-1,2,-1,-2,-3,-4,2,-4,-3,-2,3,4,-2,3],
'12n_583' : [-1,2,-3,4,-1,-3,4,4,3,3,4,-2,3,-2],
'12n_584' : [-1,2,-1,-2,3,-4,2,-4,-3,-3,2,4,3,-4],
'12n_585' : [-1,2,-1,-2,-3,-4,-2,-4,-3,-2,-3,4,-2,-3],
'12n_586' : [-1,2,-3,-1,-3,4,2,-3,4,-3,2,2,3,-4],
'12n_587' : [-1,2,3,3,-4,2,1,1,-2,3,-2,-4,-4,-3],
'12n_588' : [1,-2,3,-1,3,2,-1,2,-3,-1,2,-1,-2],
'12n_589' : [1,-2,1,2,3,3,3,2,-1,2,-3,2,2],
'12n_590' : [-1,2,3,-1,3,3,3,3,2,-3,2,3,3],
'12n_591' : [-1,-2,-3,-3,-2,-2,-1,-1,-2,-3,-2,-1,2],
'12n_592' : [-1,2,-3,-1,-3,-3,-3,-3,-2,3,-2,3,3],
'12n_593' : [-1,2,-1,-2,3,-4,-2,-4,-3,-3,-2,4,-3,4],
'12n_594' : [1,2,3,3,2,2,1,1,2,-3,2,1,-2],
'12n_595' : [-1,2,-1,-2,-3,4,-2,4,-3,2,-3,4,-2,-3],
'12n_596' : [-1,2,3,-1,3,-1,-4,2,3,2,-4,3,3,4],
'12n_597' : [1,-2,3,-1,3,2,2,-1,2,-3,2,-1,-2],
'12n_598' : [-1,2,2,1,1,2,-3,4,-2,-3,-2,4,-3,4],
'12n_599' : [1,2,3,3,-2,1,-2,-2,-2,-3,1,2,1],
'12n_600' : [-1,2,-3,-1,-3,-2,-2,-3,-4,3,-4,-2,-3,-2],
'12n_601' : [-1,-2,-3,-3,4,-2,1,1,-2,-3,-3,-3,-2,4,4,3],
'12n_602' : [-1,2,3,-1,-2,3,3,-4,3,2,3,-4,3,-2],
'12n_603' : [1,2,3,1,3,-2,1,-2,-3,1,2,1,2],
'12n_604' : [-1,2,2,-1,-1,2,-1,-1,-2,-2,-2,-2],
'12n_605' : [-1,2,2,-3,1,-3,-2,-2,-2,-3,1,2,2],
'12n_606' : [-1,2,1,-2,1,2,-3,2,-1,2,3,3,2],
'12n_607' : [-1,2,-1,-2,3,-2,3,2,-3,2,3,3,3],
'12n_608' : [-1,2,-1,-2,-3,2,-3,-2,3,-2,3,4,-3,4],
'12n_609' : [-1,2,-3,-1,-3,2,-3,-2,-2,3,-2,-2,3],
'12n_610' : [-1,2,-3,-1,-3,2,2,-3,-2,3,-2,3,3],
'12n_611' : [-1,2,3,4,-1,-2,3,3,3,-2,-3,4,3,-2],
'12n_612' : [-1,2,-3,4,-1,2,4,3,-4,3,4,4],
'12n_613' : [-1,-2,-3,-3,4,-2,1,1,2,-3,2,4,4,-3],
'12n_614' : [-1,2,-3,4,-1,-3,2,-3,2,4,3,3],
'12n_615' : [-1,-2,-3,-3,-2,1,1,2,-3,4,-3,4,2,-3],
'12n_616' : [-1,2,3,-1,3,-4,-2,3,-2,-4,3,-4],
'12n_617' : [-1,2,-3,-1,-3,-4,-2,3,-2,-4,3,-4],
'12n_618' : [-1,2,3,-1,3,-4,2,3,2,-4,3,-4],
'12n_619' : [-1,2,-3,-1,-3,-4,2,-3,2,-4,-3,-4],
'12n_620' : [-1,2,3,-1,3,4,2,-3,2,4,-3,4],
'12n_621' : [-1,-2,-3,-3,-4,-2,1,1,-2,3,-2,-4,3,-2],
'12n_622' : [-1,2,-3,4,2,-3,1,1,-2,-2,-3,-3,-2,4],
'12n_623' : [-1,2,3,-4,-1,2,3,3,3,2,3,-4,3,-2],
'12n_624' : [-1,2,-1,-2,3,3,2,2,3,3,2,2,3],
'12n_625' : [-1,2,-1,-2,3,-4,2,-4,3,2,3,-4,2,3],
'12n_626' : [-1,2,-3,-4,-1,-3,-2,-2,3,-2,3,-4,-3,-3],
'12n_627' : [-1,-1,-2,-3,1,-2,1,2,2,-3,-3,2,2],
'12n_628' : [-1,2,3,-1,-2,3,-2,-4,3,-2,3,-4],
'12n_629' : [-1,2,-3,-1,2,-3,-2,-4,3,-2,3,-4],
'12n_630' : [-1,2,3,-1,-2,3,-2,4,3,-2,3,4],
'12n_631' : [-1,2,-3,-1,2,-3,2,4,3,-2,3,4],
'12n_632' : [-1,2,-3,-1,2,-3,2,-4,-3,2,-3,-4],
'12n_633' : [1,-2,3,3,-2,1,-2,-3,1,-2,1,-2,-2],
'12n_634' : [-1,2,3,-1,-2,3,-4,3,-2,3,3,-4],
'12n_635' : [-1,-2,-3,-3,4,-2,1,1,2,-3,2,4,-3,2],
'12n_636' : [-1,2,-3,4,-1,3,3,4,2,-3,4,-3],
'12n_637' : [-1,2,3,-4,-1,3,3,2,-3,4,4,3,3,-4],
'12n_638' : [1,2,2,-3,1,1,2,2,3,3,2,1,-2],
'12n_639' : [1,2,3,3,-2,1,1,1,-2,-3,1,2,1],
'12n_640' : [-1,2,2,1,1,2,2,2,2,1,1,2],
'12n_641' : [-1,2,-3,-1,-3,-3,-2,3,-2,-2,-2,3,3],
'12n_642' : [-1,2,3,-4,1,3,4,2,-1,2,1,3,-4,3,2,4],
'12n_643' : [-1,2,3,3,2,1,1,-2,3,4,-3,4,-2,3],
'12n_644' : [1,2,2,2,3,1,3,1,2,-3,2,1,-2],
'12n_645' : [-1,2,3,-1,-2,-3,-4,-3,2,-4,3,-4,3,-2],
'12n_646' : [-1,2,-3,-1,-3,-3,-2,-2,3,-2,3,3,3],
'12n_647' : [-1,2,2,1,1,2,2,1,1,2,2,2],
'12n_648' : [-1,2,3,-1,3,3,2,-3,2,3,3,3,3],
'12n_649' : [1,-2,3,3,2,2,1,1,2,-3,-2,1,-2],
'12n_650' : [1,-2,3,3,2,2,-1,-1,2,-3,-2,1,-2],
'12n_651' : [-1,2,-3,4,-1,2,3,3,3,2,4,-3,-2,4],
'12n_652' : [-1,-1,-2,-2,-3,1,-2,1,2,2,-3,-3,2],
'12n_653' : [-1,2,3,-1,3,3,2,2,2,-3,2,3,3],
'12n_654' : [-1,2,-1,-2,3,-4,-2,-4,-3,-2,-3,4,-2,3],
'12n_655' : [-1,2,-1,-2,-3,-3,-2,-2,-3,-3,-2,-2,3],
'12n_656' : [-1,2,-1,-2,-3,-4,-2,-4,3,3,-2,-4,3,4],
'12n_657' : [-1,2,-3,-1,-3,-3,-2,3,-2,3,3,3,3],
'12n_658' : [-1,2,-3,-1,-3,-3,-2,-2,-2,3,-2,3,3],
'12n_659' : [-1,2,3,-1,3,3,2,-3,2,3,3,4,-3,4],
'12n_660' : [-1,2,-3,-3,-2,-2,-3,-1,-3,-2,3,-2,-2],
'12n_661' : [-1,2,3,-1,3,4,-2,-3,4,-3,2,2,3,4],
'12n_662' : [-1,2,-1,-2,-3,4,2,2,-3,-3,2,2,3,4],
'12n_663' : [-1,2,3,-4,-1,2,3,3,3,2,-4,3,-2,-4],
'12n_664' : [-1,2,3,-4,-1,3,-4,2,3,-4,3,-4],
'12n_665' : [-1,-2,-2,-1,-1,-2,3,-4,2,3,2,-4,3,-4],
'12n_666' : [-1,2,-1,2,-1,2,-1,-2,-2,-2,-2,-2],
'12n_667' : [1,-2,3,1,3,2,-3,2,2,1,-2,1,-2],
'12n_668' : [1,-2,3,1,3,2,2,2,1,-3,-2,1,-2],
'12n_669' : [-1,2,3,-1,-2,-3,-4,3,-2,-4,3,-4,3,-2],
'12n_670' : [1,2,2,1,1,1,-2,-3,-2,-2,1,-3,-3],
'12n_671' : [-1,2,2,-1,-1,-1,-2,-3,-2,-2,-1,-3,-3],
'12n_672' : [-1,2,2,-3,4,3,-1,-1,-2,3,3,2,4,3,3,-2],
'12n_673' : [1,1,1,2,2,1,-2,-3,-2,-2,1,-3,-3],
'12n_674' : [-1,-1,-1,2,2,-1,-1,-2,-2,-2,-2,-2],
'12n_675' : [-1,-1,-1,-2,-2,-1,-1,2,2,2,2,2],
'12n_676' : [-1,-2,-2,3,4,-3,-1,4,3,-1,2,2,3,-2],
'12n_677' : [-1,2,3,1,3,1,1,1,2,-3,2,-1,2],
'12n_678' : [-1,2,3,-1,3,2,-3,2,-1,-2,-2,-2,-2],
'12n_679' : [-1,-1,-1,-2,-2,-1,-1,-2,-2,-2,-2,-2],
'12n_680' : [-1,2,-1,-2,-2,-2,-3,-3,-2,-2,-3,-3,-3],
'12n_681' : [1,1,2,2,1,1,-2,-3,-2,-2,1,-3,-3],
'12n_682' : [-1,-1,2,2,-1,-1,-2,-3,-2,-2,-1,-3,-3],
'12n_683' : [-1,2,-1,2,-1,-1,-1,-2,1,-2,-2,-2],
'12n_684' : [-1,2,-1,2,-1,-1,-1,2,-1,-2,-2,-2],
'12n_685' : [-1,2,-1,-2,3,3,-2,-2,-3,-3,-2,-2,3],
'12n_686' : [-1,2,-1,-2,-3,2,-3,-3,-3,2,-3,2,-3],
'12n_687' : [-1,2,-1,-2,3,4,-2,4,-3,-3,-2,-4,3,-4],
'12n_688' : [-1,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-2],
'12n_689' : [1,2,2,2,3,1,3,1,1,2,-3,2,1],
'12n_690' : [-1,-2,-2,3,-1,3,-1,2,-3,4,2,-3,4,3],
'12n_691' : [1,2,3,3,2,1,1,1,2,-3,2,2,1],
'12n_692' : [1,2,3,3,2,2,1,1,1,2,-3,2,1],
'12n_693' : [-1,-2,-2,3,-1,-1,-2,-2,-3,-3,-4,2,3,-4],
'12n_694' : [-1,-2,-2,-3,-1,-1,-2,-2,-3,-3,-2,-1,2],
'12n_695' : [1,2,-1,2,1,-3,1,-3,-3,2,1,-3,-3],
'12n_696' : [-1,-2,-2,3,-4,-1,-1,-2,3,-2,-4,3,-4,-3],
'12n_697' : [-1,-2,-2,3,-1,3,-1,-2,3,-4,-2,3,-4,-3],
'12n_698' : [1,2,3,3,2,-1,2,-3,-1,2,2,2,1],
'12n_699' : [-1,2,-1,-2,3,-2,-3,-4,-4,-3,2,-3,4,-3],
'12n_700' : [-1,2,-1,2,3,3,3,3,2,1,1,2,-3],
'12n_701' : [-1,2,3,4,-3,4,3,-2,3,1,-4,3,1,2],
'12n_702' : [-1,2,3,3,2,-1,-2,-2,-2,-3,2,-1,2],
'12n_703' : [-1,2,-1,-2,-3,2,-3,2,-3,2,-3,-3,-3],
'12n_704' : [-1,2,-3,4,-1,-3,2,-3,-2,3,4,-3,-2,4],
'12n_705' : [-1,2,3,-4,-1,2,2,-3,2,-3,-3,-4,3,-2],
'12n_706' : [1,2,-3,-4,1,2,-3,1,2,-4,-3,-4],
'12n_707' : [-1,2,2,2,1,-2,1,-2,1,2,2,2],
'12n_708' : [-1,2,2,2,-1,2,-1,-2,1,-2,-2,-2],
'12n_709' : [-1,2,2,2,-1,2,-1,2,-1,-2,-2,-2],
'12n_710' : [-1,2,-1,-2,3,3,2,2,-3,-3,2,2,3],
'12n_711' : [-1,2,-1,-2,-3,2,-3,2,-3,2,2,2,-3],
'12n_712' : [1,-2,3,3,-2,1,-2,-2,-2,-3,-2,1,-2],
'12n_713' : [1,1,1,-2,3,3,-2,1,-2,-3,-2,1,-2],
'12n_714' : [1,-2,1,-2,-3,-2,1,2,2,-3,-3,-2,-2],
'12n_715' : [-1,2,3,-4,-2,-3,4,-3,2,-3,1,-4,1,2],
'12n_716' : [1,-2,3,1,3,1,-2,1,-2,-3,-2,1,-2],
'12n_717' : [-1,-1,2,2,-3,1,-2,1,2,2,3,3,2],
'12n_718' : [-1,-2,1,-2,-1,2,-3,2,-1,2,3,3,2],
'12n_719' : [-1,2,-1,-2,3,-2,3,-2,3,-2,-3,-3,-3],
'12n_720' : [-1,2,-3,4,2,3,1,3,1,-2,3,-2,3,4],
'12n_721' : [-1,-2,-2,-1,-1,-1,-1,2,2,2,2,2],
'12n_722' : [-1,2,2,-1,-1,-1,-1,-2,-2,-2,-2,-2],
'12n_723' : [1,2,3,-1,3,-1,-1,-1,2,-3,2,1,-2],
'12n_724' : [1,-2,3,1,3,1,1,1,2,-3,2,-1,2],
'12n_725' : [-1,-2,-2,-1,-1,-1,-1,-2,-2,-2,-2,-2],
'12n_726' : [-1,2,-3,2,3,-2,3,1,3,4,-3,1,2,4],
'12n_727' : [-1,2,3,4,-1,2,2,-3,4,-2,-2,3,-2,3],
'12n_728' : [-1,2,3,2,3,-1,-1,2,-3,2,-1,2,3],
'12n_729' : [-1,2,3,2,3,1,1,2,-3,2,-1,2,3],
'12n_730' : [1,2,3,2,3,-1,-1,2,-3,2,1,-2,3],
'12n_731' : [-1,-2,3,4,-2,-2,-3,1,1,2,-3,2,4,3],
'12n_732' : [-1,2,3,-4,-1,-2,3,4,4,3,2,2,3,-4],
'12n_733' : [-1,2,-1,-2,-3,2,-3,2,-3,2,-3,-4,3,-4],
'12n_734' : [1,2,3,3,2,-1,2,2,2,-3,-1,2,1],
'12n_735' : [-1,2,-1,-2,-3,-3,-4,-4,-3,-2,3,-2,-3,4,2,3],
'12n_736' : [-1,2,3,-4,-1,2,2,3,-4,3,-2,3,4,4],
'12n_737' : [1,2,3,-1,3,2,-1,2,-3,-1,2,1,-2],
'12n_738' : [-1,2,2,1,1,2,2,3,3,2,-1,2,-3],
'12n_739' : [-1,-2,-2,-1,-1,-2,-2,3,3,2,-1,2,-3],
'12n_740' : [1,-2,3,-1,3,2,-1,2,-3,-1,-2,1,-2],
'12n_741' : [1,-2,3,3,-2,1,-2,-3,-2,1,-2,-2,-2],
'12n_742' : [-1,-1,2,2,1,1,2,-3,2,-1,2,3,3],
'12n_743' : [-1,2,-1,-2,3,4,-2,4,-3,2,-3,-4,-2,3],
'12n_744' : [-1,2,3,3,2,1,1,-2,3,4,-2,-3,4,3],
'12n_745' : [-1,2,-1,-2,3,-4,2,-4,-3,2,-3,4,2,3],
'12n_746' : [-1,2,-1,-2,-3,-4,2,-4,-3,2,-3,4,2,-3],
'12n_747' : [-1,2,2,1,1,-2,-2,1,1,2,2,2],
'12n_748' : [-1,2,2,-1,-1,2,2,-1,-1,-2,-2,-2],
'12n_749' : [-1,-2,-2,-1,-1,-2,-2,-1,-1,2,2,2],
'12n_750' : [-1,2,2,-1,-1,-2,-2,-1,-1,-2,-2,-2],
'12n_751' : [-1,2,2,-1,-1,-2,-2,-1,-1,2,2,2],
'12n_752' : [-1,2,-1,-2,3,-2,3,2,2,2,3,-2,3],
'12n_753' : [-1,2,1,1,2,-3,2,-1,2,2,3,3,2],
'12n_754' : [-1,2,-1,-2,-3,2,-3,2,2,2,-3,2,-3],
'12n_755' : [-1,2,-1,-2,-3,2,-3,-2,-2,3,-2,4,-3,4],
'12n_756' : [-1,2,-1,-2,3,3,4,2,2,-3,-2,4,-2,3],
'12n_757' : [-1,-2,3,-4,2,2,3,1,1,-2,3,-2,-4,3],
'12n_758' : [-1,2,-3,4,2,3,1,1,2,2,3,3,2,4],
'12n_759' : [-1,2,3,3,2,1,1,2,-3,-4,2,3,-4,-3],
'12n_760' : [-1,-2,3,2,-3,2,-4,1,1,2,-3,2,-3,-4],
'12n_761' : [-1,2,3,-4,-1,3,2,2,3,3,-4,2,3,-2],
'12n_762' : [-1,2,-1,-2,3,3,-4,2,2,3,2,-4,2,3],
'12n_763' : [-1,2,3,-2,3,2,-4,3,1,1,-2,-2,-3,-3,2,-4],
'12n_764' : [1,1,2,2,-3,1,-2,1,2,2,3,3,2],
'12n_765' : [-1,2,3,-1,-2,-3,-3,4,-3,-2,-2,-3,-3,4],
'12n_766' : [-1,2,3,4,-1,4,3,3,2,-3,2,-4,3,3],
'12n_767' : [-1,2,-1,-1,-1,2,2,1,1,1,1,2],
'12n_768' : [-1,2,-1,-2,-3,-3,2,2,-3,-2,-2,3,3],
'12n_769' : [1,2,3,3,2,2,-1,-1,2,-3,2,1,-2],
'12n_770' : [-1,2,3,3,2,2,1,1,2,-3,2,-1,2],
'12n_771' : [-1,2,3,-1,3,2,2,1,1,2,-3,2,-1],
'12n_772' : [-1,2,3,-1,3,-2,-2,-1,-1,2,-3,2,-1],
'12n_773' : [1,-2,-2,3,3,-2,1,-2,-2,-2,-3,-2,-2],
'12n_774' : [-1,2,-3,4,-1,-3,-3,2,-3,-2,3,4,-3,-2],
'12n_775' : [-1,-2,-3,-3,4,-2,-3,1,1,2,-3,4,-3,2],
'12n_776' : [-1,-2,-3,-2,-3,-2,4,1,1,2,-3,2,-3,4],
'12n_777' : [1,2,3,3,2,-1,-1,-1,2,-3,-1,2,1],
'12n_778' : [-1,2,3,-1,3,3,2,2,3,3,-2,3,-2],
'12n_779' : [1,-2,-3,-3,2,-1,2,-3,1,-2,1,-2,-2],
'12n_780' : [-1,2,3,-4,-1,2,-4,2,3,-2,3,4,-3,4],
'12n_781' : [-1,2,3,2,3,-1,-1,2,-3,-1,2,3,-1],
'12n_782' : [1,-2,-2,3,1,3,1,-2,1,-2,-3,-2,-2],
'12n_783' : [-1,2,-3,4,-1,2,2,3,3,4,2,-3,-2,4],
'12n_784' : [-1,2,3,-4,-1,2,2,3,3,-4,2,3,-2,-4],
'12n_785' : [-1,2,3,3,2,1,1,2,-3,-4,3,-4,2,-3],
'12n_786' : [-1,2,-3,-3,2,1,1,2,-3,4,2,-3,4,3],
'12n_787' : [-1,2,-1,-2,-3,2,2,-3,2,2,-3,-3,-3],
'12n_788' : [-1,2,-1,-2,3,3,-2,-2,-3,-4,2,2,3,-4],
'12n_789' : [-1,2,-1,-2,-3,-3,4,2,3,3,4,2,-3,4],
'12n_790' : [-1,2,-3,2,-3,-2,3,-1,2,-3,-1,2,2],
'12n_791' : [1,2,3,3,-2,1,1,-2,1,-2,-3,2,1],
'12n_792' : [-1,2,-1,-2,-3,2,2,2,2,-3,2,2,-3],
'12n_793' : [-1,2,3,-1,3,3,3,2,-3,-3,2,2,3],
'12n_794' : [-1,2,3,4,-1,-2,-2,3,3,4,-2,3,-2,-4],
'12n_795' : [-1,2,-3,-4,3,-4,2,2,3,-2,3,1,1,2],
'12n_796' : [1,2,2,2,3,3,2,-1,2,-3,-1,2,1],
'12n_797' : [-1,2,-3,2,3,-2,4,-3,1,4,3,1,2,-3,2,3],
'12n_798' : [-1,2,3,-2,3,2,-4,1,1,-2,3,-2,3,-4],
'12n_799' : [-1,2,-3,2,-3,2,4,1,1,-2,3,-2,3,4],
'12n_800' : [1,2,3,3,-2,1,-2,1,-2,-2,-3,2,1],
'12n_801' : [-1,-2,1,-2,-3,2,-1,-3,-2,3,-2,-3,-3],
'12n_802' : [-1,2,-3,-1,2,2,-3,-3,-2,3,-2,3,3],
'12n_803' : [-1,2,-3,-1,2,-3,-3,2,-3,-3,2,-3,-2],
'12n_804' : [1,-2,-2,3,1,3,2,2,2,-3,1,-2,-2],
'12n_805' : [-1,2,3,-1,-2,-3,-4,3,-2,3,-4,3,3,-2],
'12n_806' : [1,1,2,2,1,1,-2,-3,2,-1,2,3,3,2,2],
'12n_807' : [1,-2,1,2,3,2,-1,3,2,-3,2,3,3],
'12n_808' : [1,2,3,3,-2,-2,1,-2,-3,-3,-2,-2,-3],
'12n_809' : [-1,2,3,4,-1,2,2,2,-3,2,-3,-2,4,-2,3,2],
'12n_810' : [-1,2,-3,4,-1,-2,4,3,-2,3,3,-4,3,-4],
'12n_811' : [1,-2,-1,2,-3,2,-1,-3,-2,3,-2,-3,-3],
'12n_812' : [1,2,-1,2,-3,2,1,-3,-2,3,-2,-3,-3],
'12n_813' : [-1,2,-3,4,-1,-2,4,-2,3,-2,3,-4,3,-4],
'12n_814' : [-1,-2,-3,-3,-4,-2,3,1,-4,-3,1,-2,3,-2,3,-4],
'12n_815' : [-1,2,-3,-2,3,1,1,2,-3,2,-1,2,-3],
'12n_816' : [-1,2,-3,-4,-1,3,3,-2,-2,3,-4,3,-2,3],
'12n_817' : [-1,2,3,-1,3,2,-3,-3,-3,-3,2,2,3],
'12n_818' : [-1,2,-1,-2,3,-4,2,2,3,-4,-3,2,2,3],
'12n_819' : [-1,2,3,-1,3,-1,-2,1,-2,-3,-1,2,-1],
'12n_820' : [-1,2,2,1,1,-2,1,1,2,2,2,2],
'12n_821' : [-1,-2,-2,1,1,-2,-1,-1,2,2,2,2],
'12n_822' : [-1,2,2,-1,-1,-2,1,1,-2,-2,-2,-2],
'12n_823' : [-1,2,-1,-2,3,-2,-2,-3,-3,-3,-2,-2,3],
'12n_824' : [-1,2,3,-1,2,2,3,3,-2,-2,-2,3,-2],
'12n_825' : [1,-2,1,-2,-2,3,1,3,2,-3,2,-1,2],
'12n_826' : [-1,2,3,-4,-1,2,-3,2,-3,-3,-3,-4,3,-2],
'12n_827' : [-1,2,-1,-2,-3,2,-3,-3,2,-3,2,2,-3],
'12n_828' : [1,-2,3,3,-2,1,-2,-3,-2,-2,1,-2,1],
'12n_829' : [-1,2,2,1,1,-2,-2,-2,1,1,2,2],
'12n_830' : [-1,2,2,-1,-1,-2,-2,-2,-1,-1,-2,-2],
'12n_831' : [-1,2,2,-1,-1,-2,-2,-2,-1,-1,2,2],
'12n_832' : [-1,2,-1,-2,3,3,2,2,-3,2,2,3,3],
'12n_833' : [-1,2,2,-1,2,2,3,-1,3,-2,1,-2,-3],
'12n_834' : [-1,2,-1,-2,-3,2,-3,-4,-4,-3,2,-3,-3,4],
'12n_835' : [1,2,3,-2,3,-1,-1,2,-3,2,1,-2,-3],
'12n_836' : [1,1,2,2,-3,-1,2,-1,2,2,3,3,2],
'12n_837' : [1,-2,-3,4,1,-2,-3,1,-2,4,-3,4],
'12n_838' : [-1,-2,3,-4,1,-2,-3,-1,2,4,-3,-4],
'12n_839' : [-1,2,-3,-4,-1,2,-3,-1,2,-4,-3,-4],
'12n_840' : [1,2,-3,4,1,-3,2,1,-3,2,4,-3],
'12n_841' : [-1,2,-1,-2,-3,4,-3,2,4,3,3,2,4,-3],
'12n_842' : [-1,-2,-3,-3,4,-2,-3,1,4,1,2,-3,2,4],
'12n_843' : [-1,2,-3,4,-1,-3,-2,3,-2,-3,4,-3,-2,4],
'12n_844' : [1,2,-3,-4,-3,2,1,-3,-4,-3,5,4,-2,-3,4,3,-5],
'12n_845' : [1,-2,3,3,-2,1,1,1,-2,-3,-2,1,-2],
'12n_846' : [-1,-2,3,-2,3,-2,1,1,-2,3,4,-3,-2,4],
'12n_847' : [-1,2,-3,2,-3,2,1,1,-2,3,4,-3,-2,4],
'12n_848' : [1,-2,3,3,2,1,1,1,2,-3,-2,1,-2],
'12n_849' : [-1,2,3,3,2,1,1,1,2,-3,2,-1,2],
'12n_850' : [-1,2,2,2,2,1,1,2,2,1,1,2],
'12n_851' : [-1,2,-1,-2,-2,-3,-3,-2,-2,-3,2,-3,-2],
'12n_852' : [-1,2,-3,2,-3,2,-3,-2,-1,2,-3,2,2],
'12n_853' : [-1,-1,-2,-2,-3,-1,2,-1,2,2,3,3,2],
'12n_854' : [-1,-2,3,-4,2,2,3,1,3,-4,1,2,3,-4],
'12n_855' : [1,1,1,-2,-2,3,3,-2,1,-2,-3,-2,-2],
'12n_856' : [-1,-2,-2,-3,4,3,-2,-2,1,1,-2,3,-2,4],
'12n_857' : [-1,2,-1,-2,3,-4,3,2,-4,3,3,2,-4,3],
'12n_858' : [-1,2,-1,-2,-3,4,2,4,3,3,2,4,-3,4],
'12n_859' : [-1,2,-1,-2,3,-4,2,-4,3,3,2,-4,3,-4],
'12n_860' : [-1,-2,-2,1,-2,-2,3,-1,3,2,-1,2,-3],
'12n_861' : [-1,2,3,3,2,1,-2,1,2,2,-3,2,-1],
'12n_862' : [1,2,3,3,2,-1,-1,2,-1,2,-3,2,1],
'12n_863' : [1,2,3,3,2,-1,2,-1,2,2,-3,2,1],
'12n_864' : [-1,2,3,3,-2,-2,3,-1,-2,3,-2,-2,-2],
'12n_865' : [-1,2,3,3,-2,-2,3,-1,3,3,-2,3,-2],
'12n_866' : [1,-2,3,-2,3,-2,3,2,1,2,-3,-2,-2],
'12n_867' : [1,1,-2,1,1,2,-3,2,-1,2,3,3,2],
'12n_868' : [1,-2,-3,2,-3,-1,-1,2,-3,2,1,-2,3],
'12n_869' : [-1,2,-3,-4,-1,3,3,-4,-2,-2,3,-4,-2,3],
'12n_870' : [-1,2,-1,-2,-3,-3,-4,2,3,3,-4,2,3,-4],
'12n_871' : [1,2,-1,2,-3,4,2,3,1,3,2,-3,4,-3],
'12n_872' : [-1,2,-1,-2,3,3,-4,2,3,3,-4,2,3,-4],
'12n_873' : [1,2,-3,-4,2,-3,1,2,-3,2,-4,-3],
'12n_874' : [-1,-2,-3,2,-3,2,-1,2,-1,-3,2,-1,3],
'12n_875' : [-1,2,-1,-2,-3,2,2,-3,-3,-3,2,2,-3],
'12n_876' : [-1,2,-1,-2,-3,-4,2,2,3,-4,-3,2,2,-3],
'12n_877' : [-1,2,-3,-4,2,-3,-1,2,-3,2,-4,-3],
'12n_878' : [-1,-2,-3,-3,-4,-2,3,1,1,-2,3,4,4,3,2,2],
'12n_879' : [-1,2,-3,-1,2,-3,2,-3,-3,-2,-2,3,3],
'12n_880' : [-1,2,3,-1,3,-2,1,-2,-3,-1,2,-1,2],
'12n_881' : [-1,2,3,-2,3,2,4,1,4,1,3,2,-3,2,3,-4],
'12n_882' : [-1,2,2,2,1,1,-2,1,1,2,2,2],
'12n_883' : [1,-2,3,3,-2,1,-2,-3,-2,-2,-2,1,-2],
'12n_884' : [-1,2,-1,-2,-3,2,-3,4,-2,4,3,-2,3,-4],
'12n_885' : [-1,2,-3,4,-1,3,-2,-3,2,4,-3,2,-3,4],
'12n_886' : [-1,2,-1,-2,-3,2,-3,-4,2,-4,-3,2,-3,4],
'12n_887' : [-1,2,-1,2,-1,2,-1,-1,-2,-2,-2,-1],
'12n_888' : [-1,-1,-1,-2,-2,-2,-1,-1,-1,-2,-2,-2]
}
